/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0011H\u0002J\u001e\u0010!\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020\u0018H\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\u0014\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180-J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020%H\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/PropertyTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "declaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "propertyName", "", "accessorDescription", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "contextWithPropertyMetadataCreationIntrinsified", "delegatedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "accessor", "generateDefaultAccessor", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "function", "Lorg/jetbrains/kotlin/com/google/dart/compiler/backend/js/ast/JsFunction;", "generateDefaultGetter", "generateDefaultGetterFunction", "getterDescriptor", "generateDefaultSetter", "generateDefaultSetterFunction", "setterDescriptor", "generateDelegatedGetterFunction", "generateGetter", "generateSetter", "getCustomGetterDeclaration", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getCustomSetterDeclaration", "hasCustomGetter", "", "hasCustomSetter", "translate", "", "result", "", "translateCustomAccessor", "expression", "kotlin-compiler"})
final class PropertyTranslator
extends AbstractTranslator {
    private final String propertyName;
    @NotNull
    private final VariableDescriptorWithAccessors descriptor;
    @Nullable
    private final KtProperty declaration;

    public final void translate(@NotNull List<JsPropertyInitializer> result2) {
        Intrinsics.checkParameterIsNotNull(result2, "result");
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        PropertyTranslatorKt.addGetterAndSetter(result2, this.descriptor, translationContext, (Function0<? extends JsPropertyInitializer>)new Function0<JsPropertyInitializer>(this){
            final /* synthetic */ PropertyTranslator this$0;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return PropertyTranslator.access$generateGetter(this.this$0);
            }
            {
                this.this$0 = propertyTranslator;
                super(0);
            }
        }, (Function0<? extends JsPropertyInitializer>)new Function0<JsPropertyInitializer>(this){
            final /* synthetic */ PropertyTranslator this$0;

            @NotNull
            public final JsPropertyInitializer invoke() {
                return PropertyTranslator.access$generateSetter(this.this$0);
            }
            {
                this.this$0 = propertyTranslator;
                super(0);
            }
        });
    }

    private final JsPropertyInitializer generateGetter() {
        return this.hasCustomGetter() ? this.translateCustomAccessor(this.getCustomGetterDeclaration()) : this.generateDefaultGetter();
    }

    private final JsPropertyInitializer generateSetter() {
        return this.hasCustomSetter() ? this.translateCustomAccessor(this.getCustomSetterDeclaration()) : this.generateDefaultSetter();
    }

    private final boolean hasCustomGetter() {
        KtProperty ktProperty = this.declaration;
        return (ktProperty != null ? ktProperty.getGetter() : null) != null && this.getCustomGetterDeclaration().hasBody();
    }

    private final boolean hasCustomSetter() {
        KtProperty ktProperty = this.declaration;
        return (ktProperty != null ? ktProperty.getSetter() : null) != null && this.getCustomSetterDeclaration().hasBody();
    }

    private final KtPropertyAccessor getCustomGetterDeclaration() {
        KtDeclarationStub ktDeclarationStub = this.declaration;
        if (ktDeclarationStub == null || (ktDeclarationStub = ktDeclarationStub.getGetter()) == null) {
            throw (Throwable)new IllegalStateException("declaration and getter should not be null descriptor=" + this.descriptor + " declaration=" + this.declaration);
        }
        return ktDeclarationStub;
    }

    private final KtPropertyAccessor getCustomSetterDeclaration() {
        KtDeclarationStub ktDeclarationStub = this.declaration;
        if (ktDeclarationStub == null || (ktDeclarationStub = ktDeclarationStub.getSetter()) == null) {
            throw (Throwable)new IllegalStateException("declaration and setter should not be null descriptor=" + this.descriptor + " declaration=" + this.declaration);
        }
        return ktDeclarationStub;
    }

    private final JsPropertyInitializer generateDefaultGetter() {
        VariableAccessorDescriptor variableAccessorDescriptor = this.descriptor.getGetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)new IllegalStateException("Getter descriptor should not be null");
        }
        VariableAccessorDescriptor getterDescriptor = variableAccessorDescriptor;
        return this.generateDefaultAccessor(getterDescriptor, this.generateDefaultGetterFunction(getterDescriptor));
    }

    private final JsFunction generateDefaultGetterFunction(VariableAccessorDescriptor getterDescriptor) {
        ResolvedCall delegatedCall = (ResolvedCall)this.bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getterDescriptor);
        if (delegatedCall != null) {
            return this.generateDelegatedGetterFunction(getterDescriptor, delegatedCall);
        }
        boolean bl = !DescriptorUtilsKt.isExtension(this.descriptor);
        if (_Assertions.ENABLED && !bl) {
            String string = "Unexpected extension property " + this.descriptor + "}";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = this.descriptor instanceof PropertyDescriptor;
        if (_Assertions.ENABLED && !bl) {
            String string = "Property descriptor expected: " + this.descriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        JsScope scope = this.context().getScopeForDescriptor(getterDescriptor.getContainingDeclaration());
        VariableDescriptorWithAccessors variableDescriptorWithAccessors = this.descriptor;
        if (variableDescriptorWithAccessors == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
        }
        JsNameRef result2 = TranslationUtils.backingFieldReference(this.context(), (PropertyDescriptor)variableDescriptorWithAccessors);
        JsBlock body = new JsBlock(new JsReturn(result2));
        return new JsFunction(scope, body, this.accessorDescription(getterDescriptor));
    }

    private final JsFunction generateDelegatedGetterFunction(VariableAccessorDescriptor getterDescriptor, ResolvedCall<FunctionDescriptor> delegatedCall) {
        JsScope scope = this.context().getScopeForDescriptor(getterDescriptor.getContainingDeclaration());
        JsFunction function2 = new JsFunction(scope, new JsBlock(), this.accessorDescription(getterDescriptor));
        JsNameRef delegateRef = Namer.getDelegateNameRef(this.propertyName);
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        JsExpression delegatedJsCall = CallTranslator.translate(this.contextWithPropertyMetadataCreationIntrinsified(translationContext, delegatedCall, getterDescriptor), delegatedCall, delegateRef);
        if (DescriptorUtilsKt.isExtension(getterDescriptor)) {
            String string = Namer.getReceiverParameterName();
            Intrinsics.checkExpressionValueIsNotNull(string, "getReceiverParameterName()");
            JsName receiver = AstUtilsKt.addParameter$default(function2, string, null, 2, null).getName();
            JsExpression jsExpression = delegatedJsCall;
            if (jsExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsInvocation");
            }
            List<JsExpression> arguments = ((JsInvocation)jsExpression).getArguments();
            arguments.set(0, receiver.makeRef());
        }
        JsReturn returnResult = new JsReturn(delegatedJsCall);
        AstUtilsKt.addStatement(function2, returnResult);
        return function2;
    }

    private final TranslationContext contextWithPropertyMetadataCreationIntrinsified(TranslationContext context, ResolvedCall<FunctionDescriptor> delegatedCall, VariableAccessorDescriptor accessor) {
        JsStringLiteral propertyNameLiteral = context.program().getStringLiteral(accessor.getCorrespondingVariable().getName().asString());
        List<ResolvedValueArgument> list2 = delegatedCall.getValueArgumentsByIndex();
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        ResolvedValueArgument resolvedValueArgument = list2.get(1);
        if (resolvedValueArgument == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument");
        }
        ValueArgument valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
        if (valueArgument == null) {
            Intrinsics.throwNpe();
        }
        KtExpression fakeArgumentExpression = valueArgument.getArgumentExpression();
        TranslationContext translationContext = context.innerContextWithAliasesForExpressions(MapsKt.mapOf(TuplesKt.to(fakeArgumentExpression, new JsNew(JsAstUtils.pureFqn("PropertyMetadata", (JsExpression)Namer.kotlinObject()), CollectionsKt.listOf(propertyNameLiteral)))));
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context.innerContextWith\u2026yNameLiteral))\n        ))");
        return translationContext;
    }

    private final JsPropertyInitializer generateDefaultSetter() {
        VariableAccessorDescriptor variableAccessorDescriptor = this.descriptor.getSetter();
        if (variableAccessorDescriptor == null) {
            throw (Throwable)new IllegalStateException("Setter descriptor should not be null");
        }
        VariableAccessorDescriptor setterDescriptor = variableAccessorDescriptor;
        return this.generateDefaultAccessor(setterDescriptor, this.generateDefaultSetterFunction(setterDescriptor));
    }

    private final JsFunction generateDefaultSetterFunction(VariableAccessorDescriptor setterDescriptor) {
        String correspondingPropertyName;
        JsScope containingScope = this.context().getScopeForDescriptor(setterDescriptor.getContainingDeclaration());
        JsFunction function2 = new JsFunction(containingScope, new JsBlock(), this.accessorDescription(setterDescriptor));
        boolean bl = setterDescriptor.getValueParameters().size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Setter must have 1 parameter";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = correspondingPropertyName = setterDescriptor.getCorrespondingVariable().getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "correspondingPropertyName");
        JsName valueParameter = AstUtilsKt.addParameter$default(function2, string, null, 2, null).getName();
        TranslationContext withAliased = this.context().innerContextWithAliased(setterDescriptor.getValueParameters().get(0), valueParameter.makeRef());
        ResolvedCall delegatedCall = (ResolvedCall)this.context().bindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, setterDescriptor);
        if (delegatedCall != null) {
            TranslationContext translationContext = withAliased;
            Intrinsics.checkExpressionValueIsNotNull(translationContext, "withAliased");
            JsExpression delegatedJsCall = CallTranslator.translate(this.contextWithPropertyMetadataCreationIntrinsified(translationContext, delegatedCall, setterDescriptor), delegatedCall, Namer.getDelegateNameRef(correspondingPropertyName));
            JsStatement jsStatement = delegatedJsCall.makeStmt();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "delegatedJsCall.makeStmt()");
            AstUtilsKt.addStatement(function2, jsStatement);
            if (DescriptorUtilsKt.isExtension(setterDescriptor)) {
                String string2 = Namer.getReceiverParameterName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "getReceiverParameterName()");
                JsName receiver = AstUtilsKt.addParameter(function2, string2, 0).getName();
                JsExpression jsExpression = delegatedJsCall;
                if (jsExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.dart.compiler.backend.js.ast.JsInvocation");
                }
                ((JsInvocation)jsExpression).getArguments().set(0, receiver.makeRef());
            }
        } else {
            boolean delegatedJsCall = !DescriptorUtilsKt.isExtension(this.descriptor);
            if (_Assertions.ENABLED && !delegatedJsCall) {
                String string3 = "Unexpected extension property " + this.descriptor + "}";
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            delegatedJsCall = this.descriptor instanceof PropertyDescriptor;
            if (_Assertions.ENABLED && !delegatedJsCall) {
                String string4 = "Property descriptor expected: " + this.descriptor;
                throw (Throwable)((Object)new AssertionError((Object)string4));
            }
            VariableDescriptorWithAccessors variableDescriptorWithAccessors = this.descriptor;
            if (variableDescriptorWithAccessors == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
            }
            JsExpression assignment = TranslationUtils.assignmentToBackingField(withAliased, (PropertyDescriptor)variableDescriptorWithAccessors, valueParameter.makeRef());
            JsStatement jsStatement = assignment.makeStmt();
            Intrinsics.checkExpressionValueIsNotNull(jsStatement, "assignment.makeStmt()");
            AstUtilsKt.addStatement(function2, jsStatement);
        }
        return function2;
    }

    private final JsPropertyInitializer generateDefaultAccessor(VariableAccessorDescriptor accessorDescriptor, JsFunction function2) {
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(function2, accessorDescriptor, this.context());
        Intrinsics.checkExpressionValueIsNotNull(jsPropertyInitializer, "translateFunctionAsEcma5\u2026sorDescriptor, context())");
        return jsPropertyInitializer;
    }

    private final JsPropertyInitializer translateCustomAccessor(KtPropertyAccessor expression) {
        JsPropertyInitializer jsPropertyInitializer = Translation.functionTranslator(expression, this.context()).translateAsEcma5PropertyDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(jsPropertyInitializer, "Translation.functionTran\u2026Ecma5PropertyDescriptor()");
        return jsPropertyInitializer;
    }

    private final String accessorDescription(VariableAccessorDescriptor accessorDescriptor) {
        String string;
        VariableAccessorDescriptor variableAccessorDescriptor = accessorDescriptor;
        if (variableAccessorDescriptor instanceof PropertyGetterDescriptor || variableAccessorDescriptor instanceof LocalVariableAccessorDescriptor.Getter) {
            string = "getter";
        } else if (variableAccessorDescriptor instanceof PropertySetterDescriptor || variableAccessorDescriptor instanceof LocalVariableAccessorDescriptor.Setter) {
            string = "setter";
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown accessor type " + accessorDescriptor.getClass());
        }
        String accessorType = string;
        String name = accessorDescriptor.getName().asString();
        return accessorType + " for " + name;
    }

    @NotNull
    public final VariableDescriptorWithAccessors getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public final KtProperty getDeclaration() {
        return this.declaration;
    }

    public PropertyTranslator(@NotNull VariableDescriptorWithAccessors descriptor2, @Nullable KtProperty declaration, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        this.descriptor = descriptor2;
        this.declaration = declaration;
        String string = this.descriptor.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "descriptor.name.asString()");
        this.propertyName = string;
    }

    @NotNull
    public static final /* synthetic */ JsPropertyInitializer access$generateGetter(PropertyTranslator $this) {
        return $this.generateGetter();
    }

    @NotNull
    public static final /* synthetic */ JsPropertyInitializer access$generateSetter(PropertyTranslator $this) {
        return $this.generateSetter();
    }
}

