/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.coroutine.CoroutineReceiverValue;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CoroutineSuspendCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "kotlin-compiler"})
public final class CoroutineSuspendCallChecker
implements CallChecker {
    public static final CoroutineSuspendCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Object object;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Object obj = resolvedCall2.getCandidateDescriptor();
        if (!(obj instanceof FunctionDescriptor)) {
            obj = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)obj;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (!descriptor2.isSuspend() || descriptor2.getInitialSignatureDescriptor() == null) {
            return;
        }
        ReceiverValue receiverValue = resolvedCall2.getDispatchReceiver();
        if (!(receiverValue instanceof CoroutineReceiverValue)) {
            receiverValue = null;
        }
        if ((object = (CoroutineReceiverValue)receiverValue) == null || (object = ((ExtensionReceiver)object).getDeclarationDescriptor()) == null) {
            return;
        }
        Object dispatchReceiverOwner = object;
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        if (ktElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        KtExpression callElement = (KtExpression)ktElement;
        if (!InlineUtil.checkNonLocalReturnUsage((DeclarationDescriptor)dispatchReceiverOwner, callElement, context.getTrace())) {
            context.getTrace().report(Errors.NON_LOCAL_SUSPENSION_POINT.on(reportOn));
        }
    }

    private CoroutineSuspendCallChecker() {
        INSTANCE = this;
    }

    static {
        new CoroutineSuspendCallChecker();
    }
}

