/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.ClassDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/TypeAliasDeserializer;", "", "components", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;)V", "deserializeTypeAlias", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "typeAliasId", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlin-compiler"})
public final class TypeAliasDeserializer {
    private final DeserializationComponents components;

    @Nullable
    public final TypeAliasDescriptor deserializeTypeAlias(@NotNull ClassId typeAliasId) {
        MemberScope memberScope2;
        Intrinsics.checkParameterIsNotNull(typeAliasId, "typeAliasId");
        if (typeAliasId.isNestedClass()) {
            ClassDeserializer classDeserializer = this.components.getClassDeserializer();
            ClassId classId = typeAliasId.getOuterClassId();
            Intrinsics.checkExpressionValueIsNotNull(classId, "typeAliasId.outerClassId");
            ClassDescriptor classDescriptor = ClassDeserializer.deserializeClass$default(classDeserializer, classId, null, 2, null);
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor outerClass = classDescriptor;
            memberScope2 = outerClass.getUnsubstitutedMemberScope();
        } else {
            PackageFragmentProvider packageFragmentProvider = this.components.getPackageFragmentProvider();
            FqName fqName2 = typeAliasId.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "typeAliasId.packageFqName");
            PackageFragmentDescriptor packageFragment = CollectionsKt.single(packageFragmentProvider.getPackageFragments(fqName2));
            memberScope2 = packageFragment.getMemberScope();
        }
        MemberScope parentScope = memberScope2;
        Name name = typeAliasId.getShortClassName();
        Intrinsics.checkExpressionValueIsNotNull(name, "typeAliasId.shortClassName");
        ClassifierDescriptor classifierDescriptor = parentScope.getContributedClassifier(name, NoLookupLocation.FROM_DESERIALIZATION);
        if (!(classifierDescriptor instanceof TypeAliasDescriptor)) {
            classifierDescriptor = null;
        }
        return (TypeAliasDescriptor)classifierDescriptor;
    }

    public TypeAliasDeserializer(@NotNull DeserializationComponents components) {
        Intrinsics.checkParameterIsNotNull(components, "components");
        this.components = components;
    }
}

