/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayDeque;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.TypeCheckerContext;
import org.jetbrains.kotlin.utils.SmartSet;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J=\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00030\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00180\u0016H\u0000\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J5\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0006\u0010\"\u001a\u00020#2\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002H!0\u0016\u00a2\u0006\u0002\b%H\u0086\b\u00a2\u0006\u0002\u0010&R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext;", "", "errorTypeEqualsToAnything", "", "(Z)V", "argumentsDepth", "", "getArgumentsDepth", "()I", "setArgumentsDepth", "(I)V", "getErrorTypeEqualsToAnything", "()Z", "supertypesDeque", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/kotlin/types/SimpleType;", "supertypesLocked", "supertypesSet", "", "anySupertype", "start", "predicate", "Lkotlin/Function1;", "supertypesPolicy", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "anySupertype$kotlin_compiler", "clear", "", "initialize", "isSubtypeByExternalRule", "subType", "superType", "runWithArgumentsSettings", "T", "subArgument", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "f", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/types/UnwrappedType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "SupertypesPolicy", "kotlin-compiler"})
public class TypeCheckerContext {
    private int argumentsDepth;
    private boolean supertypesLocked;
    private ArrayDeque<SimpleType> supertypesDeque;
    private Set<SimpleType> supertypesSet;
    private final boolean errorTypeEqualsToAnything;

    protected final int getArgumentsDepth() {
        return this.argumentsDepth;
    }

    protected final void setArgumentsDepth(int n) {
        this.argumentsDepth = n;
    }

    public boolean isSubtypeByExternalRule(@NotNull SimpleType subType, @NotNull SimpleType superType) {
        Intrinsics.checkParameterIsNotNull(subType, "subType");
        Intrinsics.checkParameterIsNotNull(superType, "superType");
        return false;
    }

    public final <T> T runWithArgumentsSettings(@NotNull UnwrappedType subArgument, @NotNull Function1<? super TypeCheckerContext, ? extends T> f) {
        Intrinsics.checkParameterIsNotNull(subArgument, "subArgument");
        Intrinsics.checkParameterIsNotNull(f, "f");
        if (this.argumentsDepth > 100) {
            String string = "Arguments depth is too high. Some related argument: " + subArgument;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        TypeCheckerContext typeCheckerContext = this;
        int n = typeCheckerContext.argumentsDepth;
        typeCheckerContext.argumentsDepth = n + 1;
        T result2 = f.invoke(this);
        TypeCheckerContext typeCheckerContext2 = this;
        int n2 = typeCheckerContext2.argumentsDepth;
        typeCheckerContext2.argumentsDepth = n2 + -1;
        return result2;
    }

    private final void initialize() {
        boolean bl = !this.supertypesLocked;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.supertypesLocked = true;
        if (this.supertypesDeque == null) {
            this.supertypesDeque = new ArrayDeque();
        }
        if (this.supertypesSet == null) {
            this.supertypesSet = SmartSet.Companion.create();
        }
    }

    private final void clear() {
        ArrayDeque<SimpleType> arrayDeque = this.supertypesDeque;
        if (arrayDeque == null) {
            Intrinsics.throwNpe();
        }
        arrayDeque.clear();
        Set<SimpleType> set = this.supertypesSet;
        if (set == null) {
            Intrinsics.throwNpe();
        }
        set.clear();
        this.supertypesLocked = false;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean anySupertype$kotlin_compiler(@NotNull SimpleType start, @NotNull Function1<? super SimpleType, Boolean> predicate, @NotNull Function1<? super SimpleType, ? extends SupertypesPolicy> supertypesPolicy) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Intrinsics.checkParameterIsNotNull(supertypesPolicy, "supertypesPolicy");
        this.initialize();
        v0 = this.supertypesDeque;
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        deque = v0;
        v1 = this.supertypesSet;
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        visitedSupertypes = v1;
        deque.push(start);
        block0: while (true) {
            var6_6 = deque;
            if (!(var6_6.isEmpty() == false)) break;
            if (visitedSupertypes.size() > 1000) {
                var6_6 = "Too many supertypes for type: " + start + ". Supertypes = " + CollectionsKt.joinToString$default(visitedSupertypes, null, null, null, 0, null, null, 63, null);
                throw (Throwable)new IllegalStateException(var6_6.toString());
            }
            v2 = current = deque.pop();
            Intrinsics.checkExpressionValueIsNotNull(v2, "current");
            if (!visitedSupertypes.add(v2)) continue;
            v3 = current;
            Intrinsics.checkExpressionValueIsNotNull(v3, "current");
            if (predicate.invoke(v3).booleanValue()) {
                this.clear();
                return true;
            }
            v4 = current;
            Intrinsics.checkExpressionValueIsNotNull(v4, "current");
            if (AddToStdlibKt.check(supertypesPolicy.invoke(v4), anySupertype.policy.1.INSTANCE) == null) {
                continue;
            }
            var8_8 = current.getConstructor().getSupertypes().iterator();
            while (true) {
                if (var8_8.hasNext()) ** break;
                continue block0;
                v5 = supertype = var8_8.next();
                Intrinsics.checkExpressionValueIsNotNull(v5, "supertype");
                deque.add(policy.transformType(v5));
            }
            break;
        }
        this.clear();
        return false;
    }

    public final boolean getErrorTypeEqualsToAnything() {
        return this.errorTypeEqualsToAnything;
    }

    public TypeCheckerContext(boolean errorTypeEqualsToAnything) {
        this.errorTypeEqualsToAnything = errorTypeEqualsToAnything;
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b0\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "", "()V", "transformType", "Lorg/jetbrains/kotlin/types/SimpleType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "LowerIfFlexible", "LowerIfFlexibleWithCustomSubstitutor", "None", "UpperIfFlexible", "kotlin-compiler"})
    public static abstract class SupertypesPolicy {
        @NotNull
        public abstract SimpleType transformType(@NotNull KotlinType var1);

        private SupertypesPolicy() {
        }

        public /* synthetic */ SupertypesPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$None;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "()V", "transformType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
        public static final class None
        extends SupertypesPolicy {
            public static final None INSTANCE;

            @NotNull
            public Void transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                throw (Throwable)new UnsupportedOperationException("Should not be called");
            }

            private None() {
                super(null);
                INSTANCE = this;
            }

            static {
                new None();
            }
        }

        @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$UpperIfFlexible;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "()V", "transformType", "Lorg/jetbrains/kotlin/types/SimpleType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
        public static final class UpperIfFlexible
        extends SupertypesPolicy {
            public static final UpperIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                return FlexibleTypesKt.upperIfFlexible(type2);
            }

            private UpperIfFlexible() {
                super(null);
                INSTANCE = this;
            }

            static {
                new UpperIfFlexible();
            }
        }

        @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$LowerIfFlexible;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "()V", "transformType", "Lorg/jetbrains/kotlin/types/SimpleType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
        public static final class LowerIfFlexible
        extends SupertypesPolicy {
            public static final LowerIfFlexible INSTANCE;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                return FlexibleTypesKt.lowerIfFlexible(type2);
            }

            private LowerIfFlexible() {
                super(null);
                INSTANCE = this;
            }

            static {
                new LowerIfFlexible();
            }
        }

        @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy$LowerIfFlexibleWithCustomSubstitutor;", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "(Lorg/jetbrains/kotlin/types/TypeSubstitutor;)V", "getSubstitutor", "()Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "transformType", "Lorg/jetbrains/kotlin/types/SimpleType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
        public static final class LowerIfFlexibleWithCustomSubstitutor
        extends SupertypesPolicy {
            @NotNull
            private final TypeSubstitutor substitutor;

            @Override
            @NotNull
            public SimpleType transformType(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                return TypeSubstitutionKt.asSimpleType(this.substitutor.safeSubstitute(FlexibleTypesKt.lowerIfFlexible(type2), Variance.INVARIANT));
            }

            @NotNull
            public final TypeSubstitutor getSubstitutor() {
                return this.substitutor;
            }

            public LowerIfFlexibleWithCustomSubstitutor(@NotNull TypeSubstitutor substitutor2) {
                Intrinsics.checkParameterIsNotNull(substitutor2, "substitutor");
                super(null);
                this.substitutor = substitutor2;
            }
        }
    }
}

