/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.notations.ModuleIdentifierNotationConverter;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.TypedNotationConverter;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.GUtil;

class ModuleSelectorStringNotationConverter
extends TypedNotationConverter<String, ComponentSelector> {
    public ModuleSelectorStringNotationConverter() {
        super(String.class);
    }

    protected ComponentSelector parseType(String notation) {
        assert (notation != null);
        String[] split = notation.split(":");
        if (split.length < 2 || split.length > 3) {
            throw new UnsupportedNotationException((Object)notation);
        }
        String group = ModuleIdentifierNotationConverter.validate(split[0].trim(), notation);
        String name = ModuleIdentifierNotationConverter.validate(split[1].trim(), notation);
        if (split.length == 2) {
            return new UnversionedModuleComponentSelector(group, name);
        }
        String version = split[2].trim();
        if (!GUtil.isTrue((Object)version)) {
            throw new UnsupportedNotationException((Object)notation);
        }
        return DefaultModuleComponentSelector.newSelector(group, name, version);
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("String describing the module in 'group:name' format").example("'org.gradle:gradle-core'.");
        visitor.candidate("String describing the selector in 'group:name:version' format").example("'org.gradle:gradle-core:1.+'.");
    }
}

