/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.DefaultDependencyMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;

public class MavenDependencyMetadata
extends DefaultDependencyMetadata {
    private final MavenScope scope;
    private final boolean optional;
    private final Set<String> moduleConfigurations;
    private final List<Exclude> excludes;
    private final ModuleExclusion exclusions;

    public MavenDependencyMetadata(MavenScope scope, boolean optional, ModuleVersionSelector requested, List<Artifact> artifacts, List<Exclude> excludes) {
        super(requested, artifacts);
        this.scope = scope;
        this.optional = optional;
        this.moduleConfigurations = optional && scope != MavenScope.Test && scope != MavenScope.System ? ImmutableSet.of((Object)"optional") : ImmutableSet.of((Object)scope.name().toLowerCase());
        this.excludes = ImmutableList.copyOf(excludes);
        this.exclusions = ModuleExclusions.excludeAny(excludes);
    }

    public String toString() {
        return "dependency: " + this.getRequested() + ", scope: " + (Object)((Object)this.scope) + ", optional: " + this.optional;
    }

    public MavenScope getScope() {
        return this.scope;
    }

    @Override
    public Set<String> getModuleConfigurations() {
        return this.moduleConfigurations;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return true;
    }

    @Override
    public boolean isForce() {
        return false;
    }

    @Override
    public String getDynamicConstraintVersion() {
        return this.getRequested().getVersion();
    }

    @Override
    public Set<ConfigurationMetadata> selectConfigurations(ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent) {
        ConfigurationMetadata master;
        LinkedHashSet result = Sets.newLinkedHashSet();
        boolean requiresCompile = fromConfiguration.getName().equals("compile");
        if (!requiresCompile) {
            ConfigurationMetadata runtime = this.findTargetConfiguration(fromComponent, fromConfiguration, targetComponent, "runtime");
            result.add(runtime);
            boolean bl = requiresCompile = !runtime.getHierarchy().contains("compile");
        }
        if (requiresCompile) {
            result.add(this.findTargetConfiguration(fromComponent, fromConfiguration, targetComponent, "compile"));
        }
        if (!((master = targetComponent.getConfiguration("master")) == null || master.getDependencies().isEmpty() && master.getArtifacts().isEmpty())) {
            result.add(master);
        }
        return result;
    }

    private ConfigurationMetadata findTargetConfiguration(ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent, String target) {
        ConfigurationMetadata configuration = targetComponent.getConfiguration(target);
        if (configuration == null && (configuration = targetComponent.getConfiguration("default")) == null) {
            throw new ConfigurationNotFoundException(fromComponent.getComponentId(), fromConfiguration.getName(), target, targetComponent.getComponentId());
        }
        return configuration;
    }

    @Override
    protected DependencyMetadata withRequested(ModuleVersionSelector newRequested) {
        return new MavenDependencyMetadata(this.scope, this.optional, newRequested, this.getDependencyArtifacts(), this.getDependencyExcludes());
    }

    @Override
    public ModuleExclusion getExclusions(ConfigurationMetadata fromConfiguration) {
        return this.exclusions;
    }

    public List<Exclude> getDependencyExcludes() {
        return this.excludes;
    }
}

