/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.OutputFilesCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyPathSensitivity;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileCollectionSnapshotter snapshotter;
    private final StringInterner stringInterner;

    public OutputFilesCollectionSnapshotter(FileCollectionSnapshotter snapshotter, StringInterner stringInterner) {
        this.snapshotter = snapshotter;
        this.stringInterner = stringInterner;
    }

    @Override
    public void registerSerializers(SerializerRegistry registry) {
        DefaultSerializerRegistry nested = new DefaultSerializerRegistry();
        this.snapshotter.registerSerializers((SerializerRegistry)nested);
        registry.register(OutputFilesCollectionSnapshot.class, (Serializer)new OutputFilesCollectionSnapshot.SerializerImpl((Serializer<FileCollectionSnapshot>)nested.build(FileCollectionSnapshot.class), this.stringInterner));
    }

    @Override
    public FileCollectionSnapshot emptySnapshot() {
        return new OutputFilesCollectionSnapshot(Collections.<String, Boolean>emptyMap(), this.snapshotter.emptySnapshot());
    }

    @Override
    public FileCollectionSnapshot snapshot(FileCollection files, TaskFilePropertyCompareStrategy compareStrategy, TaskFilePropertyPathSensitivity pathSensitivity) {
        return new OutputFilesCollectionSnapshot(this.getRoots(files), this.snapshotter.snapshot(files, compareStrategy, pathSensitivity));
    }

    @Override
    public FileCollectionSnapshot snapshot(TaskFilePropertySpec propertySpec) {
        return new OutputFilesCollectionSnapshot(this.getRoots(propertySpec.getPropertyFiles()), this.snapshotter.snapshot(propertySpec));
    }

    private Map<String, Boolean> getRoots(FileCollection files) {
        HashMap<String, Boolean> roots = new HashMap<String, Boolean>();
        for (File file : files.getFiles()) {
            roots.put(this.stringInterner.intern(file.getAbsolutePath()), file.exists());
        }
        return roots;
    }

    public OutputFilesCollectionSnapshot createOutputSnapshot(FileCollectionSnapshot afterPreviousExecution, FileCollectionSnapshot beforeExecution, FileCollectionSnapshot afterExecution, FileCollection roots) {
        FileCollectionSnapshot filesSnapshot;
        Map<String, NormalizedFileSnapshot> afterSnapshots = afterExecution.getSnapshots();
        if (!beforeExecution.getSnapshots().isEmpty() && !afterSnapshots.isEmpty()) {
            Map<String, NormalizedFileSnapshot> beforeSnapshots = beforeExecution.getSnapshots();
            HashMap<String, NormalizedFileSnapshot> afterPreviousSnapshots = afterPreviousExecution != null ? afterPreviousExecution.getSnapshots() : new HashMap<String, NormalizedFileSnapshot>();
            int newEntryCount = 0;
            ImmutableMap.Builder outputEntries = ImmutableMap.builder();
            for (Map.Entry<String, NormalizedFileSnapshot> entry : afterSnapshots.entrySet()) {
                NormalizedFileSnapshot fileSnapshot;
                String path = entry.getKey();
                if (!OutputFilesCollectionSnapshotter.isOutputEntry(path, fileSnapshot = entry.getValue(), beforeSnapshots, afterPreviousSnapshots)) continue;
                outputEntries.put((Object)entry.getKey(), (Object)fileSnapshot);
                ++newEntryCount;
            }
            filesSnapshot = newEntryCount == afterSnapshots.size() ? OutputFilesCollectionSnapshotter.unwrap(afterExecution) : new DefaultFileCollectionSnapshot((Map<String, NormalizedFileSnapshot>)outputEntries.build(), TaskFilePropertyCompareStrategy.OUTPUT);
        } else {
            filesSnapshot = OutputFilesCollectionSnapshotter.unwrap(afterExecution);
        }
        return new OutputFilesCollectionSnapshot(this.getRoots(roots), filesSnapshot);
    }

    private static boolean isOutputEntry(String path, NormalizedFileSnapshot fileSnapshot, Map<String, NormalizedFileSnapshot> beforeSnapshots, Map<String, NormalizedFileSnapshot> afterPreviousSnapshots) {
        NormalizedFileSnapshot beforeSnapshot = beforeSnapshots.get(path);
        if (beforeSnapshot == null) {
            return true;
        }
        if (!fileSnapshot.getSnapshot().isContentAndMetadataUpToDate(beforeSnapshot.getSnapshot())) {
            return true;
        }
        return afterPreviousSnapshots.containsKey(path);
    }

    private static FileCollectionSnapshot unwrap(FileCollectionSnapshot filesSnapshot) {
        if (filesSnapshot instanceof OutputFilesCollectionSnapshot) {
            return ((OutputFilesCollectionSnapshot)filesSnapshot).getFilesSnapshot();
        }
        return filesSnapshot;
    }
}

