/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.cache;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import org.gradle.api.internal.tasks.cache.TaskCacheKey;
import org.gradle.api.internal.tasks.cache.TaskCacheKeyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskCacheKeyBuilder
implements TaskCacheKeyBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskCacheKeyBuilder.class);
    private final Hasher hasher = Hashing.md5().newHasher();

    public TaskCacheKeyBuilder putByte(byte b) {
        DefaultTaskCacheKeyBuilder.log("byte", b);
        this.hasher.putByte(b);
        return this;
    }

    public TaskCacheKeyBuilder putBytes(byte[] bytes) {
        DefaultTaskCacheKeyBuilder.log("bytes", new ByteArrayToStringer(bytes));
        this.hasher.putBytes(bytes);
        return this;
    }

    public TaskCacheKeyBuilder putBytes(byte[] bytes, int off, int len) {
        DefaultTaskCacheKeyBuilder.log("bytes", new ByteArrayToStringer(bytes, off, len));
        this.hasher.putBytes(bytes, off, len);
        return this;
    }

    public TaskCacheKeyBuilder putInt(int i) {
        DefaultTaskCacheKeyBuilder.log("int", i);
        this.hasher.putInt(i);
        return this;
    }

    public TaskCacheKeyBuilder putLong(long l) {
        DefaultTaskCacheKeyBuilder.log("long", l);
        this.hasher.putLong(l);
        return this;
    }

    public TaskCacheKeyBuilder putDouble(double d) {
        DefaultTaskCacheKeyBuilder.log("double", d);
        this.hasher.putDouble(d);
        return this;
    }

    public TaskCacheKeyBuilder putBoolean(boolean b) {
        DefaultTaskCacheKeyBuilder.log("boolean", b);
        this.hasher.putBoolean(b);
        return this;
    }

    public TaskCacheKeyBuilder putString(CharSequence charSequence) {
        DefaultTaskCacheKeyBuilder.log("string", charSequence);
        this.hasher.putString(charSequence, Charsets.UTF_8);
        return this;
    }

    public TaskCacheKey build() {
        HashCode hashCode = this.hasher.hash();
        LOGGER.info("Hash code generated: {}", (Object)hashCode);
        return new DefaultTaskCacheKey(hashCode);
    }

    private static void log(String type, Object value) {
        LOGGER.debug("Appending {} to cache key: {}", (Object)type, value);
    }

    private static class ByteArrayToStringer {
        private static final char[] HEX_DIGITS = "01234567890abcdef".toCharArray();
        private final byte[] bytes;
        private final int offset;
        private final int length;

        public ByteArrayToStringer(byte[] bytes) {
            this(bytes, 0, bytes.length);
        }

        public ByteArrayToStringer(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.bytes.length * 3);
            for (int idx = this.offset; idx < this.offset + this.length; ++idx) {
                byte b = this.bytes[idx];
                if (idx > 0) {
                    builder.append(':');
                }
                builder.append(HEX_DIGITS[b >>> 4 & 0xF]);
                builder.append(HEX_DIGITS[b & 0xF]);
            }
            return builder.toString();
        }
    }

    private static class DefaultTaskCacheKey
    implements TaskCacheKey {
        private final HashCode hashCode;

        public DefaultTaskCacheKey(HashCode hashCode) {
            this.hashCode = hashCode;
        }

        public String getHashCode() {
            return this.hashCode.toString();
        }

        public String toString() {
            return this.hashCode.toString();
        }
    }
}

