/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.script.lang.kotlin

import org.gradle.api.artifacts.dsl.DependencyHandler
import org.gradle.api.artifacts.dsl.RepositoryHandler

import org.gradle.api.artifacts.repositories.ArtifactRepository

/**
 * The version of the Kotlin compiler embedded in gradle-script-kotlin (currently _1.1.0-dev-2053_).
 */
val embeddedKotlinVersion = "1.1.0-dev-2053"

/**
 * Adds the remote repository containing the Kotlin libraries embedded in gradle-script-kotlin.
 */
fun RepositoryHandler.gradleScriptKotlin(): ArtifactRepository =
    maven { it.setUrl("https://repo.gradle.org/gradle/repo") }

/**
 * Builds the dependency notation for the named Kotlin [module] at the given [version].
 *
 * @param module simple name of the Kotlin module, for example "reflect".
 * @param version optional desired version, null implies [embeddedKotlinVersion].
 */
fun DependencyHandler.kotlinModule(module: String, version: String? = null): Any =
    "org.jetbrains.kotlin:kotlin-$module:${version ?: embeddedKotlinVersion}"
