/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler.tags;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.gsp.compiler.tags.GrailsTag;
import org.grails.gsp.compiler.tags.GroovyCollectTag;
import org.grails.gsp.compiler.tags.GroovyDefTag;
import org.grails.gsp.compiler.tags.GroovyEachTag;
import org.grails.gsp.compiler.tags.GroovyElseIfTag;
import org.grails.gsp.compiler.tags.GroovyElseTag;
import org.grails.gsp.compiler.tags.GroovyFindAllTag;
import org.grails.gsp.compiler.tags.GroovyGrepTag;
import org.grails.gsp.compiler.tags.GroovyIfTag;
import org.grails.gsp.compiler.tags.GroovySyntaxTag;
import org.grails.gsp.compiler.tags.GroovyUnlessTag;
import org.grails.gsp.compiler.tags.GroovyWhileTag;
import org.grails.taglib.GrailsTagException;

public class GrailsTagRegistry {
    private static GrailsTagRegistry instance = new GrailsTagRegistry();
    private static Map<String, Class<?>> tagRegistry = new ConcurrentHashMap();

    private GrailsTagRegistry() {
    }

    public static GrailsTagRegistry getInstance() {
        return instance;
    }

    public void registerTag(String tagName, Class<?> tag) {
        tagRegistry.put(tagName, tag);
    }

    public boolean tagSupported(String tagName) {
        return tagRegistry.containsKey(tagName);
    }

    public boolean isSyntaxTag(String tagName) {
        if (tagRegistry.containsKey(tagName)) {
            return GroovySyntaxTag.class.isAssignableFrom(tagRegistry.get(tagName));
        }
        return false;
    }

    public GrailsTag newTag(String tagName) {
        if (!tagRegistry.containsKey(tagName)) {
            throw new GrailsTagException("Tag [" + tagName + "] is not a a valid grails tag");
        }
        Class<?> tagClass = tagRegistry.get(tagName);
        try {
            return (GrailsTag)tagClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new GrailsTagException("Instantiation error loading tag [" + tagName + "]: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new GrailsTagException("Illegal access error loading tag [" + tagName + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    static {
        instance.registerTag("each", GroovyEachTag.class);
        instance.registerTag("if", GroovyIfTag.class);
        instance.registerTag("unless", GroovyUnlessTag.class);
        instance.registerTag("else", GroovyElseTag.class);
        instance.registerTag("elseif", GroovyElseIfTag.class);
        instance.registerTag("findAll", GroovyFindAllTag.class);
        instance.registerTag("collect", GroovyCollectTag.class);
        instance.registerTag("grep", GroovyGrepTag.class);
        instance.registerTag("while", GroovyWhileTag.class);
        instance.registerTag("def", GroovyDefTag.class);
    }
}

