/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.A4;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.render.MeshRenderer;
import org.jmol.shapespecial.Draw;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.C;
import org.jmol.util.GData;

public class DrawRenderer
extends MeshRenderer {
    private Draw.EnumDrawType drawType;
    protected DrawMesh dmesh;
    private P3[] controlHermites;
    protected P3 pt0 = new P3();
    protected P3 pt1 = new P3();
    protected P3 pt2 = new P3();
    protected final V3 vTemp = new V3();
    protected final V3 vTemp2 = new V3();
    private final P3 pt0f = new P3();
    protected P3i pt0i = new P3i();
    private P3 s0f;
    private P3 s1f;
    private P3 s2f;
    private final BS bsHandles = new BS();

    protected boolean render() {
        this.needTranslucent = false;
        this.imageFontScaling = this.vwr.imageFontScaling;
        Draw draw = (Draw)this.shape;
        this.isPrecision = true;
        int i = draw.meshCount;
        while (--i >= 0) {
            DrawMesh mesh = this.dmesh = (DrawMesh)draw.meshes[i];
            if (mesh.connectedAtoms != null) {
                if (mesh.connectedAtoms[0] < 0) continue;
                mesh.vs = new P3[4];
                mesh.vc = 4;
                int[] c = mesh.connectedAtoms;
                for (int j = 0; j < 4; ++j) {
                    mesh.vs[j] = c[j] < 0 ? mesh.vs[j - 1] : this.vwr.ms.at[c[j]];
                }
                mesh.recalcAltVertices = true;
            }
            if (this.renderMesh2(mesh)) {
                this.renderInfo();
            }
            if (this.isExport || mesh.visibilityFlags == 0 || this.vwr.getPickingMode() != 4) continue;
            if (!this.g3d.setC(C.getColixTranslucent3((short)23, (boolean)true, (float)0.5f))) {
                this.needTranslucent = true;
                continue;
            }
            this.renderHandles();
        }
        return this.needTranslucent;
    }

    protected boolean isPolygonDisplayable(int i) {
        return Draw.isPolygonDisplayable(this.dmesh, i) && (this.dmesh.modelFlags == null || this.dmesh.bsMeshesVisible.get(i));
    }

    protected void render2(boolean isExport) {
        int i;
        boolean isCurved;
        this.drawType = this.dmesh.drawType;
        this.diameter = this.dmesh.diameter;
        this.width = this.dmesh.width;
        if (this.mesh.connectedAtoms != null) {
            this.getConnectionPoints();
        }
        if (this.mesh.lineData != null) {
            this.drawLineData((Lst<P3[]>)this.mesh.lineData);
            return;
        }
        int nPoints = this.vertexCount;
        boolean bl = isCurved = (this.drawType == Draw.EnumDrawType.CURVE || this.drawType == Draw.EnumDrawType.ARROW || this.drawType == Draw.EnumDrawType.ARC) && this.vertexCount > 2;
        if (this.width > 0.0f && isCurved || this.drawType == Draw.EnumDrawType.ARROW) {
            this.pt1f.set(0.0f, 0.0f, 0.0f);
            int n = this.drawType == Draw.EnumDrawType.ARC ? 2 : this.vertexCount;
            for (i = 0; i < n; ++i) {
                this.pt1f.add(this.vertices[i]);
            }
            this.pt1f.scale(1.0f / (float)n);
            this.tm.transformPtScr((T3)this.pt1f, this.pt1i);
            this.diameter = (int)this.vwr.tm.scaleToScreen(this.pt1i.z, (int)Math.floor(this.width * 1000.0f));
            if (this.diameter == 0) {
                this.diameter = 1;
            }
        }
        if (this.dmesh.haveXyPoints) {
            if (this.dmesh.isVector) {
                int ptXY = 0;
                for (i = 0; i < 2; ++i) {
                    if (this.vertices[i].z != Float.MAX_VALUE && this.vertices[i].z != -3.4028235E38f) continue;
                    ptXY += i + 1;
                }
                if (--ptXY < 2) {
                    this.renderXyArrow(ptXY);
                    return;
                }
            } else if (this.drawType == Draw.EnumDrawType.POINT) {
                this.renderXyPoint();
            }
        }
        int tension = 5;
        switch (this.drawType) {
            default: {
                this.render2b(false);
                return;
            }
            case CIRCULARPLANE: {
                if (this.dmesh.scale > 0.0f) {
                    this.width *= this.dmesh.scale;
                }
                this.render2b(false);
                return;
            }
            case CIRCLE: {
                this.tm.transformPtScr(this.vertices[0], this.pt1i);
                if (this.diameter == 0 && this.width == 0.0f) {
                    this.width = 1.0f;
                }
                if (this.dmesh.scale > 0.0f) {
                    this.width *= this.dmesh.scale;
                }
                if (this.width > 0.0f) {
                    this.diameter = (int)this.vwr.tm.scaleToScreen(this.pt1i.z, (int)Math.floor(this.width * 1000.0f));
                }
                if (this.diameter > 0 && (this.mesh.drawTriangles || this.mesh.fillTriangles)) {
                    this.g3d.addRenderer(1073741880);
                    this.g3d.drawFilledCircle(this.colix, this.mesh.fillTriangles ? this.colix : (short)0, this.diameter, this.pt1i.x, this.pt1i.y, this.pt1i.z);
                }
                return;
            }
            case LINE_SEGMENT: {
                for (i = 0; i < nPoints - 1; ++i) {
                    this.drawEdge(i, i + 1, true, this.vertices[i], this.vertices[i + 1], this.screens[i], this.screens[i + 1]);
                }
                return;
            }
            case CURVE: {
                break;
            }
            case ARC: {
                float theta;
                P3 ptRef = this.vertexCount > 2 ? this.vertices[2] : Draw.randomPoint();
                float nDegreesOffset = this.vertexCount > 3 ? this.vertices[3].x : 0.0f;
                float f = theta = this.vertexCount > 3 ? this.vertices[3].y : 360.0f;
                if (theta == 0.0f) {
                    return;
                }
                float fractionalOffset = this.vertexCount > 3 ? this.vertices[3].z : 0.0f;
                nPoints = this.setArc(this.vertices[0], this.vertices[1], (T3)ptRef, nDegreesOffset, theta, fractionalOffset, this.dmesh.scale);
                if (this.dmesh.isVector && !this.dmesh.noHead) {
                    this.renderArrowHead((T3)this.pt0, (T3)this.pt1, 0.3f, false, false, this.dmesh.isBarb);
                    this.tm.transformPtScr((T3)this.pt1f, this.screens[nPoints - 1]);
                    this.tm.transformPtScrT3((T3)this.pt1f, (T3)this.p3Screens[nPoints - 1]);
                }
                this.pt1f.setT((T3)this.pt2);
                break;
            }
            case ARROW: {
                if (!isCurved) {
                    this.renderArrowHead(this.vertices[0], this.vertices[1], 0.0f, false, true, this.dmesh.isBarb);
                    return;
                }
                int nHermites = 5;
                if (this.controlHermites == null || this.controlHermites.length < nHermites + 1) {
                    this.controlHermites = new P3[nHermites + 1];
                }
                GData.getHermiteList((int)tension, (T3)this.vertices[this.vertexCount - 3], (T3)this.vertices[this.vertexCount - 2], (T3)this.vertices[this.vertexCount - 1], (T3)this.vertices[this.vertexCount - 1], (T3)this.vertices[this.vertexCount - 1], (T3[])this.controlHermites, (int)0, (int)nHermites, (boolean)true);
                this.renderArrowHead((T3)this.controlHermites[nHermites - 2], (T3)this.controlHermites[nHermites - 1], 0.0f, false, false, this.dmesh.isBarb);
            }
        }
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        if (isCurved) {
            this.g3d.addRenderer(553648147);
            int i2 = 0;
            int i0 = 0;
            while (i2 < nPoints - 1) {
                this.g3d.fillHermite(tension, this.diameter, this.diameter, this.diameter, this.p3Screens[i0], this.p3Screens[i2], this.p3Screens[i2 + 1], this.p3Screens[i2 + (i2 == nPoints - 2 ? 1 : 2)]);
                i0 = i2++;
            }
        } else {
            this.render2b(false);
        }
    }

    private int setArc(T3 v1, T3 v2, T3 ptRef, float nDegreesOffset, float theta, float fractionalOffset, float scale) {
        this.vTemp.sub2(v2, v1);
        this.pt1f.scaleAdd2(fractionalOffset, (T3)this.vTemp, v1);
        M3 mat = new M3().setAA(A4.newVA((V3)this.vTemp, (float)((float)((double)nDegreesOffset * Math.PI / 180.0))));
        this.vTemp2.sub2(ptRef, v1);
        this.vTemp2.cross((T3)this.vTemp, (T3)this.vTemp2);
        this.vTemp2.cross((T3)this.vTemp2, (T3)this.vTemp);
        this.vTemp2.normalize();
        this.vTemp2.scale(scale / 2.0f);
        mat.rotate((T3)this.vTemp2);
        float degrees = theta / 5.0f;
        while (Math.abs(degrees) > 5.0f) {
            degrees /= 2.0f;
        }
        int nPoints = Math.round(theta / degrees) + 1;
        while (nPoints < 10) {
            nPoints = Math.round(theta / (degrees /= 2.0f)) + 1;
        }
        mat.setAA(A4.newVA((V3)this.vTemp, (float)((float)((double)degrees * Math.PI / 180.0))));
        this.screens = this.vwr.allocTempScreens(nPoints);
        this.p3Screens = this.vwr.allocTempPoints(nPoints);
        int iBase = nPoints - (this.dmesh.scale < 2.0f ? 3 : 3);
        for (int i = 0; i < nPoints; ++i) {
            if (i == iBase) {
                this.pt0.setT((T3)this.pt1);
            }
            this.pt1.scaleAdd2(1.0f, (T3)this.vTemp2, (T3)this.pt1f);
            if (i == 0) {
                this.pt2.setT((T3)this.pt1);
            }
            this.tm.transformPtScr((T3)this.pt1, this.screens[i]);
            this.tm.transformPtScrT3((T3)this.pt1, (T3)this.p3Screens[i]);
            mat.rotate((T3)this.vTemp2);
        }
        return nPoints;
    }

    private void getConnectionPoints() {
        int i;
        this.vertexCount = 3;
        float dmax = Float.MAX_VALUE;
        int i0 = 0;
        int j0 = 0;
        for (i = 0; i < 2; ++i) {
            for (int j = 2; j < 4; ++j) {
                float d = this.vertices[i].distance(this.vertices[j]);
                if (!(d < dmax)) continue;
                dmax = d;
                i0 = i;
                j0 = j;
            }
        }
        this.pt0.ave(this.vertices[0], this.vertices[1]);
        this.pt2.ave(this.vertices[2], this.vertices[3]);
        this.pt1.ave((T3)this.pt0, (T3)this.pt2);
        this.vertices[3] = P3.newP((T3)this.vertices[i0]);
        this.vertices[3].add(this.vertices[j0]);
        this.vertices[3].scale(0.5f);
        this.vertices[1] = P3.newP((T3)this.pt1);
        this.vertices[0] = P3.newP((T3)this.pt0);
        this.vertices[2] = P3.newP((T3)this.pt2);
        for (i = 0; i < 4; ++i) {
            this.tm.transformPtScr(this.vertices[i], this.screens[i]);
        }
        float f = 4.0f * this.getArrowScale();
        float endoffset = 0.2f;
        float offsetside = this.width == 0.0f ? 0.1f : this.width;
        this.pt0.set((float)this.screens[0].x, (float)this.screens[0].y, (float)this.screens[0].z);
        this.pt1.set((float)this.screens[1].x, (float)this.screens[1].y, (float)this.screens[1].z);
        this.pt2.set((float)this.screens[3].x, (float)this.screens[3].y, (float)this.screens[3].z);
        float dx = (float)(this.screens[1].x - this.screens[0].x) * f;
        float dy = (float)(this.screens[1].y - this.screens[0].y) * f;
        if (dmax == 0.0f || Measure.computeTorsion((T3)this.pt2, (T3)this.pt0, (T3)P3.new3((float)this.pt0.x, (float)this.pt0.y, (float)10000.0f), (T3)this.pt1, (boolean)false) > 0.0f) {
            dx = -dx;
            dy = -dy;
        }
        this.pt2.set(dy, -dx, 0.0f);
        this.pt1.add((T3)this.pt2);
        this.tm.unTransformPoint((T3)this.pt1, this.vertices[1]);
        this.pt2.scale(offsetside);
        this.vTemp.sub2(this.vertices[1], this.vertices[0]);
        this.vTemp.scale(endoffset);
        this.vertices[0].add((T3)this.vTemp);
        this.vTemp.sub2(this.vertices[1], this.vertices[2]);
        this.vTemp.scale(endoffset);
        this.vertices[2].add((T3)this.vTemp);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.tm.transformPtScr(this.vertices[i2], this.screens[i2]);
            if (offsetside == 0.0f) continue;
            this.screens[i2].x += Math.round(this.pt2.x);
            this.screens[i2].y += Math.round(this.pt2.y);
            this.pt1.set((float)this.screens[i2].x, (float)this.screens[i2].y, (float)this.screens[i2].z);
            this.tm.unTransformPoint((T3)this.pt1, this.vertices[i2]);
        }
    }

    private void drawLineData(Lst<P3[]> lineData) {
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        int i = lineData.size();
        while (--i >= 0) {
            P3[] pts = (P3[])lineData.get(i);
            this.tm.transformPtScr((T3)pts[0], this.pt1i);
            this.tm.transformPtScr((T3)pts[1], this.pt2i);
            this.drawEdge(-1, -2, true, (T3)pts[0], (T3)pts[1], this.pt1i, this.pt2i);
        }
    }

    private void renderXyPoint() {
        int f = this.g3d.isAntialiased() ? 2 : 1;
        this.pt0.setT(this.vertices[0]);
        if (this.diameter == 0) {
            this.diameter = (int)this.width;
        }
        if (this.pt0.z == -3.4028235E38f) {
            this.pt0.x *= (float)this.vwr.tm.width / 100.0f;
            this.pt0.y *= (float)this.vwr.tm.height / 100.0f;
            this.diameter = (int)((float)(this.diameter * this.vwr.getScreenDim()) / 100.0f);
        }
        this.diameter *= f;
        this.pt1i.set((int)(this.pt0.x * (float)f), (int)((float)this.vwr.tm.height - this.pt0.y * (float)f), (int)this.vwr.tm.cameraDistance);
        this.g3d.fillSphereI(this.diameter, this.pt1i);
    }

    private void renderXyArrow(int ptXY) {
        int ptXYZ = 1 - ptXY;
        P3[] arrowPt = new P3[2];
        arrowPt[ptXYZ] = this.pt1;
        arrowPt[ptXY] = this.pt0;
        this.pt0.set((float)this.screens[ptXY].x, (float)this.screens[ptXY].y, (float)this.screens[ptXY].z);
        this.tm.rotatePoint(this.vertices[ptXYZ], (T3)this.pt1);
        this.pt1.z *= -1.0f;
        float zoomDimension = this.vwr.getScreenDim();
        float scaleFactor = zoomDimension / 20.0f;
        this.pt1.scaleAdd2(this.dmesh.scale * scaleFactor, (T3)this.pt1, (T3)this.pt0);
        if (this.diameter == 0) {
            this.diameter = 1;
        }
        if (this.diameter < 0) {
            this.g3d.drawDottedLineBits(this.pt0, this.pt1);
        } else {
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.pt0, this.pt1);
        }
        this.renderArrowHead((T3)this.pt0, (T3)this.pt1, 0.0f, true, false, false);
    }

    private void renderArrowHead(T3 pt1, T3 pt2, float factor2, boolean isTransformed, boolean withShaft, boolean isBarb) {
        int headDiameter;
        if (this.dmesh.noHead) {
            return;
        }
        if (this.s0f == null) {
            this.s0f = new P3();
            this.s1f = new P3();
            this.s2f = new P3();
        }
        float fScale = this.getArrowScale();
        if (isTransformed) {
            fScale *= 40.0f;
        }
        if (factor2 > 0.0f) {
            fScale *= factor2;
        }
        this.pt0f.setT(pt1);
        this.pt2f.setT(pt2);
        float d = this.pt0f.distance((T3)this.pt2f);
        if (d == 0.0f) {
            return;
        }
        this.vTemp.sub2((T3)this.pt2f, (T3)this.pt0f);
        this.vTemp.normalize();
        this.vTemp.scale(fScale / 5.0f);
        if (!withShaft) {
            this.pt2f.add((T3)this.vTemp);
        }
        this.vTemp.scale(5.0f);
        this.pt1f.sub2((T3)this.pt2f, (T3)this.vTemp);
        if (isTransformed) {
            this.s1f.setT((T3)this.pt1f);
            this.s2f.setT((T3)this.pt2f);
        } else {
            this.tm.transformPtScrT3((T3)this.pt2f, (T3)this.s2f);
            this.tm.transformPtScrT3((T3)this.pt1f, (T3)this.s1f);
            this.tm.transformPtScrT3((T3)this.pt0f, (T3)this.s0f);
        }
        if (this.s2f.z == 1.0f || this.s1f.z == 1.0f) {
            return;
        }
        if (this.diameter > 0) {
            headDiameter = this.diameter * 3;
        } else {
            this.vTemp.set(this.s2f.x - this.s1f.x, this.s2f.y - this.s1f.y, this.s2f.z - this.s1f.z);
            headDiameter = Math.round(this.vTemp.length() * 0.5f);
            this.diameter = headDiameter / 5;
        }
        if (this.diameter < 1) {
            this.diameter = 1;
        }
        if (headDiameter > 2) {
            this.g3d.fillConeScreen3f((byte)2, headDiameter, this.s1f, this.s2f, isBarb);
        }
        if (withShaft) {
            this.g3d.fillCylinderScreen3I((byte)2, this.diameter, this.s0f, this.s1f, null, null, 0.0f);
        }
    }

    private float getArrowScale() {
        float fScale;
        float f = fScale = this.dmesh.isScaleSet ? this.dmesh.scale : 0.0f;
        if (fScale == 0.0f) {
            fScale = this.vwr.getFloat(0x22000008) * (this.dmesh.connectedAtoms == null ? 1.0f : 0.5f);
        }
        if (fScale <= 0.0f) {
            fScale = 0.5f;
        }
        return fScale;
    }

    private void renderHandles() {
        int diameter = Math.round(10.0f * this.imageFontScaling);
        switch (this.drawType) {
            case NONE: {
                return;
            }
        }
        short colixFill = C.getColixTranslucent3((short)23, (boolean)true, (float)0.5f);
        this.bsHandles.clearAll();
        this.g3d.addRenderer(1073741880);
        int i = this.dmesh.pc;
        while (--i >= 0) {
            int j;
            int[] vertexIndexes;
            if (!this.isPolygonDisplayable(i) || (vertexIndexes = this.dmesh.pis[i]) == null) continue;
            int n = j = this.dmesh.isTriangleSet ? 3 : vertexIndexes.length;
            while (--j >= 0) {
                int k = vertexIndexes[j];
                if (this.bsHandles.get(k)) continue;
                this.bsHandles.set(k);
                this.g3d.drawFilledCircle((short)23, colixFill, diameter, this.screens[k].x, this.screens[k].y, this.screens[k].z);
            }
        }
    }

    private void renderInfo() {
        if (this.isExport || this.mesh.title == null || this.vwr.getDrawHover() || !this.g3d.setC(this.vwr.cm.colixBackgroundContrast)) {
            return;
        }
        int i = this.dmesh.pc;
        while (--i >= 0) {
            if (!this.isPolygonDisplayable(i)) continue;
            float size = this.vwr.getFloat(0x2200000C);
            if (size <= 0.0f) {
                size = 14.0f;
            }
            this.vwr.gdata.setFontFid(this.vwr.gdata.getFontFid(size * this.imageFontScaling));
            String s = this.mesh.title[i < this.mesh.title.length ? i : this.mesh.title.length - 1];
            int pt = 0;
            if (s.length() > 1 && s.charAt(0) == '>') {
                pt = this.dmesh.pis[i].length - 1;
                s = s.substring(1);
                if (this.drawType == Draw.EnumDrawType.ARC) {
                    this.pt1f.setT((T3)this.pt2f);
                }
            }
            if (this.drawType != Draw.EnumDrawType.ARC) {
                this.pt1f.setT(this.vertices[this.dmesh.pis[i][pt]]);
            }
            this.tm.transformPtScr((T3)this.pt1f, this.pt1i);
            int offset = Math.round(5.0f * this.imageFontScaling);
            this.g3d.drawString(s, null, this.pt1i.x + offset, this.pt1i.y - offset, this.pt1i.z, this.pt1i.z, (short)0);
            break;
        }
    }
}

