/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.GaussianDialog;
import org.openscience.jmol.app.nbo.NBODialogModel;

abstract class NBODialogRun
extends NBODialogModel {
    protected static final String[] keywordList = new String[]{"CMO: bonding character of MO's", "DIPOLE:", "NBBP:", "NBCP:", "NCE:", "NCU:", "NRT:", "PLOT:", "STERIC:"};
    private static final String CHOOSE_DESCRIPTION = "$CHOOSE Keylist - Edit lone pairs and bond orders";
    private JFrame runFrame;
    protected String validBonds = "";
    protected String validLP = "";
    protected String valid3C = "";
    protected String delOrbs = "";
    protected String delOrbsL = "";
    protected ArrayList<String> deleteElements;
    protected ArrayList<String> deleteBlocks;
    protected ArrayList<String> deleteAtomBlocks;
    protected ArrayList<String> delDeloc;
    protected boolean deleteLewisOrbs;
    protected boolean deleteVicinal;
    protected boolean deleteGeminal;
    String fileData;
    String fileData2;
    String nboKeywords;
    protected JTextField plotFileName;
    Hashtable<String, String> chooseBonds;
    Hashtable<String, String> choose3C;
    int lastEss;
    protected JComboBox<String> editOps;
    protected JRadioButton[] keywordButtons;

    protected NBODialogRun(JFrame f) {
        super(f);
        this.runFrame = f;
    }

    protected void buildRun(Container p) {
        if (this.tfExt != null && this.tfExt.getText().equals("47")) {
            this.isJmolNBO = true;
            this.nboService.runScriptQueued("load " + this.inputFile.toString() + ";refresh");
            this.setBonds(null, null);
            String s = this.nboService.runScriptNow("print {*}.bonds");
            this.nboService.runScriptQueued("select " + s + ";color bonds lightgrey; wireframe 0.1");
            if (this.jCheckAtomNum.isSelected()) {
                this.showAtomNums();
            }
        }
        p.removeAll();
        p.setLayout(new BorderLayout());
        if (this.topPanel == null) {
            this.topPanel = this.buildTopPanel();
        }
        p.add((Component)this.topPanel, "First");
        JSplitPane sp = new JSplitPane(1, this.runS(), this.modelOut());
        sp.setDividerLocation(350);
        sp.setBorder(BorderFactory.createLoweredBevelBorder());
        p.add((Component)sp, "Center");
        this.statusLab.setText("");
        p.add((Component)this.statusPanel, "Last");
        if (this.isJmolNBO) {
            this.addNBOKeylist();
        }
        this.showRunDone = new Runnable(){

            @Override
            public void run() {
                File f;
                try {
                    NBODialogRun.this.nboService.writeToFile(NBODialogRun.this.getFileContents(), NBODialogRun.this.inputFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                NBODialogRun.this.nboService.runScriptNow("load " + NBODialogRun.this.inputFile.toString() + ";refresh");
                if (!(NBODialogRun.this.nboKeywords.contains("PRINT=0") || NBODialogRun.this.getChooseList() || (f = NBODialogRun.this.newNBOFile(NBODialogRun.this.inputFile, "nbo")).exists() && f.length() != 0L)) {
                    f.delete();
                    if (NBODialogRun.this.validBonds.equals("")) {
                        f = NBODialogRun.this.newNBOFile(NBODialogRun.this.inputFile, "nbo");
                        NBODialogRun.this.showConfirmationDialog("Error occurred during run. View .nbo file?", f, "nbo", 1);
                        return;
                    }
                    NBODialogRun.this.resetBadChooseList();
                    NBODialogRun.this.vwr.alert("Invalid $CHOOSE list");
                    NBODialogRun.this.goRunClicked("PLOT CMO DIPOLE STERIC", "gennbo", NBODialogRun.this.inputFile, NBODialogRun.this.showRunDone);
                    return;
                }
                NBODialogRun.this.appendOutputWithCaret("Complete: Output to " + NBODialogRun.this.inputFile.getParent() + "\\" + NBODialogRun.this.jobStem + ".nbo", 'b');
                NBODialogRun.this.editOps.setSelectedIndex(NBODialogRun.this.editOps.getSelectedIndex());
                if (NBODialogRun.this.nboView) {
                    String s = NBODialogRun.this.nboService.runScriptNow("print {*}.bonds");
                    NBODialogRun.this.nboService.runScriptQueued("select " + s + ";color bonds lightgrey; wireframe 0.1");
                }
                if (NBODialogRun.this.jCheckAtomNum.isSelected()) {
                    NBODialogRun.this.showAtomNums();
                }
            }
        };
    }

    protected JPanel runS() {
        JPanel runPanel = new JPanel();
        runPanel.setLayout(new BoxLayout(runPanel, 1));
        final JComboBox<String> essBox = new JComboBox<String>(new String[]{"GenNBO", "GO9", "GAMESS"});
        final DefaultComboBoxModel editModel = new DefaultComboBoxModel();
        this.editOps = new JComboBox(editModel);
        Box box = Box.createVerticalBox();
        essBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBODialogRun.this.lastEss != essBox.getSelectedIndex()) {
                    NBODialogRun.this.essChanged(essBox.getSelectedItem().toString(), editModel);
                    NBODialogRun.this.lastEss = essBox.getSelectedIndex();
                }
            }
        });
        box.add(essBox);
        JLabel lab = new JLabel("ESS type");
        lab.setAlignmentX(0.5f);
        box.add(lab);
        essBox.setAlignmentX(0.5f);
        essBox.setMaximumSize(new Dimension(100, 40));
        box.add(this.folderBox());
        Box box2 = Box.createVerticalBox();
        this.tfExt.setText("47");
        this.tfName.setText("");
        this.browse.setEnabled(true);
        JLabel title = new JLabel(" Select Input ");
        title.setAlignmentX(0.0f);
        title.setBackground(titleColor);
        title.setForeground(Color.white);
        title.setFont(titleFont);
        title.setOpaque(true);
        box2.add(title);
        box.setBorder(BorderFactory.createLineBorder(Color.black));
        box.setMaximumSize(new Dimension(355, 80));
        box.setAlignmentX(0.0f);
        box2.setAlignmentX(0.0f);
        box2.add(box);
        runPanel.add(box2);
        box = Box.createVerticalBox();
        title = new JLabel(" Choose $NBO Keywords ");
        title.setAlignmentX(0.0f);
        title.setBackground(titleColor);
        title.setForeground(Color.white);
        title.setFont(titleFont);
        title.setOpaque(true);
        box.add(title);
        box.setMinimumSize(new Dimension(350, 400));
        box.setAlignmentX(0.0f);
        this.editBox = Box.createVerticalBox();
        this.editBox.setAlignmentX(0.0f);
        this.editBox.setBorder(BorderFactory.createLineBorder(Color.black));
        box.add(this.editBox);
        box.setVisible(this.isJmolNBO);
        runPanel.add(box);
        JButton btn = new JButton("Run");
        btn.setAlignmentX(-0.5f);
        btn.setVisible(this.isJmolNBO);
        runPanel.add(btn).setFont(new Font("Arial", 0, 20));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.goRunClicked("", essBox.getSelectedItem().toString(), NBODialogRun.this.inputFile, NBODialogRun.this.showRunDone);
            }
        });
        if (this.isJmolNBO) {
            this.editOps.setSelectedIndex(this.editOps.getSelectedIndex() == 0 ? 1 : this.editOps.getSelectedIndex());
        }
        return runPanel;
    }

    protected int showConfDialog() {
        return JOptionPane.showConfirmDialog(this, "File already exists, overwrite contents?", "Overwrite file?", 0);
    }

    protected String showInputDialog() {
        return (String)JOptionPane.showInputDialog(this, "Save file as:", "Save file...", -1, null, null, this.plotFileName.getText() + ".47");
    }

    protected void addManualEditor() {
        final JDialog d = new JDialog((Dialog)this, "Keylist Editor");
        d.setLayout(new BorderLayout());
        final JTextPane p = new JTextPane();
        d.add((Component)p, "Center");
        p.setText("$NBO\nFile=" + this.jobStem + " " + this.nboKeywords + "\n$END");
        p.setCaretPosition(7);
        JButton btn = new JButton("Save Changes");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = p.getText();
                String tmp = s.replace("$NBO", "").replace("$END", "");
                NBODialogRun.this.nboKeywords = "";
                for (String x : tmp.split("\\s+")) {
                    if (!x.contains("=")) {
                        NBODialogRun.this.nboKeywords = NBODialogRun.this.nboKeywords + x + " ";
                        continue;
                    }
                    NBODialogRun.this.plotFileName.setText(x.substring(x.indexOf("=1")));
                }
                d.setVisible(false);
                NBODialogRun.this.editBox.repaint();
                NBODialogRun.this.editBox.revalidate();
            }
        });
        d.add((Component)btn, "South");
        this.centerDialog(d);
        d.setVisible(true);
        d.setSize(new Dimension(300, 300));
    }

    protected String getFileContents() {
        String fname = this.plotFileName.getText();
        String fileContents = this.fileData + "$NBO\n " + "FILE=" + (fname.equals("") ? this.jobStem : fname) + " " + this.nboKeywords + "  $END" + sep;
        return fileContents + this.getCurrentChooseList() + this.fileData2;
    }

    protected String getCurrentChooseList() {
        String tmp = "$CHOOSE";
        String tmp2 = "";
        if (this.lonePairs == null) {
            return "";
        }
        for (String s : this.lonePairs.keySet()) {
            if (((String)this.lonePairs.get(s)).equals("0")) continue;
            tmp2 = tmp2 + s + " " + (String)this.lonePairs.get(s) + " ";
        }
        if (!tmp2.equals("")) {
            tmp = tmp + sep + "  LONE " + tmp2 + "END";
        }
        tmp2 = "";
        for (String s : this.chooseBonds.keySet()) {
            tmp2 = tmp2 + this.chooseBonds.get(s) + " " + s + " ";
        }
        if (!tmp2.equals("")) {
            tmp = tmp + sep + "  BOND " + tmp2 + "END";
        }
        tmp2 = "";
        for (String s : this.choose3C.keySet()) {
            tmp2 = tmp2 + this.choose3C.get(s) + " " + s + " ";
        }
        if (!tmp2.equals("")) {
            tmp = tmp + sep + "  3C " + tmp2 + " END";
        }
        return tmp.equals("$CHOOSE") ? "" : tmp + sep + "$END" + sep;
    }

    protected void essChanged(String item, DefaultComboBoxModel<String> editModel) {
        this.clearInputFile();
        this.editBox.removeAll();
        this.editBox.add(Box.createRigidArea(new Dimension(430, 230)));
        if (item.equals("GenNBO")) {
            this.tfExt.setText("47");
            editModel.removeElement("Gaussian Input File");
            editModel.addElement(CHOOSE_DESCRIPTION);
            return;
        }
        if (item.equals("GO9")) {
            this.tfExt.setText("gau");
            editModel.addElement("Gaussian Input File");
            editModel.removeElement(CHOOSE_DESCRIPTION);
            return;
        }
    }

    protected void editOpChanged(String item) {
        this.editBox.removeAll();
        if (item.equals("-type-")) {
            this.editBox.add(Box.createRigidArea(new Dimension(320, 295)));
        } else if (item.startsWith("$NBO")) {
            this.addNBOKeylist();
        } else if (item.startsWith("Gaussian")) {
            JScrollPane p = new JScrollPane();
            GaussianDialog gau = new GaussianDialog(this.runFrame, this.vwr);
            p.setViewportView(gau.getContentPane());
            this.editBox.add(p);
        } else if (item.startsWith("$CHOOSE")) {
            this.addChooseKeylist();
        } else if (item.startsWith("$DEL")) {
            this.addDelKeylist();
        }
        this.repaint();
        this.revalidate();
    }

    @Override
    protected void readInputFile(File inputFile) {
        this.statusLab.setText("Reading input file");
        this.nboKeywords = "";
        this.plotFileName = new JTextField();
        BufferedReader b = null;
        try {
            b = new BufferedReader(new FileReader(inputFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        SB data = new SB();
        try {
            String line;
            while ((line = b.readLine()) != null) {
                data.append(line + sep);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PT.rep(data.toString(), "$end", "$END");
        String[] tokens = PT.split(data.toString(), "$END");
        if (tokens[0].trim().startsWith("$GENNBO")) {
            int pt = tokens[0].indexOf("NATOMS=");
            this.jmolAtomCount = Integer.parseInt(tokens[0].substring(pt + 7, tokens[0].indexOf(" ", pt)));
        }
        boolean atParams = false;
        SB fout = new SB();
        SB fout2 = new SB();
        if (tokens.length <= 0) {
            return;
        }
        int i = 0;
        while (true) {
            String s = tokens[i];
            s = PT.trim(s, "\t\r\n ");
            if (!atParams) {
                if (s.indexOf("$NBO") >= 0) {
                    atParams = true;
                    if (PT.split(s, "$NBO").length > 1) {
                        this.nboKeywords = this.cleanNBOKeylist(PT.split(s, "$NBO")[1]);
                    } else {
                        this.cleanNBOKeylist("");
                    }
                    s = "";
                    Logger.info("Params read: " + this.nboKeywords);
                }
                if (!s.equals("")) {
                    fout.append(s).append(sep);
                }
                if (++i == tokens.length) break;
                if (atParams) continue;
                fout.append("$END").append(sep);
                continue;
            }
            if (s.indexOf("$CHOOSE") >= 0) {
                this.setChooseList(s.substring(8), false);
                ++i;
                continue;
            }
            fout2.append(s).append(sep);
            if (++i == tokens.length) break;
            fout2.append("$END").append(sep);
        }
        this.fileData = fout.toString();
        this.fileData2 = fout2.toString();
        if (!this.nboKeywords.contains("PRINT=0")) {
            this.getChooseList();
        }
        this.statusLab.setText("");
    }

    protected boolean getChooseList() {
        this.valid3C = "";
        this.validBonds = "";
        this.validLP = "";
        File f = this.newNBOFile(this.inputFile, "nbo");
        if (!f.exists() || f.length() == 0L) {
            return false;
        }
        String[] tokens = PT.split(this.nboService.getFileData(f.toString()), "$CHOOSE");
        int i = 1;
        if (tokens.length < 2) {
            this.showConfirmationDialog("Error occurred during run. View .nbo file?", f, "nbo", 1);
            return false;
        }
        if (tokens[1].trim().startsWith("keylist")) {
            if (tokens[1].contains("NOBOND")) {
                this.nboService.runScriptQueued("select {*};connect delete; select remove {*}");
                return true;
            }
            if (!tokens[1].contains("Structure accepted:")) {
                if (tokens[1].contains("missing END?")) {
                    this.showConfirmationDialog("Error occurred during run. View .nbo file?", f, "nbo", 1);
                    return false;
                }
                if (tokens[2].contains("ignoring")) {
                    this.vwr.alert("Ignoring $CHOOSE list");
                } else {
                    return false;
                }
            }
            i = 3;
        }
        String data = tokens[i].substring(0, tokens[i].indexOf("$END"));
        this.setChooseList(data, true);
        return true;
    }

    private void setChooseList(String data, boolean isValid) {
        String[] tokens = PT.split(data, "END");
        this.lonePairs = new Hashtable();
        this.chooseBonds = new Hashtable();
        this.choose3C = new Hashtable();
        for (String x : tokens) {
            int j;
            String[] list = x.trim().split("\\s+");
            if (list[0].trim().equals("BOND")) {
                for (j = 1; j < list.length; j += 3) {
                    if (isValid) {
                        this.validBonds = this.validBonds + list[j] + "  " + list[j + 1] + " " + list[j + 2] + "\n";
                    }
                    this.chooseBonds.put(list[j + 1] + " " + list[j + 2], list[j]);
                }
                continue;
            }
            if (list[0].trim().equals("LONE")) {
                for (j = 1; j < list.length; j += 2) {
                    if (isValid) {
                        this.validLP = this.validLP + list[j] + "  " + list[j + 1] + "\n";
                    }
                    this.lonePairs.put(list[j], list[j + 1]);
                }
                continue;
            }
            if (!list[0].equals("3C")) continue;
            for (j = 1; j < list.length; j += 4) {
                if (isValid) {
                    this.valid3C = this.valid3C + list[j] + "  " + list[j + 1] + " " + list[j + 2] + " " + list[j + 3] + "\n";
                }
                this.choose3C.put(list[j + 1] + " " + list[j + 2] + " " + list[j + 3], list[j]);
            }
        }
    }

    protected void resetBadChooseList() {
        String[] st;
        int i;
        this.chooseBonds = new Hashtable();
        String[] data = this.validBonds.split("\n");
        if (!this.validBonds.equals("")) {
            for (i = 0; i < data.length; ++i) {
                st = data[i].split("  ");
                this.chooseBonds.put(st[1], st[0]);
            }
        }
        this.lonePairs = new Hashtable();
        data = this.validLP.split("\n");
        if (!this.validLP.equals("")) {
            for (i = 0; i < data.length; ++i) {
                st = data[i].split("  ");
                this.lonePairs.put(st[0], st[1]);
            }
        }
        this.choose3C = new Hashtable();
        data = this.valid3C.split("\n");
        if (!this.valid3C.equals("")) {
            for (i = 0; i < data.length; ++i) {
                st = data[i].split("  ");
                this.choose3C.put(st[1], st[0]);
            }
        }
    }

    @Override
    protected void setBonds(String[] atoms, String key) {
        if (!this.validBonds.equals("")) {
            this.nboService.runScriptNow("select {*};connect delete; select remove {*}");
            for (String s : this.validBonds.split("\n")) {
                this.nboService.runScriptNow("select remove {*}");
                String[] tokens = s.split("  ");
                key = tokens[0];
                atoms = tokens[1].split(" ");
                String script = "";
                for (String x : atoms) {
                    script = script + "select add (atomno=" + x + ");";
                }
                String partial = "";
                script = script + "connect ";
                if (atoms.length > 2) {
                    partial = "partial ";
                }
                if (key.startsWith("S")) {
                    script = script + partial + (!partial.equals("") ? "" : "single");
                } else if (key.startsWith("D")) {
                    script = script + partial + "double";
                } else if (key.startsWith("T")) {
                    script = script + partial + "triple";
                } else if (key.startsWith("Q")) {
                    script = script + partial + "quadruple";
                } else if (key.equals("")) {
                    script = script + "delete";
                }
                this.nboService.runScriptNow(script);
            }
        }
    }

    protected void addBond(String[] atoms, String key) {
        this.nboService.runScriptNow("select remove {*}");
        String script = "";
        for (String x : atoms) {
            script = script + "select add (atomno=" + x + ");";
        }
        String partial = "";
        script = script + "connect ";
        if (atoms.length > 2) {
            partial = "partial ";
        }
        if (key.startsWith("S")) {
            script = script + partial + (!partial.equals("") ? "" : "single");
        } else if (key.startsWith("D")) {
            script = script + partial + "double";
        } else if (key.startsWith("T")) {
            script = script + partial + "triple";
        } else if (key.startsWith("Q")) {
            script = script + partial + "quadruple";
        } else if (key.equals("")) {
            script = script + "delete";
        }
        this.nboService.runScriptNow(script);
    }

    private String cleanNBOKeylist(String params) {
        String[] tokens = PT.getTokens(PT.rep(PT.clean(params), "file=", "FILE="));
        String tmp = "";
        for (String s : tokens) {
            if (s.length() <= 0) continue;
            if (s.toLowerCase().contains("file=")) {
                this.plotFileName.setText(s.substring(s.indexOf("=") + 1));
                continue;
            }
            if (tmp.length() + s.length() - tmp.lastIndexOf(sep) >= 80) {
                tmp = tmp + sep + " ";
            }
            tmp = tmp + s.toUpperCase() + " ";
        }
        if (this.plotFileName.getText().equals("")) {
            this.plotFileName.setText(this.jobStem);
        }
        return tmp;
    }

    protected void addNBOKeylist() {
        if (this.inputFile != null) {
            this.editBox.removeAll();
            this.editBox.add(Box.createRigidArea(new Dimension(350, 0)));
            final DefaultListModel<String> sList = new DefaultListModel<String>();
            String tmp = "";
            for (String s : this.nboKeywords.split("\\s+")) {
                if (s.length() <= 0 || s.toUpperCase().contains("FILE=")) continue;
                sList.addElement(s);
                tmp = tmp + s + " ";
            }
            this.nboKeywords = tmp;
            final JList keywords = new JList(sList);
            keywords.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        NBODialogRun.this.removeListParams(keywords.getSelectedValuesList(), sList);
                    }
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Jobname ")).setFont(new Font("Arial", 1, 16));
            box.add(this.plotFileName).setMaximumSize(new Dimension(100, 30));
            box.setAlignmentX(0.5f);
            Box box2 = Box.createVerticalBox();
            box2.add(box);
            JLabel lab = new JLabel("(Plot files will be created with this name)");
            lab.setAlignmentX(0.5f);
            box2.add(lab);
            this.editBox.add(box2);
            box2 = Box.createHorizontalBox();
            box2.add(new JLabel("Keywords:  ")).setFont(new Font("Arial", 1, 16));
            final Box menu = Box.createVerticalBox();
            final JLabel lab2 = new JLabel("(Select one or more)");
            lab2.setVisible(false);
            menu.setVisible(false);
            JButton btn = new JButton("Menu Select");
            box2.add(btn);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    menu.setVisible(true);
                    lab2.setVisible(true);
                }
            });
            btn = new JButton("Text Editor");
            box2.add(btn);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBODialogRun.this.addManualEditor();
                }
            });
            this.editBox.add(box2);
            menu.setBorder(BorderFactory.createLoweredBevelBorder());
            this.keywordButtons = new JRadioButton[keywordList.length];
            for (int i = 0; i < this.keywordButtons.length; ++i) {
                this.keywordButtons[i] = new JRadioButton(keywordList[i]);
                if (this.nboKeywords.contains(keywordList[i].split(":")[0])) {
                    this.keywordButtons[i].setSelected(true);
                }
                final int op = i;
                this.keywordButtons[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String key = keywordList[op].split(":")[0];
                        if (NBODialogRun.this.keywordButtons[op].isSelected()) {
                            NBODialogRun.this.nboKeywords = NBODialogRun.this.nboKeywords + key + " ";
                            NBODialogRun.this.appendOutputWithCaret("Keyword added: " + key, 'i');
                        } else {
                            NBODialogRun.this.nboKeywords = NBODialogRun.this.nboKeywords.replaceAll(key + " ", "");
                            NBODialogRun.this.appendOutputWithCaret("Keyword removed: " + key, 'i');
                        }
                    }
                });
                menu.add(this.keywordButtons[i]);
            }
            menu.setAlignmentX(0.5f);
            this.editBox.add(menu);
            lab2.setAlignmentX(0.5f);
            this.editBox.add(lab2);
        }
    }

    void addChooseKeylist() {
        if (this.chooseBonds == null) {
            JTextField tf = new JTextField("$CHOOSE keylist not found");
            tf.setEditable(false);
            tf.setBorder(null);
            this.editBox.add(tf);
            this.editBox.add(Box.createRigidArea(new Dimension(290, 230)));
            return;
        }
        Object[] s = new String[this.jmolAtomCount];
        for (int i = 0; i < this.jmolAtomCount; ++i) {
            s[i] = "" + (i + 1);
        }
        Box b = this.chooseBox(s, "Number of Lone Pairs", new SpinnerNumberModel(0, 0, 8, 1), this.lonePairs, 0);
        b.setBorder(BorderFactory.createTitledBorder("Lone Pairs"));
        this.editBox.add(b);
        b = this.chooseBox(this.chooseBonds.keySet().toArray(), "Bond Order", new SpinnerListModel(new String[]{"S", "D", "T", "Q"}), this.chooseBonds, 2);
        b.setBorder(BorderFactory.createTitledBorder("Bonds"));
        this.editBox.add(b);
        b = this.chooseBox(this.choose3C.keySet().toArray(), "Bond Order", new SpinnerListModel(new String[]{"S", "D", "T", "Q"}), this.choose3C, 3);
        b.setBorder(BorderFactory.createTitledBorder("3 Center Bonds"));
        this.editBox.add(b);
        JButton btn = new JButton("Reset to Default Choose List");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        btn.setAlignmentX(0.5f);
        this.editBox.add(btn);
    }

    private Box chooseBox(Object[] list, String title, SpinnerModel model, final Hashtable<String, String> table, final int num) {
        Box b2 = Box.createHorizontalBox();
        String[] s = new String[list.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = list[i].toString();
        }
        final DefaultComboBoxModel<String> boxModel = new DefaultComboBoxModel<String>(s);
        final JComboBox<String> atoms = new JComboBox<String>(boxModel);
        atoms.setMaximumSize(new Dimension(70, 30));
        final JSpinner numLP = new JSpinner(model);
        numLP.setMaximumSize(new Dimension(40, 30));
        atoms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String item = atoms.getSelectedItem().toString();
                NBODialogRun.this.showSelected(item.split(" "));
                if (table.get(item) != null) {
                    if (num == 0) {
                        numLP.setValue(Integer.parseInt((String)table.get(item)));
                    } else {
                        numLP.setValue(table.get(item));
                    }
                } else {
                    numLP.setValue(0);
                }
            }
        });
        numLP.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                table.put(atoms.getSelectedItem().toString(), numLP.getValue().toString());
                if (num == 0) {
                    return;
                }
                NBODialogRun.this.addBond(atoms.getSelectedItem().toString().split(" "), numLP.getValue().toString());
                NBODialogRun.this.nboService.runScriptQueued("refresh");
                atoms.requestFocus();
            }
        });
        b2.add(new JLabel("Atom "));
        b2.add(atoms);
        b2.add(new JLabel(title));
        b2.add(numLP);
        if (boxModel.getSize() > 0) {
            atoms.setSelectedIndex(0);
        }
        if (num == 0) {
            b2.setAlignmentX(0.5f);
            return b2;
        }
        JButton remove = new JButton("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = atoms.getSelectedItem().toString();
                table.remove(s);
                boxModel.removeElement(atoms.getSelectedItem());
                String script = "select remove {*};";
                for (String x : s.split(" ")) {
                    script = script.concat("select add (atomno=" + x + ");");
                }
                NBODialogRun.this.nboService.runScriptQueued(script + "connect delete");
            }
        });
        b2.add(remove);
        Box box = Box.createVerticalBox();
        box.add(b2);
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel("Add (Enter atom numbers a1 a2)"));
        final JTextField tf = new JTextField();
        tf.setMaximumSize(new Dimension(200, 30));
        tf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String item = tf.getText().trim();
                String[] st = item.split(" ");
                tf.setText("");
                if (st.length != num) {
                    return;
                }
                boxModel.addElement(item);
                if (num == 2) {
                    NBODialogRun.this.chooseBonds.put(item, "S");
                } else {
                    NBODialogRun.this.choose3C.put(item, "S");
                }
                NBODialogRun.this.addBond(st, "S");
                NBODialogRun.this.nboService.runScriptQueued("refresh");
                atoms.setSelectedItem(item);
            }
        });
        box2.add(tf);
        box.add(box2);
        box.setAlignmentX(0.5f);
        return box;
    }

    private void addDelKeylist() {
        Box b = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Orbital #s:"));
        final JTextField tf = new JTextField();
        tf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                NBODialogRun.this.delOrbs = tf.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                NBODialogRun.this.delOrbs = tf.getText();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                NBODialogRun.this.delOrbs = tf.getText();
            }
        });
        b2.add(tf);
        b2.setBorder(BorderFactory.createTitledBorder("Delete orbitals (ex: 1 22 13 ...)"));
        b2.setAlignmentX(0.0f);
        b.add(b2);
        final JButton btn2 = new JButton("Add Element");
        if (this.deleteElements == null) {
            this.deleteElements = new ArrayList(10);
        }
        final JPanel elems = new JPanel(new FlowLayout());
        final JScrollPane p2 = new JScrollPane();
        btn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.addDelFieldEl(elems, btn2, p2, "", "", NBODialogRun.this.deleteElements, 0);
            }
        });
        elems.add(btn2);
        p2.setBorder(BorderFactory.createTitledBorder("Delete single Fock matrix elements"));
        p2.getViewport().add(elems);
        p2.setPreferredSize(new Dimension(300, 80));
        p2.setAlignmentX(0.0f);
        b.add(p2);
        if (this.deleteBlocks == null) {
            this.deleteBlocks = new ArrayList(5);
            this.deleteBlocks.add("");
        }
        final Box box = Box.createVerticalBox();
        box.setAlignmentX(0.0f);
        final JButton btn = new JButton("Add Deletion Block");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.deleteBlocks(btn, box, NBODialogRun.this.deleteBlocks, 0);
            }
        });
        box.add(btn);
        box.setBorder(BorderFactory.createTitledBorder("Delete blocks of Fock matrix"));
        box.setMaximumSize(new Dimension(320, 1000));
        b.add(box);
        b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Orbital #s:"));
        final JTextField tf2 = new JTextField();
        tf2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                NBODialogRun.this.delOrbsL = tf2.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                NBODialogRun.this.delOrbsL = tf2.getText();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                NBODialogRun.this.delOrbsL = tf2.getText();
            }
        });
        b2.add(tf2);
        b2.setBorder(BorderFactory.createTitledBorder("Delete non-Lewis orbitals (ex: 1 22 13 ...)"));
        b2.setAlignmentX(0.0f);
        b.add(b2);
        final JButton btn4 = new JButton("Add Delocalization");
        if (this.delDeloc == null) {
            this.delDeloc = new ArrayList(5);
        }
        final JPanel elems2 = new JPanel(new FlowLayout());
        final JScrollPane p3 = new JScrollPane();
        btn4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.addDelFieldEl(elems2, btn4, p3, "From", "To", NBODialogRun.this.delDeloc, 0);
            }
        });
        elems2.add(btn4);
        p3.setBorder(BorderFactory.createTitledBorder("Zero delocilation between molecular units"));
        p3.getViewport().add(elems2);
        p3.setPreferredSize(new Dimension(300, 80));
        p3.setAlignmentX(0.0f);
        b.add(p3);
        if (this.deleteAtomBlocks == null) {
            this.deleteAtomBlocks = new ArrayList(5);
            this.deleteAtomBlocks.add("");
        }
        final Box box2 = Box.createVerticalBox();
        box2.setAlignmentX(0.0f);
        final JButton btn3 = new JButton("Add Deletion Block");
        btn3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.deleteBlocks(btn3, box2, NBODialogRun.this.deleteAtomBlocks, 0);
            }
        });
        box2.add(btn3);
        box2.setBorder(BorderFactory.createTitledBorder("Zero delocalizations between atom blocks"));
        box2.setMaximumSize(new Dimension(320, 1000));
        b.add(box2);
        b2 = Box.createVerticalBox();
        final JCheckBox cb = new JCheckBox("Delete all non-Lewis orbitals");
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.deleteLewisOrbs = cb.isSelected();
            }
        });
        cb.setAlignmentX(0.0f);
        b2.add(cb);
        final JCheckBox cb2 = new JCheckBox("Delete all vicinal delocalizations");
        cb2.setAlignmentX(0.0f);
        b2.add(cb2);
        cb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.deleteVicinal = cb2.isSelected();
            }
        });
        final JCheckBox cb3 = new JCheckBox("Delete all geminal delocalizations");
        cb3.setAlignmentX(0.0f);
        b2.add(cb3);
        cb3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.deleteGeminal = cb3.isSelected();
            }
        });
        b2.setBorder(BorderFactory.createTitledBorder("Other options"));
        b.add(b2);
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(b);
        sp.setHorizontalScrollBarPolicy(31);
        this.editBox.add(sp);
        b.setMinimumSize(new Dimension(300, 400));
    }

    protected void addDelFieldEl(final JPanel b, final JButton btn, final JScrollPane p, final String s1, final String s2, final List<String> deleteElements, final int val) {
        final JTextField tf = new JTextField();
        final JTextField tf2 = new JTextField();
        p.remove(btn);
        deleteElements.add("");
        DocumentListener listener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                deleteElements.set(val, tf.getText() + " " + tf2.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                deleteElements.set(val, tf.getText() + " " + tf2.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                deleteElements.set(val, tf.getText() + " " + tf2.getText());
            }
        };
        tf.getDocument().addDocumentListener(listener);
        tf2.getDocument().addDocumentListener(listener);
        tf.setPreferredSize(new Dimension(30, 30));
        tf2.setPreferredSize(new Dimension(30, 30));
        if (val != 0) {
            b.add(new JLabel(","));
        }
        b.add(new JLabel(s1));
        b.add(tf);
        b.add(new JLabel(s2));
        b.add(tf2);
        b.repaint();
        b.revalidate();
        for (ActionListener a : btn.getActionListeners()) {
            btn.removeActionListener(a);
        }
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.addDelFieldEl(b, btn, p, s1, s2, deleteElements, val + 1);
            }
        });
        b.add(btn);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tf.requestFocus();
                p.getHorizontalScrollBar().setValue(p.getHorizontalScrollBar().getMaximum() + 30);
            }
        });
    }

    protected void deleteBlocks(final JButton btn, final Box container, final ArrayList<String> deleteBlocks, final int val) {
        for (ActionListener a : btn.getActionListeners()) {
            btn.removeActionListener(a);
        }
        container.remove(btn);
        deleteBlocks.add("");
        final Box blockBox = Box.createHorizontalBox();
        Integer[] intOps = new Integer[]{new Integer(1), 2, 3, 4, 5, 6, 7, 8, 9, 10};
        final JComboBox<Integer> cBox = new JComboBox<Integer>(intOps);
        cBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        cBox.setMaximumSize(new Dimension(40, 30));
        Box b3 = Box.createHorizontalBox();
        b3.add(new JLabel("BLOCK "));
        b3.add(cBox);
        b3.add(new JLabel(" by "));
        b3.setAlignmentX(0.0f);
        final JComboBox<Integer> cBox2 = new JComboBox<Integer>(intOps);
        cBox2.setMaximumSize(new Dimension(40, 30));
        b3.add(cBox2);
        Box b2 = Box.createVerticalBox();
        b2.add(b3);
        JButton btn2 = new JButton("Remove Block");
        btn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                container.remove(blockBox);
                container.repaint();
                container.revalidate();
            }
        });
        btn2.setAlignmentX(0.0f);
        b2.add(btn2);
        blockBox.add(b2);
        cBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        b2 = Box.createVerticalBox();
        final JTextField tf = new JTextField();
        final JTextField tf2 = new JTextField();
        DocumentListener listener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                String s = tf.getText().trim();
                String s2 = tf2.getText().trim();
                int v1 = s.split(" ").length;
                int v2 = s2.split(" ").length;
                cBox.setSelectedIndex(v1 - 1);
                cBox2.setSelectedIndex(v2 - 1);
                deleteBlocks.set(val, tf.getText() + "\n  " + tf2.getText());
                deleteBlocks.set(0, v1 + " " + v2);
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                String s = tf.getText().trim();
                String s2 = tf2.getText().trim();
                int v1 = s.split(" ").length;
                int v2 = s2.split(" ").length;
                cBox.setSelectedIndex(v1 - 1);
                cBox2.setSelectedIndex(v2 - 1);
                deleteBlocks.set(val, tf.getText() + "\n  " + tf2.getText());
                deleteBlocks.set(0, v1 + " " + v2);
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                String s = tf.getText().trim();
                String s2 = tf2.getText().trim();
                int v1 = s.split(" ").length;
                int v2 = s2.split(" ").length;
                cBox.setSelectedIndex(v1 - 1);
                cBox2.setSelectedIndex(v2 - 1);
                deleteBlocks.set(val, tf.getText() + "\n  " + tf2.getText());
                deleteBlocks.set(0, v1 + " " + v2);
            }
        };
        tf.getDocument().addDocumentListener(listener);
        tf2.getDocument().addDocumentListener(listener);
        b2.add(tf);
        b2.add(tf2);
        b2.setPreferredSize(new Dimension(100, 80));
        blockBox.add(b2);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.deleteBlocks(btn, container, deleteBlocks, val + 1);
            }
        });
        container.add(blockBox);
        container.add(btn);
        container.repaint();
        container.revalidate();
    }

    protected String getDelList() {
        String tmp = "$DEL";
        if (!this.delOrbs.trim().equals("")) {
            tmp = tmp + "\n  DELETE " + this.delOrbs.split("\\s+").length + " ORBITALS " + this.delOrbs;
        }
        if (this.deleteElements.size() != 0) {
            tmp = tmp + "\n  DELETE " + this.deleteElements.size() + " ELEMENTS ";
            for (String x : this.deleteElements) {
                tmp = tmp + x + "  ";
            }
        }
        if (this.deleteBlocks.size() != 0) {
            tmp = tmp + "\n  DELETE " + (this.deleteBlocks.size() - 1) + " BLOCKS ";
            int i = 1;
            while (i < this.deleteBlocks.size()) {
            }
        }
        if (this.delDeloc.size() != 0) {
            tmp = tmp + "\n  ZERO " + this.delDeloc.size() + " UNITS ";
            for (String x : this.delDeloc) {
                tmp = tmp + x + "  ";
            }
        }
        if (!this.delOrbsL.trim().equals("")) {
            tmp = tmp + "\n  ULEWIS " + this.delOrbsL.split("\\s+").length + " UNITS " + this.delOrbsL;
        }
        if (this.deleteLewisOrbs) {
            tmp = tmp + "\n  LEWIS";
        }
        if (this.deleteGeminal) {
            tmp = tmp + "\n  NOGEM";
        }
        if (this.deleteVicinal) {
            tmp = tmp + "\n NOVIC";
        }
        return tmp.equals("$DEL") ? null : tmp + "\n$END";
    }

    protected void resetRunFile() {
        this.chooseBonds = new Hashtable();
        this.lonePairs = new Hashtable();
        this.choose3C = new Hashtable();
        this.delOrbsL = "";
        this.delOrbs = "";
        this.deleteElements = new ArrayList();
        this.deleteBlocks = new ArrayList();
        this.delDeloc = new ArrayList();
        this.deleteAtomBlocks = new ArrayList();
    }

    protected void removeListParams(List<String> list, DefaultListModel<String> listModel) {
        this.appendOutputWithCaret("Keyword(s) removed:", 'p');
        for (String x : list) {
            listModel.removeElement(x);
            if (!this.nboKeywords.toUpperCase().contains(x.toUpperCase())) continue;
            this.nboKeywords = this.nboKeywords.substring(0, this.nboKeywords.indexOf(x.toUpperCase())) + this.nboKeywords.substring(this.nboKeywords.indexOf(x.toUpperCase()) + x.length());
            this.appendOutputWithCaret("  " + x, 'i');
        }
    }

    @Override
    protected synchronized void goRunClicked(String keywords, String ess, File inputFile, Runnable whenDone) {
        this.runJob(keywords, inputFile, ess, whenDone);
    }

    private void runJob(String keywords, File inputFile, String ess, final Runnable whenDone) {
        String label = "";
        for (String x : keywords.split(" ")) {
            if (this.nboKeywords.contains(x = x.toUpperCase())) continue;
            label = label + x + " ";
        }
        if (this.fileData == null) {
            this.readInputFile(inputFile);
        }
        this.nboKeywords = this.nboKeywords + label;
        label = "";
        try {
            this.nboService.writeToFile(this.getFileContents(), inputFile);
        }
        catch (IOException e) {
            Logger.info("Could not create " + inputFile);
            return;
        }
        final SB sb = new SB();
        this.appendToFile("GLOBAL C_PATH " + inputFile.getParent() + sep, sb);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sb);
        this.appendToFile("GLOBAL C_ESS " + ess.toLowerCase() + sep, sb);
        String st = this.plotFileName.getText().trim();
        this.appendToFile("GLOBAL C_LABEL_1 FILE=" + (st.equals("") ? this.jobStem : st), sb);
        this.nboService.queueJob("run", "running " + ess + "...", new Runnable(){

            @Override
            public void run() {
                NBODialogRun.this.nboService.rawCmdNew("r", sb, true, 20);
                try {
                    if (whenDone != null) {
                        NBODialogRun.this.nboService.queueJob("load file", "", whenDone);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

