/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;

public class AssumeNoSideEffectsChecker {
    private final WarningPrinter notePrinter;

    public AssumeNoSideEffectsChecker(WarningPrinter warningPrinter) {
        this.notePrinter = warningPrinter;
    }

    public void checkClassSpecifications(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                List list2;
                ClassSpecification classSpecification = (ClassSpecification)list.get(i);
                String string = classSpecification.className;
                if (string == null) {
                    string = classSpecification.extendsClassName;
                }
                if (string != null && !this.notePrinter.accepts(string) || (list2 = classSpecification.methodSpecifications) == null) continue;
                for (int j = 0; j < list2.size(); ++j) {
                    MemberSpecification memberSpecification = (MemberSpecification)list2.get(j);
                    if (memberSpecification.name != null || memberSpecification.descriptor != null) continue;
                    this.notePrinter.print(string, "Note: the configuration specifies that none of the methods of class '" + (string == null ? "*" : ClassUtil.externalClassName(string)) + "' have any side effects");
                }
            }
        }
    }
}

