/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.Base64;
import com.eteks.sweethome3d.io.ContentDigestManager;
import com.eteks.sweethome3d.io.ContentRecording;
import com.eteks.sweethome3d.io.DamagedHomeIOException;
import com.eteks.sweethome3d.io.HomeURLContent;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CatalogTexture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.TexturesCategory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHomeInputStream
extends FilterInputStream {
    private final ContentRecording contentRecording;
    private final UserPreferences preferences;
    private Set<URLContent> preferencesContentsCache;
    private boolean preferPreferencesContent;

    public DefaultHomeInputStream(InputStream inputStream) throws IOException {
        this(inputStream, ContentRecording.INCLUDE_ALL_CONTENT);
    }

    public DefaultHomeInputStream(InputStream inputStream, ContentRecording contentRecording) throws IOException {
        this(inputStream, contentRecording, null, false);
    }

    public DefaultHomeInputStream(InputStream inputStream, ContentRecording contentRecording, UserPreferences userPreferences, boolean bl) {
        super(inputStream);
        this.contentRecording = contentRecording;
        this.preferences = userPreferences;
        this.preferPreferencesContent = bl;
    }

    private static void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Home readHome() throws IOException, ClassNotFoundException {
        Object object;
        Object object2;
        Closeable closeable;
        File file = null;
        boolean bl = true;
        Map<URLContent, byte[]> map = null;
        if (this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
            file = OperatingSystem.createTemporaryFile("open", ".sweethome3d");
            closeable = new BufferedOutputStream(new FileOutputStream(file));
            object2 = new CopiedInputStream(new BufferedInputStream(this.in), (OutputStream)closeable);
            boolean bl2 = bl = this.isZipFileValidUsingInputStream((InputStream)object2, (List<ZipEntry>)(object = new ArrayList<ZipEntry>())) && object.size() > 0;
            if (!bl) {
                int n = object.size();
                object.clear();
                this.isZipFileValidUsingDictionnary(file, (List<ZipEntry>)object);
                file = object.size() > n ? this.createTemporaryFileFromValidEntries(file, (List<ZipEntry>)object) : this.createTemporaryFileFromValidEntriesCount(file, n);
            }
            map = this.readContentDigests(file);
            if (this.preferences != null && this.preferencesContentsCache == null) {
                this.preferencesContentsCache = this.getUserPreferencesContent(this.preferences);
            }
        }
        closeable = null;
        try {
            Object object3;
            closeable = new ZipInputStream(this.contentRecording == ContentRecording.INCLUDE_NO_CONTENT ? this.in : new FileInputStream(file));
            while ((object2 = ((ZipInputStream)closeable).getNextEntry()) != null && !"Home".equals(((ZipEntry)object2).getName())) {
            }
            if (object2 == null) {
                throw new IOException("Missing entry \"Home\"");
            }
            DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            object = new HomeObjectInputStream((InputStream)closeable, file, map);
            Home home = (Home)((ObjectInputStream)object).readObject();
            if (!bl || ((HomeObjectInputStream)object).containsInvalidContents()) {
                object3 = ((HomeObjectInputStream)object).getInvalidContents();
                if (map != null && object3.size() == 0) {
                    home.setRepaired(true);
                } else {
                    throw new DamagedHomeIOException(home, (List<Content>)object3);
                }
            }
            object3 = home;
            return object3;
        }
        finally {
            if (closeable != null) {
                ((ZipInputStream)closeable).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFileValidUsingInputStream(InputStream inputStream, List<ZipEntry> list) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            byte[] byArray = new byte[8192];
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                while (zipInputStream.read(byArray) != -1) {
                }
                list.add(zipEntry);
                DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZipFileValidUsingDictionnary(File file, List<ZipEntry> list) throws IOException {
        ZipFile zipFile = null;
        boolean bl = true;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                try {
                    ZipEntry zipEntry = enumeration.nextElement();
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    byte[] byArray = new byte[8192];
                    while (inputStream.read(byArray) != -1) {
                    }
                    inputStream.close();
                    list.add(zipEntry);
                    DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
                }
                catch (IOException iOException) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTemporaryFileFromValidEntriesCount(File file, int n) throws IOException {
        if (n <= 0) {
            throw new IOException("No valid entries");
        }
        File file2 = OperatingSystem.createTemporaryFile("part", ".sh3d");
        ZipOutputStream zipOutputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            zipOutputStream.setLevel(0);
            while (n-- > 0) {
                this.copyEntry(zipInputStream, zipInputStream.getNextEntry(), zipOutputStream);
            }
            File file3 = file2;
            return file3;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTemporaryFileFromValidEntries(File file, List<ZipEntry> list) throws IOException {
        if (list.size() <= 0) {
            throw new IOException("No valid entries");
        }
        File file2 = OperatingSystem.createTemporaryFile("part", ".sh3d");
        ZipOutputStream zipOutputStream = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            zipOutputStream.setLevel(0);
            for (ZipEntry zipEntry : list) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                this.copyEntry(inputStream, zipEntry, zipOutputStream);
                inputStream.close();
            }
            File file3 = file2;
            return file3;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private void copyEntry(InputStream inputStream, ZipEntry zipEntry, ZipOutputStream zipOutputStream) throws IOException {
        int n;
        DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setComment(zipEntry.getComment());
        zipEntry2.setTime(zipEntry.getTime());
        zipEntry2.setExtra(zipEntry.getExtra());
        zipOutputStream.putNextEntry(zipEntry2);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        zipOutputStream.closeEntry();
    }

    private Set<URLContent> getUserPreferencesContent(UserPreferences userPreferences) {
        HashSet<URLContent> hashSet = new HashSet<URLContent>();
        for (FurnitureCategory comparable : userPreferences.getFurnitureCatalog().getCategories()) {
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : comparable.getFurniture()) {
                this.addURLContent(catalogPieceOfFurniture.getIcon(), hashSet);
                this.addURLContent(catalogPieceOfFurniture.getModel(), hashSet);
                this.addURLContent(catalogPieceOfFurniture.getPlanIcon(), hashSet);
            }
        }
        for (TexturesCategory texturesCategory : userPreferences.getTexturesCatalog().getCategories()) {
            for (CatalogTexture catalogTexture : texturesCategory.getTextures()) {
                this.addURLContent(catalogTexture.getImage(), hashSet);
            }
        }
        return hashSet;
    }

    private void addURLContent(Content content, Set<URLContent> set) {
        if (content instanceof URLContent) {
            set.add((URLContent)content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URLContent, byte[]> readContentDigests(File file) {
        ZipFile zipFile = null;
        try {
            BufferedReader bufferedReader;
            String string;
            zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("ContentDigests");
            if (zipEntry != null && (string = (bufferedReader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry), "UTF-8"))).readLine()) != null && string.trim().startsWith("ContentDigests-Version: 1")) {
                Object object;
                HashMap<URLContent, byte[]> hashMap = new HashMap<URLContent, byte[]>();
                String string2 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("Name:")) {
                        string2 = string.substring("Name:".length()).trim();
                        continue;
                    }
                    if (!string.startsWith("SHA-1-Digest:")) continue;
                    object = Base64.decode(string.substring("SHA-1-Digest:".length()).trim());
                    if (string2 == null) {
                        throw new IOException("Missing entry name");
                    }
                    URL uRL = new URL("jar:" + file.toURI() + "!/" + string2);
                    hashMap.put(new HomeURLContent(uRL), (byte[])object);
                    string2 = null;
                }
                object = hashMap;
                return object;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HomeObjectInputStream
    extends ObjectInputStream {
        private File zipFile;
        private Map<URLContent, byte[]> contentDigests;
        private boolean containsInvalidContents;
        private List<Content> invalidContents;
        private List<URLContent> validContentsNotInPreferences;

        public HomeObjectInputStream(InputStream inputStream, File file, Map<URLContent, byte[]> map) throws IOException {
            super(inputStream);
            if (DefaultHomeInputStream.this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                this.enableResolveObject(true);
                this.zipFile = file;
                this.contentDigests = map;
                this.invalidContents = new ArrayList<Content>();
                this.validContentsNotInPreferences = new ArrayList<URLContent>();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected Object resolveObject(Object object) throws IOException {
            if (!(object instanceof URLContent)) return object;
            URL uRL = ((URLContent)object).getURL();
            String string = uRL.toString();
            if (!string.startsWith("jar:file:temp!/")) return object;
            String string2 = string.substring(string.indexOf(33) + 2);
            URL uRL2 = new URL("jar:" + this.zipFile.toURI() + "!/" + string2);
            HomeURLContent homeURLContent = new HomeURLContent(uRL2);
            ContentDigestManager contentDigestManager = ContentDigestManager.getInstance();
            if (!this.isValid(homeURLContent)) {
                this.containsInvalidContents = true;
                URLContent uRLContent = this.findUserPreferencesContent(homeURLContent);
                if (uRLContent != null) {
                    return uRLContent;
                }
                this.invalidContents.add(homeURLContent);
                return homeURLContent;
            }
            for (URLContent uRLContent : this.validContentsNotInPreferences) {
                if (!contentDigestManager.equals(homeURLContent, uRLContent)) continue;
                return uRLContent;
            }
            DefaultHomeInputStream.checkCurrentThreadIsntInterrupted();
            if (this.contentDigests != null) {
                byte[] byArray = this.contentDigests.get(homeURLContent);
                Object object2 = byArray;
                if (byArray != null && !contentDigestManager.isContentDigestEqual(homeURLContent, (byte[])object2)) {
                    this.containsInvalidContents = true;
                    URLContent uRLContent = this.findUserPreferencesContent(homeURLContent);
                    if (uRLContent != null) {
                        return uRLContent;
                    }
                    this.invalidContents.add(homeURLContent);
                    return homeURLContent;
                }
            }
            if (DefaultHomeInputStream.this.preferencesContentsCache != null && DefaultHomeInputStream.this.preferPreferencesContent) {
                for (URLContent uRLContent : DefaultHomeInputStream.this.preferencesContentsCache) {
                    if (!contentDigestManager.equals(homeURLContent, uRLContent)) continue;
                    return uRLContent;
                }
            }
            this.validContentsNotInPreferences.add(homeURLContent);
            return homeURLContent;
        }

        public boolean containsInvalidContents() {
            return this.containsInvalidContents;
        }

        private boolean isValid(Content content) {
            try {
                InputStream inputStream = content.openStream();
                try {
                    inputStream.close();
                    return true;
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        private URLContent findUserPreferencesContent(URLContent uRLContent) {
            byte[] byArray;
            if (this.contentDigests != null && DefaultHomeInputStream.this.preferencesContentsCache != null && (byArray = this.contentDigests.get(uRLContent)) != null) {
                ContentDigestManager contentDigestManager = ContentDigestManager.getInstance();
                for (URLContent uRLContent2 : DefaultHomeInputStream.this.preferencesContentsCache) {
                    if (!contentDigestManager.isContentDigestEqual(uRLContent2, byArray)) continue;
                    return uRLContent2;
                }
            }
            return null;
        }

        public List<Content> getInvalidContents() {
            return Collections.unmodifiableList(this.invalidContents);
        }
    }

    private class CopiedInputStream
    extends FilterInputStream {
        private OutputStream out;

        protected CopiedInputStream(InputStream inputStream, OutputStream outputStream) {
            super(inputStream);
            this.out = outputStream;
        }

        public int read() throws IOException {
            int n = super.read();
            if (n != -1) {
                this.out.write(n);
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                this.out.write(byArray, n, n3);
            }
            return n3;
        }

        public void close() throws IOException {
            try {
                int n;
                byte[] byArray = new byte[8192];
                while ((n = this.in.read(byArray)) != -1) {
                    this.out.write(byArray, 0, n);
                }
                this.out.flush();
            }
            finally {
                this.out.close();
                super.close();
            }
        }
    }
}

