/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.HomeTexture;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Baseboard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final float thickness;
    private final float height;
    private final Integer color;
    private final HomeTexture texture;
    private static final List<WeakReference<Baseboard>> baseboardsCache = new ArrayList<WeakReference<Baseboard>>();

    public Baseboard(float f, float f2, Integer n, HomeTexture homeTexture) {
        this(f2, f, n, homeTexture, true);
    }

    private Baseboard(float f, float f2, Integer n, HomeTexture homeTexture, boolean bl) {
        this.height = f2;
        this.thickness = f;
        this.color = n;
        this.texture = homeTexture;
        if (bl) {
            baseboardsCache.add(new WeakReference<Baseboard>(this));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        baseboardsCache.add(new WeakReference<Baseboard>(this));
    }

    public static Baseboard getInstance(float f, float f2, Integer n, HomeTexture homeTexture) {
        Baseboard baseboard = new Baseboard(f, f2, n, homeTexture, false);
        Iterator<WeakReference<Baseboard>> iterator = baseboardsCache.iterator();
        while (iterator.hasNext()) {
            WeakReference<Baseboard> weakReference = iterator.next();
            Baseboard baseboard2 = (Baseboard)weakReference.get();
            if (baseboard2 == null) {
                iterator.remove();
                continue;
            }
            if (!baseboard2.equals(baseboard)) continue;
            return baseboard;
        }
        baseboardsCache.add(new WeakReference<Baseboard>(baseboard));
        return baseboard;
    }

    public float getThickness() {
        return this.thickness;
    }

    public float getHeight() {
        return this.height;
    }

    public Integer getColor() {
        return this.color;
    }

    public HomeTexture getTexture() {
        return this.texture;
    }

    public boolean equals(Object object) {
        if (object instanceof Baseboard) {
            Baseboard baseboard = (Baseboard)object;
            return baseboard.thickness == this.thickness && baseboard.height == this.height && (baseboard.color == this.color || baseboard.color != null && baseboard.color.equals(this.color)) && (baseboard.texture == this.texture || baseboard.texture != null && baseboard.texture.equals(this.texture));
        }
        return false;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.thickness) + Float.floatToIntBits(this.height);
        if (this.color != null) {
            n += this.color.hashCode();
        }
        if (this.texture != null) {
            n += this.texture.hashCode();
        }
        return n;
    }
}

