/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.controller;

import ch.softenvironment.controller.DataBrowserListener;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.util.UserException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DataBrowser {
    private List objects = new ArrayList();
    private int currentIndex = -1;
    private int step = 1;
    private Set listeners = new HashSet();

    public final void addListener(DataBrowserListener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(DataBrowserListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        } else {
            Tracer.getInstance().developerWarning("trying to remove a non-existant listener: " + listener);
        }
    }

    public synchronized Object getFirst() {
        if (this.getObjects().size() > 0 && this.currentIndex != 0) {
            this.setCurrentIndex(0);
        }
        return this.getCurrentObject();
    }

    public synchronized Object getPrevious() {
        if (this.currentIndex > 0) {
            if (this.currentIndex - this.step < 0) {
                this.setCurrentIndex(0);
            } else {
                this.setCurrentIndex(this.currentIndex - this.step);
            }
        }
        return this.getCurrentObject();
    }

    public synchronized Object getNext() {
        if (this.objects.size() > 0 && this.currentIndex + this.step < this.objects.size()) {
            this.setCurrentIndex(this.currentIndex + this.step);
        }
        return this.getCurrentObject();
    }

    public synchronized Object getLast() {
        if (this.objects.size() > 1) {
            int slices = this.objects.size() / this.getStep();
            int index = this.getStep() * slices;
            if (this.getStep() % 2 != 0) {
                --index;
            }
            if (index >= this.objects.size()) {
                index = this.objects.size() - 1;
            }
            this.setCurrentIndex(index);
        }
        return this.getCurrentObject();
    }

    public final List getObjects() {
        return this.objects;
    }

    public final synchronized void setObjects(List objects) {
        if (objects == null) {
            throw new IllegalArgumentException("objects must not be empty");
        }
        this.objects = objects;
        this.currentIndex = -1;
        this.getFirst();
    }

    private void signalCurrentObject() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((DataBrowserListener)it.next()).setCurrentObject(this.getCurrentObject());
        }
    }

    public final Object getCurrentObject() {
        if (this.currentIndex > -1) {
            return this.objects.get(this.currentIndex);
        }
        return null;
    }

    public synchronized void addObject(Object object) {
        this.objects.add(object);
        this.getLast();
    }

    public void removeCurrentObject() {
        if (this.getCurrentObject() != null) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                if (!((DataBrowserListener)it.next()).removeObject(this.getCurrentObject())) continue;
                throw new UserException("Veto was intervened by one of the listeners.", "Remove not possible");
            }
            this.objects.remove(this.getCurrentObject());
            if (this.currentIndex > 0) {
                --this.currentIndex;
            } else if (this.objects.size() == 0) {
                this.currentIndex = -1;
            }
            this.signalCurrentObject();
        }
    }

    private void saveChanges() {
        if (this.getCurrentObject() != null) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                this.objects.set(this.currentIndex, ((DataBrowserListener)it.next()).saveChanges(this.getCurrentObject()));
            }
        }
    }

    public final boolean isScrollFirstAllowed() {
        return this.isScrollPreviousAllowed();
    }

    public final boolean isScrollPreviousAllowed() {
        return this.currentIndex > 0;
    }

    public final boolean isScrollNextAllowed() {
        return this.objects.size() > 0 && this.currentIndex + this.getStep() < this.objects.size();
    }

    public final boolean isScrollLastAllowed() {
        return this.isScrollNextAllowed();
    }

    public boolean isRemoveAllowed() {
        return this.getCurrentObject() != null;
    }

    public final String getScrollIndexString() {
        try {
            if (this.objects.size() > 0) {
                return this.getCurrentIndex() + 1 + "/" + this.objects.size();
            }
            return "0/0";
        }
        catch (Throwable e) {
            Tracer.getInstance().developerWarning(e.getLocalizedMessage());
            return " ";
        }
    }

    public final int getCurrentIndex() {
        return this.currentIndex;
    }

    public synchronized void setCurrentIndex(int index) {
        if (index < 0 || index > this.objects.size() - 1) {
            throw new IndexOutOfBoundsException("desired index=" + index + " of max. " + this.objects.size());
        }
        if (this.currentIndex != index) {
            this.saveChanges();
            this.currentIndex = index;
            this.signalCurrentObject();
        }
    }

    public synchronized void setStep(int step) {
        if (step < 1) {
            Tracer.getInstance().runtimeWarning("Auto-correction: step must be >= 1!");
            this.step = 1;
        }
        this.step = step;
    }

    public final int getStep() {
        return this.step;
    }
}

