/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.jts;

import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.jts.Iox2jtsException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKBWriter;
import java.util.Collection;

public class Iox2jts {
    private Iox2jts() {
    }

    private static double dist(double re1, double ho1, double re2, double ho2) {
        double ret = Math.hypot(re2 - re1, ho2 - ho1);
        return ret;
    }

    public static String coord2hexwkb(IomObject value) throws Iox2jtsException {
        if (value != null) {
            Point geom = new GeometryFactory().createPoint(Iox2jts.coord2JTS(value));
            byte[] bv = new WKBWriter().write((Geometry)geom);
            return WKBWriter.bytesToHex((byte[])bv);
        }
        return null;
    }

    public static String polyline2hexwkb(IomObject value, double p) throws Iox2jtsException {
        if (value != null) {
            LineString geom = new GeometryFactory().createLineString(Iox2jts.polyline2JTS(value, false, p).toCoordinateArray());
            byte[] bv = new WKBWriter().write((Geometry)geom);
            return WKBWriter.bytesToHex((byte[])bv);
        }
        return null;
    }

    public static String surface2hexwkb(IomObject value, double strokeP) throws Iox2jtsException {
        if (value != null) {
            Polygon geom = Iox2jts.surface2JTS(value, strokeP);
            byte[] bv = new WKBWriter().write((Geometry)geom);
            return WKBWriter.bytesToHex((byte[])bv);
        }
        return null;
    }

    public static Coordinate coord2JTS(IomObject value) throws Iox2jtsException {
        double yCoord;
        double xCoord;
        if (value == null) {
            return null;
        }
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2jtsException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2jtsException("failed to read C2 <" + c2 + ">", ex);
        }
        Coordinate coord = null;
        if (c3 == null) {
            coord = new Coordinate(xCoord, yCoord);
        } else {
            double zCoord;
            try {
                zCoord = Double.parseDouble(c3);
            }
            catch (Exception ex) {
                throw new Iox2jtsException("failed to read C3 <" + c3 + ">", ex);
            }
            coord = new Coordinate(xCoord, yCoord, zCoord);
        }
        return coord;
    }

    private static void arc2JTS(CoordinateList ret, IomObject value, double p) throws Iox2jtsException {
        if (value != null) {
            double pti_ho;
            double pti_re;
            int i;
            double ri;
            double arcPt_ho;
            double arcPt_re;
            double pt2_ho;
            double pt2_re;
            String c1 = value.getattrvalue("C1");
            String c2 = value.getattrvalue("C2");
            String c3 = value.getattrvalue("C3");
            String a1 = value.getattrvalue("A1");
            String a2 = value.getattrvalue("A2");
            try {
                pt2_re = Double.parseDouble(c1);
            }
            catch (Exception ex) {
                throw new Iox2jtsException("failed to read C1 <" + c1 + ">", ex);
            }
            try {
                pt2_ho = Double.parseDouble(c2);
            }
            catch (Exception ex) {
                throw new Iox2jtsException("failed to read C2 <" + c2 + ">", ex);
            }
            try {
                arcPt_re = Double.parseDouble(a1);
            }
            catch (Exception ex) {
                throw new Iox2jtsException("failed to read A1 <" + a1 + ">", ex);
            }
            try {
                arcPt_ho = Double.parseDouble(a2);
            }
            catch (Exception ex) {
                throw new Iox2jtsException("failed to read A2 <" + a2 + ">", ex);
            }
            if (p == 0.0) {
                ret.add((Object)new Coordinate(arcPt_re, arcPt_ho));
                ret.add((Object)new Coordinate(pt2_re, pt2_ho));
                return;
            }
            int lastCoord = ret.size();
            Coordinate p1 = null;
            p1 = ret.getCoordinate(lastCoord - 1);
            double pt1_re = p1.x;
            double pt1_ho = p1.y;
            double a = Iox2jts.dist(pt1_re, pt1_ho, arcPt_re, arcPt_ho);
            double b = Iox2jts.dist(arcPt_re, arcPt_ho, pt2_re, pt2_ho);
            double c = Iox2jts.dist(pt1_re, pt1_ho, pt2_re, pt2_ho);
            double s = (a + b + c) / 2.0;
            double ds = Math.atan2(pt2_re - arcPt_re, pt2_ho - arcPt_ho) - Math.atan2(pt1_re - arcPt_re, pt1_ho - arcPt_ho);
            double rSign = Math.sin(ds) > 0.0 ? -1.0 : 1.0;
            double r = a * b * c / 4.0 / Math.sqrt(s * (s - a) * (s - b) * (s - c)) * rSign;
            double thetaM = Math.atan2(arcPt_re - pt1_re, arcPt_ho - pt1_ho) + Math.acos(a / 2.0 / r);
            double reM = pt1_re + r * Math.sin(thetaM);
            double hoM = pt1_ho + r * Math.cos(thetaM);
            double theta = 2.0 * Math.acos(1.0 - p / Math.abs(r));
            if (a > 2.0 * p) {
                double alpha = 2.0 * Math.asin(a / 2.0 / Math.abs(r));
                int alphan = (int)Math.ceil(alpha / theta);
                double alphai = alpha / (double)(alphan * (r > 0.0 ? 1 : -1));
                ri = Math.atan2(pt1_re - reM, pt1_ho - hoM);
                i = 1;
                while (i < alphan) {
                    pti_re = reM + Math.abs(r) * Math.sin(ri += alphai);
                    pti_ho = hoM + Math.abs(r) * Math.cos(ri);
                    ret.add((Object)new Coordinate(pti_re, pti_ho));
                    ++i;
                }
            }
            ret.add((Object)new Coordinate(arcPt_re, arcPt_ho));
            if (b > 2.0 * p) {
                double beta = 2.0 * Math.asin(b / 2.0 / Math.abs(r));
                int betan = (int)Math.ceil(beta / theta);
                double betai = beta / (double)(betan * (r > 0.0 ? 1 : -1));
                ri = Math.atan2(arcPt_re - reM, arcPt_ho - hoM);
                i = 1;
                while (i < betan) {
                    pti_re = reM + Math.abs(r) * Math.sin(ri += betai);
                    pti_ho = hoM + Math.abs(r) * Math.cos(ri);
                    ret.add((Object)new Coordinate(pti_re, pti_ho));
                    ++i;
                }
            }
            ret.add((Object)new Coordinate(pt2_re, pt2_ho));
        }
    }

    public static CoordinateList polyline2JTS(IomObject polylineObj, boolean isSurfaceOrArea, double p) throws Iox2jtsException {
        boolean clipped;
        IomObject lineattr;
        if (polylineObj == null) {
            return null;
        }
        CoordinateList ret = new CoordinateList();
        if (isSurfaceOrArea && (lineattr = polylineObj.getattrobj("lineattr", 0)) != null) {
            throw new Iox2jtsException("Lineattributes not supported");
        }
        boolean bl = clipped = polylineObj.getobjectconsistency() == 1;
        if (clipped) {
            throw new Iox2jtsException("clipped polyline not supported");
        }
        int sequencei = 0;
        while (sequencei < polylineObj.getattrvaluecount("sequence")) {
            if (!clipped && sequencei > 0) {
                throw new Iox2jtsException("unclipped polyline with multi 'sequence' elements");
            }
            IomObject sequence = polylineObj.getattrobj("sequence", sequencei);
            int segmenti = 0;
            while (segmenti < sequence.getattrvaluecount("segment")) {
                IomObject segment = sequence.getattrobj("segment", segmenti);
                if (segment.getobjecttag().equals("COORD")) {
                    ret.add((Object)Iox2jts.coord2JTS(segment));
                } else if (segment.getobjecttag().equals("ARC")) {
                    Iox2jts.arc2JTS(ret, segment, p);
                } else {
                    throw new Iox2jtsException("custom line form not supported");
                }
                ++segmenti;
            }
            ++sequencei;
        }
        return ret;
    }

    public static Polygon surface2JTS(IomObject obj, double strokeP) throws Iox2jtsException {
        boolean clipped;
        if (obj == null) {
            return null;
        }
        Polygon ret = null;
        boolean bl = clipped = obj.getobjectconsistency() == 1;
        if (clipped) {
            throw new Iox2jtsException("clipped surface not supported");
        }
        int surfacei = 0;
        while (surfacei < obj.getattrvaluecount("surface")) {
            if (!clipped && surfacei > 0) {
                throw new Iox2jtsException("unclipped surface with multi 'surface' elements");
            }
            IomObject surface = obj.getattrobj("surface", surfacei);
            LinearRing shell = null;
            LinearRing[] holes = null;
            int boundaryc = surface.getattrvaluecount("boundary");
            if (boundaryc > 1) {
                holes = new LinearRing[boundaryc - 1];
            }
            int boundaryi = 0;
            while (boundaryi < boundaryc) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                CoordinateList jtsLine = new CoordinateList();
                int polylinei = 0;
                while (polylinei < boundary.getattrvaluecount("polyline")) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    jtsLine.addAll((Collection)Iox2jts.polyline2JTS(polyline, true, strokeP));
                    ++polylinei;
                }
                jtsLine.closeRing();
                if (boundaryi == 0) {
                    shell = new GeometryFactory().createLinearRing(jtsLine.toCoordinateArray());
                } else {
                    holes[boundaryi - 1] = new GeometryFactory().createLinearRing(jtsLine.toCoordinateArray());
                }
                ++boundaryi;
            }
            ret = new GeometryFactory().createPolygon(shell, holes);
            ++surfacei;
        }
        return ret;
    }
}

