/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.control.Main;
import com.baselet.diagram.DiagramHandler;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.Command;
import com.baselet.gui.pane.OwnSyntaxPane;

public class ChangePanelAttributes
extends Command {
    private GridElement _entity;
    private String _newState;
    private String _oldState;
    private int _oldCaret;
    private int _newCaret;

    public GridElement getEntity() {
        return this._entity;
    }

    public String getNewState() {
        return this._newState;
    }

    public String getOldState() {
        return this._oldState;
    }

    public int getOldCaret() {
        return this._oldCaret;
    }

    public int getNewCaret() {
        return this._newCaret;
    }

    public ChangePanelAttributes(GridElement e, String oldState, String newState, int oldCaret, int newCaret) {
        this._entity = e;
        this._newState = newState;
        this._oldState = oldState;
        this._newCaret = newCaret;
        this._oldCaret = oldCaret;
    }

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        this._entity.setPanelAttributes(this._newState);
        this._entity.repaint();
        GridElement gridElement = Main.getInstance().getEditedGridElement();
        if (gridElement != null && gridElement.equals(this._entity)) {
            OwnSyntaxPane pane = CurrentGui.getInstance().getGui().getPropertyPane();
            pane.switchToElement(gridElement);
            if (pane.getText().length() >= this._newCaret) {
                pane.getTextComponent().setCaretPosition(this._newCaret);
            }
        }
    }

    @Override
    public void undo(DiagramHandler handler) {
        this._entity.setPanelAttributes(this._oldState);
        this._entity.repaint();
        GridElement gridElement = Main.getInstance().getEditedGridElement();
        if (gridElement != null && gridElement.equals(this._entity)) {
            OwnSyntaxPane pane = CurrentGui.getInstance().getGui().getPropertyPane();
            pane.switchToElement(gridElement);
            if (pane.getText().length() >= this._oldCaret) {
                pane.getTextComponent().setCaretPosition(this._oldCaret);
            }
        }
    }

    @Override
    public boolean isMergeableTo(Command c) {
        return false;
    }

    @Override
    public Command mergeTo(Command c) {
        ChangePanelAttributes tmp = (ChangePanelAttributes)c;
        ChangePanelAttributes ret = new ChangePanelAttributes(this.getEntity(), tmp.getOldState(), this.getNewState(), tmp.getOldCaret(), this.getNewCaret());
        return ret;
    }

    public String toString() {
        return "Changestate from " + this.getOldState() + " to " + this.getNewState();
    }
}

