/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.httpclient;

import ch.csnc.extension.httpclient.AliasCertificate;
import ch.csnc.extension.httpclient.AliasKeyManager;
import ch.csnc.extension.httpclient.PKCS11Configuration;
import ch.csnc.extension.util.Encoding;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class SSLContextManager {
    public static final String SUN_PKCS11_CANONICAL_CLASS_NAME = "sun.security.pkcs11.SunPKCS11";
    public static final String IBM_PKCS11_CONONICAL_CLASS_NAME = "com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl";
    public static final String PKCS11_PROVIDER_TYPE = "PKCS11";
    private static final String SUN_PKCS11_KEYSTORE_TYPE = "PKCS11";
    private static final String IBM_PKCS11_KEYSTORE_TYPE = "PKCS11IMPLKS";
    private Map<String, SSLContext> _contextMaps = new TreeMap<String, SSLContext>();
    private SSLContext _noClientCertContext;
    private String _defaultKey = null;
    private Map<String, Map<?, ?>> _aliasPasswords = new HashMap();
    private List<KeyStore> _keyStores = new ArrayList<KeyStore>();
    private Map<KeyStore, String> _keyStoreDescriptions = new HashMap<KeyStore, String>();
    private Map<KeyStore, String> _keyStorePasswords = new HashMap<KeyStore, String>();
    private static Logger log = Logger.getLogger(SSLContextManager.class);
    private static TrustManager[] _trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }};
    private int _defaultKeystoreIndex = -1;
    private int _defaultAliasIndex = -1;

    public SSLContextManager() {
        try {
            this._noClientCertContext = SSLContext.getInstance("SSL");
            this._noClientCertContext.init(null, _trustAllCerts, new SecureRandom());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error((Object)("Could not get an instance of the SSL algorithm: " + noSuchAlgorithmException.getMessage()), (Throwable)noSuchAlgorithmException);
        }
        catch (KeyManagementException keyManagementException) {
            log.error((Object)("Error initialising the SSL Context:  " + keyManagementException.getMessage()), (Throwable)keyManagementException);
        }
        try {
            this.initMSCAPI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isProviderAvailable(String string) {
        try {
            if (string.equals("PKCS11")) {
                try {
                    Class.forName(SUN_PKCS11_CANONICAL_CLASS_NAME);
                    return true;
                }
                catch (Throwable throwable) {
                    Class.forName(IBM_PKCS11_CONONICAL_CLASS_NAME);
                    return true;
                }
            }
            if (string.equals("msks")) {
                Class.forName("se.assembla.jce.provider.ms.MSProvider");
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private int addKeyStore(KeyStore keyStore, String string, String string2) {
        int n = this._keyStores.indexOf(keyStore);
        if (n == -1) {
            this._keyStores.add(keyStore);
            n = this._keyStores.size() - 1;
        }
        this._keyStoreDescriptions.put(keyStore, string);
        this._keyStorePasswords.put(keyStore, string2);
        return n;
    }

    public boolean removeKeyStore(int n) {
        boolean bl = n == this._defaultKeystoreIndex;
        KeyStore keyStore = this._keyStores.get(n);
        this._keyStores.remove(keyStore);
        this._keyStoreDescriptions.remove(keyStore);
        this._keyStorePasswords.remove(keyStore);
        if (bl) {
            this._defaultKeystoreIndex = -1;
            this._defaultAliasIndex = -1;
        }
        return bl;
    }

    public int getKeyStoreCount() {
        return this._keyStores.size();
    }

    public String getKeyStoreDescription(int n) {
        return this._keyStoreDescriptions.get(this._keyStores.get(n));
    }

    public String getKeyStorePassword(int n) {
        return this._keyStorePasswords.get(this._keyStores.get(n));
    }

    public int getAliasCount(int n) {
        return this.getAliases(this._keyStores.get(n)).size();
    }

    public String getAliasAt(int n, int n2) {
        return this.getAliases(this._keyStores.get(n)).get(n2).getAlias();
    }

    private List<AliasCertificate> getAliases(KeyStore keyStore) {
        ArrayList<AliasCertificate> arrayList = new ArrayList<AliasCertificate>();
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            boolean bl = SSLContextManager.isIbmPKCS11Provider();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string) && (!bl || !keyStore.isCertificateEntry(string))) continue;
                Certificate certificate = keyStore.getCertificate(string);
                AliasCertificate aliasCertificate = new AliasCertificate(certificate, string);
                arrayList.add(aliasCertificate);
            }
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        return arrayList;
    }

    public List<AliasCertificate> getAliases(int n) {
        return this.getAliases(this._keyStores.get(n));
    }

    public Certificate getCertificate(int n, int n2) {
        try {
            KeyStore keyStore = this._keyStores.get(n);
            String string = this.getAliasAt(n, n2);
            return keyStore.getCertificate(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFingerPrint(Certificate certificate) throws KeyStoreException {
        String string;
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        X509Certificate x509Certificate = (X509Certificate)certificate;
        try {
            string = Encoding.hashMD5(certificate.getEncoded());
            for (int i = 0; i < string.length(); i += 2) {
                stringBuffer.append(string.substring(i, i + 1)).append(":");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyStoreException(certificateEncodingException.getMessage());
        }
        string = x509Certificate.getSubjectDN().getName();
        log.info((Object)("Fingerprint is " + stringBuffer.toString().toUpperCase()));
        return stringBuffer.toString().toUpperCase() + " " + string;
    }

    public boolean isKeyUnlocked(int n, int n2) {
        KeyStore keyStore = this._keyStores.get(n);
        String string = this.getAliasAt(n, n2);
        Map<?, ?> map = this._aliasPasswords.get(keyStore);
        if (map == null) {
            return false;
        }
        return map.containsKey(string);
    }

    public void setDefaultKey(int n, int n2) throws KeyStoreException {
        this._defaultKeystoreIndex = n;
        this._defaultAliasIndex = n2;
        this._defaultKey = this._defaultKeystoreIndex == -1 || this._defaultAliasIndex == -1 ? "" : this.getFingerPrint(this.getCertificate(n, n2));
    }

    public String getDefaultKey() {
        return this._defaultKey;
    }

    public Certificate getDefaultCertificate() {
        return this.getCertificate(this._defaultKeystoreIndex, this._defaultAliasIndex);
    }

    public int initMSCAPI() throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        try {
            if (!this.isProviderAvailable("msks")) {
                return -1;
            }
            Provider provider = (Provider)Class.forName("se.assembla.jce.provider.ms.MSProvider").newInstance();
            Security.addProvider(provider);
            KeyStore keyStore = KeyStore.getInstance("msks", "assembla");
            keyStore.load(null, null);
            return this.addKeyStore(keyStore, "Microsoft CAPI Store", null);
        }
        catch (Exception exception) {
            log.error((Object)("Error instantiating the MSCAPI provider: " + exception.getMessage()), (Throwable)exception);
            return -1;
        }
    }

    public int initPKCS11(PKCS11Configuration pKCS11Configuration, String string) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!this.isProviderAvailable("PKCS11")) {
            return -1;
        }
        Provider provider = SSLContextManager.createPKCS11Provider(pKCS11Configuration);
        Security.addProvider(provider);
        KeyStore keyStore = SSLContextManager.getPKCS11KeyStore(provider.getName());
        keyStore.load(null, string == null ? null : string.toCharArray());
        return this.addKeyStore(keyStore, "PKCS#11: " + pKCS11Configuration.getName(), "");
    }

    private static Provider createPKCS11Provider(PKCS11Configuration pKCS11Configuration) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Provider provider = null;
        if (SSLContextManager.isSunPKCS11Provider()) {
            provider = SSLContextManager.createInstance(SUN_PKCS11_CANONICAL_CLASS_NAME, InputStream.class, pKCS11Configuration.toInpuStream());
        } else if (SSLContextManager.isIbmPKCS11Provider()) {
            provider = SSLContextManager.createInstance(IBM_PKCS11_CONONICAL_CLASS_NAME, BufferedReader.class, new BufferedReader(new InputStreamReader(pKCS11Configuration.toInpuStream())));
        }
        return provider;
    }

    private static Provider createInstance(String string, Class<?> clazz, Object object) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz2 = Class.forName(string);
        Constructor<?> constructor = clazz2.getConstructor(clazz);
        return (Provider)constructor.newInstance(object);
    }

    private static boolean isSunPKCS11Provider() {
        try {
            Class.forName(SUN_PKCS11_CANONICAL_CLASS_NAME);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isIbmPKCS11Provider() {
        try {
            Class.forName(IBM_PKCS11_CONONICAL_CLASS_NAME);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static KeyStore getPKCS11KeyStore(String string) throws KeyStoreException {
        String string2 = "PKCS11";
        if (SSLContextManager.isIbmPKCS11Provider()) {
            string2 = IBM_PKCS11_KEYSTORE_TYPE;
        }
        return KeyStore.getInstance(string2, Security.getProvider(string));
    }

    public int loadPKCS12Certificate(String string, String string2) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException(string + " could not be found");
        }
        String string3 = file.getName();
        FileInputStream fileInputStream = new FileInputStream(file);
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(fileInputStream, string2 == null ? null : string2.toCharArray());
        return this.addKeyStore(keyStore, "PKCS#12: " + string3, string2);
    }

    public boolean unlockKeyWithDefaultPassword(int n, int n2) throws KeyManagementException, KeyStoreException {
        return this.unlockKey(n, n2, this.getKeyStorePassword(n));
    }

    public boolean unlockKey(int n, int n2, String string) throws KeyStoreException, KeyManagementException {
        SSLContext sSLContext;
        KeyStore keyStore = this._keyStores.get(n);
        String string2 = this.getAliasAt(n, n2);
        AliasKeyManager aliasKeyManager = new AliasKeyManager(keyStore, string2, string);
        try {
            aliasKeyManager.getPrivateKey(string2).toString();
        }
        catch (NullPointerException nullPointerException) {
            log.error((Object)("Could not get private key: " + nullPointerException.getMessage()), (Throwable)nullPointerException);
            return false;
        }
        String string3 = this.getFingerPrint(this.getCertificate(n, n2));
        if (string3 == null) {
            log.info((Object)"No fingerprint found");
            return false;
        }
        try {
            sSLContext = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error((Object)("Could not get an instance of the SSL algorithm: " + noSuchAlgorithmException.getMessage()), (Throwable)noSuchAlgorithmException);
            return false;
        }
        sSLContext.init(new KeyManager[]{aliasKeyManager}, _trustAllCerts, new SecureRandom());
        String string4 = string3;
        if (string4.indexOf(" ") > 0) {
            string4 = string4.substring(0, string4.indexOf(" "));
        }
        this._contextMaps.put(string4, sSLContext);
        log.info((Object)"Key has been unlocked.");
        return true;
    }

    public void invalidateSessions() {
        this.invalidateSession(this._noClientCertContext);
        Iterator<String> iterator = this._contextMaps.keySet().iterator();
        while (iterator.hasNext()) {
            this.invalidateSession(this._contextMaps.get(iterator.next()));
        }
    }

    private void invalidateSession(SSLContext sSLContext) {
        int n;
        SSLSessionContext sSLSessionContext = sSLContext.getClientSessionContext();
        if (sSLSessionContext != null) {
            n = sSLSessionContext.getSessionTimeout();
            sSLSessionContext.setSessionTimeout(1);
            sSLSessionContext.setSessionTimeout(n);
        }
        if ((sSLSessionContext = sSLContext.getServerSessionContext()) != null) {
            n = sSLSessionContext.getSessionTimeout();
            sSLSessionContext.setSessionTimeout(1);
            sSLSessionContext.setSessionTimeout(n);
        }
    }

    public SSLContext getSSLContext(String string) {
        log.info((Object)("Requested SSLContext for " + string));
        if (string == null || string.equals("none")) {
            return this._noClientCertContext;
        }
        if (string.indexOf(" ") > 0) {
            string = string.substring(0, string.indexOf(" "));
        }
        return this._contextMaps.get(string);
    }
}

