/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.DatabaseUnsupportedException;

public abstract class AbstractDatabase
implements Database {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final List<DatabaseListener> databaseListeners = new ArrayList<DatabaseListener>();

    protected List<DatabaseListener> getDatabaseListeners() {
        return this.databaseListeners;
    }

    @Override
    public void addDatabaseListener(DatabaseListener databaseListener) {
        this.databaseListeners.add(databaseListener);
    }

    @Override
    public void removeDatabaseListener(DatabaseListener databaseListener) {
        this.databaseListeners.remove(databaseListener);
    }

    @Override
    public void close(boolean bl) {
        this.close(bl, true);
    }

    @Override
    public void close(boolean bl, boolean bl2) {
        this.removeDatabaseListeners();
    }

    protected void removeDatabaseListeners() {
        this.databaseListeners.clear();
    }

    protected void notifyListenersDatabaseOpen(Collection<DatabaseListener> collection, DatabaseServer databaseServer) throws DatabaseException {
        for (DatabaseListener databaseListener : collection) {
            try {
                databaseListener.databaseOpen(databaseServer);
            }
            catch (DatabaseUnsupportedException databaseUnsupportedException) {
                this.logger.error((Object)databaseUnsupportedException.getMessage(), (Throwable)databaseUnsupportedException);
            }
        }
    }

    protected void notifyListenersDatabaseOpen(DatabaseServer databaseServer) throws DatabaseException {
        this.notifyListenersDatabaseOpen(this.databaseListeners, databaseServer);
    }
}

