/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.UsernamePasswordAuthenticationCredentials;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.ZapPortNumberSpinner;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class HttpAuthenticationMethodType
extends AuthenticationMethodType {
    public static final String CONTEXT_CONFIG_AUTH_HTTP = "context.authentication.http";
    public static final String CONTEXT_CONFIG_AUTH_HTTP_HOSTNAME = "context.authentication.http.hostname";
    public static final String CONTEXT_CONFIG_AUTH_HTTP_REALM = "context.authentication.http.realm";
    public static final String CONTEXT_CONFIG_AUTH_HTTP_PORT = "context.authentication.http.port";
    private static final Logger log = Logger.getLogger(HttpAuthenticationMethodType.class);
    private static final int METHOD_IDENTIFIER = 3;
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.http.name");
    private static final String API_METHOD_NAME = "httpAuthentication";
    private static final String PARAM_HOSTNAME = "hostname";
    private static final String PARAM_REALM = "realm";
    private static final String PARAM_PORT = "port";

    @Override
    public HttpAuthenticationMethod createAuthenticationMethod(int n) {
        return new HttpAuthenticationMethod();
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public int getUniqueIdentifier() {
        return 3;
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context context) {
        return new HttpAuthenticationMethodOptionsPanel();
    }

    @Override
    public boolean hasOptionsPanel() {
        return true;
    }

    @Override
    public AbstractCredentialsOptionsPanel<? extends AuthenticationCredentials> buildCredentialsOptionsPanel(AuthenticationCredentials authenticationCredentials, Context context) {
        return new UsernamePasswordAuthenticationCredentials.UsernamePasswordAuthenticationCredentialsOptionsPanel((UsernamePasswordAuthenticationCredentials)authenticationCredentials);
    }

    @Override
    public boolean hasCredentialsOptionsPanel() {
        return true;
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod authenticationMethod) {
        return authenticationMethod instanceof HttpAuthenticationMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
    }

    @Override
    public AuthenticationMethod loadMethodFromSession(Session session, int n) throws DatabaseException {
        List<String> list;
        List<String> list2;
        HttpAuthenticationMethod httpAuthenticationMethod = this.createAuthenticationMethod(n);
        List<String> list3 = session.getContextDataStrings(n, 201);
        if (list3 != null && list3.size() > 0) {
            httpAuthenticationMethod.hostname = list3.get(0);
        }
        if ((list2 = session.getContextDataStrings(n, 202)) != null && list2.size() > 0) {
            httpAuthenticationMethod.realm = list2.get(0);
        }
        if ((list = session.getContextDataStrings(n, 203)) != null && list.size() > 0) {
            try {
                httpAuthenticationMethod.port = Integer.parseInt(list.get(0));
            }
            catch (Exception exception) {
                log.error((Object)"Unable to load HttpAuthenticationMethod. ", (Throwable)exception);
            }
        }
        return httpAuthenticationMethod;
    }

    @Override
    public void persistMethodToSession(Session session, int n, AuthenticationMethod authenticationMethod) throws AuthenticationMethodType.UnsupportedAuthenticationMethodException, DatabaseException {
        if (!(authenticationMethod instanceof HttpAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Http Authentication type only supports: " + HttpAuthenticationMethod.class);
        }
        HttpAuthenticationMethod httpAuthenticationMethod = (HttpAuthenticationMethod)authenticationMethod;
        session.setContextData(n, 201, httpAuthenticationMethod.hostname);
        session.setContextData(n, 202, httpAuthenticationMethod.realm);
        session.setContextData(n, 203, Integer.toString(httpAuthenticationMethod.port));
    }

    @Override
    public AuthenticationCredentials createAuthenticationCredentials() {
        return new UsernamePasswordAuthenticationCredentials();
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, new String[]{PARAM_HOSTNAME, PARAM_REALM}, new String[]{PARAM_PORT}){

            @Override
            public void handleAction(JSONObject jSONObject) throws ApiException {
                Context context = ApiUtils.getContextByParamId(jSONObject, "contextId");
                HttpAuthenticationMethod httpAuthenticationMethod = HttpAuthenticationMethodType.this.createAuthenticationMethod(context.getIndex());
                httpAuthenticationMethod.hostname = ApiUtils.getNonEmptyStringParam(jSONObject, HttpAuthenticationMethodType.PARAM_HOSTNAME);
                try {
                    new URI(httpAuthenticationMethod.hostname);
                }
                catch (Exception exception) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, HttpAuthenticationMethodType.PARAM_HOSTNAME);
                }
                if (jSONObject.containsKey((Object)HttpAuthenticationMethodType.PARAM_REALM)) {
                    httpAuthenticationMethod.realm = jSONObject.getString(HttpAuthenticationMethodType.PARAM_REALM);
                }
                if (jSONObject.containsKey((Object)HttpAuthenticationMethodType.PARAM_PORT)) {
                    try {
                        String string = jSONObject.getString(HttpAuthenticationMethodType.PARAM_PORT);
                        httpAuthenticationMethod.port = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, HttpAuthenticationMethodType.PARAM_PORT);
                    }
                }
                if (!context.getAuthenticationMethod().isSameType(httpAuthenticationMethod)) {
                    AuthenticationMethodType.apiChangedAuthenticationMethodForContext(context.getIndex());
                }
                context.setAuthenticationMethod(httpAuthenticationMethod);
            }
        };
    }

    @Override
    public ApiDynamicActionImplementor getSetCredentialsForUserApiAction() {
        return UsernamePasswordAuthenticationCredentials.getSetCredentialsForUserApiAction(this);
    }

    @Override
    public void exportData(Configuration configuration, AuthenticationMethod authenticationMethod) {
        if (!(authenticationMethod instanceof HttpAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("HTTP based authentication type only supports: " + HttpAuthenticationMethod.class.getName());
        }
        HttpAuthenticationMethod httpAuthenticationMethod = (HttpAuthenticationMethod)authenticationMethod;
        configuration.setProperty(CONTEXT_CONFIG_AUTH_HTTP_HOSTNAME, (Object)httpAuthenticationMethod.hostname);
        configuration.setProperty(CONTEXT_CONFIG_AUTH_HTTP_REALM, (Object)httpAuthenticationMethod.realm);
        configuration.setProperty(CONTEXT_CONFIG_AUTH_HTTP_PORT, (Object)httpAuthenticationMethod.port);
    }

    @Override
    public void importData(Configuration configuration, AuthenticationMethod authenticationMethod) throws ConfigurationException {
        if (!(authenticationMethod instanceof HttpAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("HTTP based authentication type only supports: " + HttpAuthenticationMethod.class.getName());
        }
        HttpAuthenticationMethod httpAuthenticationMethod = (HttpAuthenticationMethod)authenticationMethod;
        httpAuthenticationMethod.hostname = configuration.getString(CONTEXT_CONFIG_AUTH_HTTP_HOSTNAME);
        httpAuthenticationMethod.realm = configuration.getString(CONTEXT_CONFIG_AUTH_HTTP_REALM);
        httpAuthenticationMethod.port = configuration.getInt(CONTEXT_CONFIG_AUTH_HTTP_PORT);
    }

    private static class HttpAuthenticationMethodOptionsPanel
    extends AbstractAuthenticationMethodOptionsPanel {
        private static final long serialVersionUID = 4341092284683481288L;
        private static final String HOSTNAME_LABEL = Constant.messages.getString("authentication.method.http.field.label.hostname");
        private static final String PORT_LABEL = Constant.messages.getString("authentication.method.http.field.label.port");
        private static final String REALM_LABEL = Constant.messages.getString("authentication.method.http.field.label.realm");
        private ZapTextField hostnameField;
        private ZapTextField realmField;
        private ZapPortNumberSpinner portNumberSpinner;
        private HttpAuthenticationMethod method;

        public HttpAuthenticationMethodOptionsPanel() {
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(HOSTNAME_LABEL), LayoutHelper.getGBC(0, 0, 1, 0.0));
            this.hostnameField = new ZapTextField();
            this.add((Component)this.hostnameField, LayoutHelper.getGBC(1, 0, 1, 1.0, new Insets(0, 0, 0, 10)));
            this.add((Component)new JLabel(PORT_LABEL), LayoutHelper.getGBC(2, 0, 1, 0.0));
            this.portNumberSpinner = new ZapPortNumberSpinner(80);
            this.add((Component)this.portNumberSpinner, LayoutHelper.getGBC(3, 0, 1, 0.0));
            this.add((Component)new JLabel(REALM_LABEL), LayoutHelper.getGBC(0, 1, 1, 0.0));
            this.realmField = new ZapTextField();
            this.add((Component)this.realmField, LayoutHelper.getGBC(1, 1, 1, 1.0, new Insets(0, 0, 0, 10)));
        }

        @Override
        public void validateFields() throws IllegalStateException {
            try {
                new URI(this.hostnameField.getText());
            }
            catch (Exception exception) {
                this.hostnameField.requestFocusInWindow();
                throw new IllegalStateException(Constant.messages.getString("authentication.method.http.dialog.error.url.text"));
            }
        }

        @Override
        public void saveMethod() {
            this.getMethod().hostname = this.hostnameField.getText();
            this.getMethod().port = this.portNumberSpinner.getValue();
            this.getMethod().realm = this.realmField.getText();
        }

        @Override
        public void bindMethod(AuthenticationMethod authenticationMethod) throws AuthenticationMethodType.UnsupportedAuthenticationMethodException {
            this.method = (HttpAuthenticationMethod)authenticationMethod;
            this.hostnameField.setText(this.method.hostname);
            this.portNumberSpinner.setValue(this.method.port);
            this.realmField.setText(this.method.realm);
        }

        @Override
        public HttpAuthenticationMethod getMethod() {
            return this.method;
        }
    }

    protected static class HttpAuthenticationMethod
    extends AuthenticationMethod {
        protected String hostname;
        protected int port = 80;
        protected String realm;

        @Override
        public boolean isConfigured() {
            return this.hostname != null && !this.hostname.isEmpty() && this.realm != null && !this.realm.isEmpty();
        }

        @Override
        protected AuthenticationMethod duplicate() {
            HttpAuthenticationMethod httpAuthenticationMethod = new HttpAuthenticationMethod();
            httpAuthenticationMethod.hostname = this.hostname;
            httpAuthenticationMethod.port = this.port;
            httpAuthenticationMethod.realm = this.realm;
            return httpAuthenticationMethod;
        }

        @Override
        public AuthenticationCredentials createAuthenticationCredentials() {
            return new UsernamePasswordAuthenticationCredentials();
        }

        @Override
        public AuthenticationMethodType getType() {
            return new HttpAuthenticationMethodType();
        }

        @Override
        public WebSession authenticate(SessionManagementMethod sessionManagementMethod, AuthenticationCredentials authenticationCredentials, User user) throws AuthenticationMethod.UnsupportedAuthenticationCredentialsException {
            WebSession webSession = user.getAuthenticatedSession();
            if (webSession == null) {
                webSession = sessionManagementMethod.createEmptyWebSession();
            }
            if (!(authenticationCredentials instanceof UsernamePasswordAuthenticationCredentials)) {
                throw new AuthenticationMethod.UnsupportedAuthenticationCredentialsException("Form based authentication method only supports " + UsernamePasswordAuthenticationCredentials.class.getSimpleName());
            }
            UsernamePasswordAuthenticationCredentials usernamePasswordAuthenticationCredentials = (UsernamePasswordAuthenticationCredentials)authenticationCredentials;
            AuthScope authScope = null;
            NTCredentials nTCredentials = null;
            try {
                authScope = new AuthScope(this.hostname, this.port, this.realm == null || this.realm.isEmpty() ? AuthScope.ANY_REALM : this.realm);
                nTCredentials = new NTCredentials(usernamePasswordAuthenticationCredentials.getUsername(), usernamePasswordAuthenticationCredentials.getPassword(), InetAddress.getLocalHost().getCanonicalHostName(), this.hostname);
                webSession.getHttpState().setCredentials(authScope, (Credentials)nTCredentials);
            }
            catch (UnknownHostException unknownHostException) {
                log.error((Object)unknownHostException.getMessage(), (Throwable)unknownHostException);
            }
            return webSession;
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("methodName", HttpAuthenticationMethodType.API_METHOD_NAME);
            hashMap.put("host", this.hostname);
            hashMap.put(HttpAuthenticationMethodType.PARAM_PORT, Integer.toString(this.port));
            hashMap.put(HttpAuthenticationMethodType.PARAM_REALM, this.realm);
            return new ApiResponseSet("method", hashMap);
        }
    }
}

