/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.OptionsParamApi;

public class WebUI {
    private API api;

    public WebUI(API aPI) {
        this.api = aPI;
    }

    private ApiElement getElement(ApiImplementor apiImplementor, String string, API.RequestType requestType) throws ApiException {
        if (API.RequestType.action.equals((Object)requestType) && string != null) {
            List<ApiAction> list = apiImplementor.getApiActions();
            ApiAction apiAction = null;
            for (ApiAction apiAction2 : list) {
                if (!string.equals(apiAction2.getName())) continue;
                apiAction = apiAction2;
                break;
            }
            if (apiAction == null) {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
            return apiAction;
        }
        if (API.RequestType.other.equals((Object)requestType) && string != null) {
            List<ApiOther> list = apiImplementor.getApiOthers();
            ApiOther apiOther = null;
            for (ApiOther apiOther2 : list) {
                if (!string.equals(apiOther2.getName())) continue;
                apiOther = apiOther2;
                break;
            }
            if (apiOther == null) {
                throw new ApiException(ApiException.Type.BAD_OTHER);
            }
            return apiOther;
        }
        if (API.RequestType.view.equals((Object)requestType) && string != null) {
            List<ApiView> list = apiImplementor.getApiViews();
            ApiView apiView = null;
            for (ApiView apiView2 : list) {
                if (!string.equals(apiView2.getName())) continue;
                apiView = apiView2;
                break;
            }
            if (apiView == null) {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
            return apiView;
        }
        throw new ApiException(ApiException.Type.BAD_TYPE);
    }

    private void appendElements(StringBuilder stringBuilder, String string, String string2, List<ApiElement> list) {
        Collections.sort(list, new Comparator<ApiElement>(){

            @Override
            public int compare(ApiElement apiElement, ApiElement apiElement2) {
                return apiElement.getName().compareTo(apiElement2.getName());
            }
        });
        stringBuilder.append("<table>\n");
        for (ApiElement apiElement : list) {
            List<String> list2 = apiElement.getMandatoryParamNames();
            List<String> list3 = apiElement.getOptionalParamNames();
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>");
            stringBuilder.append("<a href=\"/");
            stringBuilder.append(API.Format.UI.name());
            stringBuilder.append('/');
            stringBuilder.append(string);
            stringBuilder.append('/');
            stringBuilder.append(string2);
            stringBuilder.append('/');
            stringBuilder.append(apiElement.getName());
            stringBuilder.append("/\">");
            stringBuilder.append(apiElement.getName());
            if (list2 != null || list3 != null) {
                stringBuilder.append(" (");
                if (list2 != null) {
                    for (String string3 : list2) {
                        stringBuilder.append(string3);
                        stringBuilder.append("* ");
                    }
                }
                if (list3 != null) {
                    for (String string3 : list3) {
                        stringBuilder.append(string3);
                        stringBuilder.append(" ");
                    }
                }
                stringBuilder.append(") ");
            }
            stringBuilder.append("</a>");
            stringBuilder.append("</td><td>");
            Object object = apiElement.getDescriptionTag();
            if (object == null) {
                object = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                stringBuilder.append(Constant.messages.getString((String)object));
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuilder.append("</td>");
            stringBuilder.append("</tr>\n");
        }
        stringBuilder.append("</table>\n");
    }

    public String handleRequest(String string, ApiImplementor apiImplementor, API.RequestType requestType, String string2) throws ApiException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<head>\n");
        stringBuilder.append("<title>");
        stringBuilder.append(Constant.messages.getString("api.html.title"));
        stringBuilder.append("</title>\n");
        stringBuilder.append("</head>\n");
        stringBuilder.append("<body>\n");
        if (string != null && requestType != null) {
            stringBuilder.append("<script>\n");
            stringBuilder.append("function submitScript() {\n");
            if (API.RequestType.other.equals((Object)requestType)) {
                stringBuilder.append("var format = '" + API.Format.OTHER.name() + "'\n");
            } else {
                stringBuilder.append("var format = document.getElementById('zapapiformat').value\n");
            }
            stringBuilder.append("var url = '/' + format + '/" + string + "/" + requestType.name() + "/" + string2 + "/'\n");
            stringBuilder.append("var form=document.getElementById('zapform');\n");
            stringBuilder.append("form.action = url;\n");
            stringBuilder.append("form.submit();\n");
            stringBuilder.append("}\n");
            stringBuilder.append("</script>\n");
        }
        stringBuilder.append("<h1>");
        stringBuilder.append("<a href=\"/");
        stringBuilder.append(API.Format.UI.name());
        stringBuilder.append("/\">");
        stringBuilder.append(Constant.messages.getString("api.html.title"));
        stringBuilder.append("</a>");
        stringBuilder.append("</h1>\n");
        if (apiImplementor != null) {
            stringBuilder.append("<h2>");
            stringBuilder.append("<a href=\"/");
            stringBuilder.append(API.Format.UI.name());
            stringBuilder.append("/");
            stringBuilder.append(string);
            stringBuilder.append("/\">");
            stringBuilder.append(Constant.messages.getString("api.html.component"));
            stringBuilder.append(string);
            stringBuilder.append("</a>");
            stringBuilder.append("</h2>\n");
            if (string2 != null) {
                Iterator<String> iterator;
                ApiElement apiElement = this.getElement(apiImplementor, string2, requestType);
                List<String> list = apiElement.getMandatoryParamNames();
                List<String> list2 = apiElement.getOptionalParamNames();
                stringBuilder.append("<h3>");
                stringBuilder.append(Constant.messages.getString("api.html." + requestType.name()));
                stringBuilder.append(apiElement.getName());
                stringBuilder.append("</h3>\n");
                String string3 = apiElement.getDescriptionTag();
                if (string3 == null) {
                    string3 = string + ".api." + requestType.name() + "." + string2;
                }
                try {
                    stringBuilder.append(Constant.messages.getString(string3));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stringBuilder.append("<form id=\"zapform\" name=\"zapform\">");
                stringBuilder.append("<table>\n");
                if (!API.RequestType.other.equals((Object)requestType)) {
                    stringBuilder.append("<tr><td>");
                    stringBuilder.append(Constant.messages.getString("api.html.format"));
                    stringBuilder.append("</td><td>\n");
                    stringBuilder.append("<select id=\"zapapiformat\" name=\"zapapiformat\">\n");
                    stringBuilder.append("<option value=\"JSON\">JSON</option>\n");
                    if (this.getOptionsParamApi().isEnableJSONP()) {
                        stringBuilder.append("<option value=\"JSONP\">JSONP</option>\n");
                    } else {
                        stringBuilder.append("<option value=\"JSONP\" disabled>JSONP</option>\n");
                    }
                    stringBuilder.append("<option value=\"HTML\">HTML</option>\n");
                    stringBuilder.append("<option value=\"XML\">XML</option>\n");
                    stringBuilder.append("</select>\n");
                    stringBuilder.append("</td></tr>\n");
                }
                if ((API.RequestType.action.equals((Object)requestType) || API.RequestType.other.equals((Object)requestType)) && (iterator = this.getOptionsParamApi().getKey()) != null && ((String)((Object)iterator)).length() > 0) {
                    stringBuilder.append("<tr>");
                    stringBuilder.append("<td>");
                    stringBuilder.append(API.API_KEY_PARAM);
                    stringBuilder.append("*</td>");
                    stringBuilder.append("<td>");
                    stringBuilder.append("<input id=\"");
                    stringBuilder.append(API.API_KEY_PARAM);
                    stringBuilder.append("\" name=\"");
                    stringBuilder.append(API.API_KEY_PARAM);
                    stringBuilder.append("\" value=\"");
                    if (this.getOptionsParamApi().isAutofillKey()) {
                        stringBuilder.append((String)((Object)iterator));
                    }
                    stringBuilder.append("\"></input>");
                    stringBuilder.append("</td>");
                    stringBuilder.append("</tr>\n");
                }
                if (list != null) {
                    for (String string4 : list) {
                        stringBuilder.append("<tr>");
                        stringBuilder.append("<td>");
                        stringBuilder.append(string4);
                        stringBuilder.append("*</td>");
                        stringBuilder.append("<td>");
                        stringBuilder.append("<input id=\"");
                        stringBuilder.append(string4);
                        stringBuilder.append("\" name=\"");
                        stringBuilder.append(string4);
                        stringBuilder.append("\"></input>");
                        stringBuilder.append("</td>");
                        stringBuilder.append("</tr>\n");
                    }
                }
                if (list2 != null) {
                    for (String string4 : list2) {
                        stringBuilder.append("<tr>");
                        stringBuilder.append("<td>");
                        stringBuilder.append(string4);
                        stringBuilder.append("</td>");
                        stringBuilder.append("<td>");
                        stringBuilder.append("<input id=\"");
                        stringBuilder.append(string4);
                        stringBuilder.append("\" name=\"");
                        stringBuilder.append(string4);
                        stringBuilder.append("\"></input>");
                        stringBuilder.append("</td>");
                        stringBuilder.append("</tr>\n");
                    }
                }
                stringBuilder.append("<tr>");
                stringBuilder.append("<td>");
                stringBuilder.append("</td>");
                stringBuilder.append("<td>");
                stringBuilder.append("<input id=\"button\" value=\"");
                stringBuilder.append(apiElement.getName());
                stringBuilder.append("\" type=\"button\" onclick=\"submitScript();\">");
                stringBuilder.append("</td>");
                stringBuilder.append("</tr>\n");
                stringBuilder.append("</table>\n");
                stringBuilder.append("</form>\n");
            } else {
                List<ApiOther> list;
                List<ApiAction> list3;
                ArrayList<ApiElement> arrayList = new ArrayList<ApiElement>();
                List<ApiView> list4 = apiImplementor.getApiViews();
                if (list4 != null && list4.size() > 0) {
                    stringBuilder.append("<h3>");
                    stringBuilder.append(Constant.messages.getString("api.html.views"));
                    stringBuilder.append("</h3>\n");
                    arrayList.addAll(list4);
                    this.appendElements(stringBuilder, string, API.RequestType.view.name(), arrayList);
                }
                if ((list3 = apiImplementor.getApiActions()) != null && list3.size() > 0) {
                    stringBuilder.append("<h3>");
                    stringBuilder.append(Constant.messages.getString("api.html.actions"));
                    stringBuilder.append("</h3>\n");
                    arrayList = new ArrayList();
                    arrayList.addAll(list3);
                    this.appendElements(stringBuilder, string, API.RequestType.action.name(), arrayList);
                }
                if ((list = apiImplementor.getApiOthers()) != null && list.size() > 0) {
                    stringBuilder.append("<h3>");
                    stringBuilder.append(Constant.messages.getString("api.html.others"));
                    stringBuilder.append("</h3>\n");
                    arrayList = new ArrayList();
                    arrayList.addAll(list);
                    this.appendElements(stringBuilder, string, API.RequestType.other.name(), arrayList);
                }
            }
        } else {
            stringBuilder.append("<h3>");
            stringBuilder.append(Constant.messages.getString("api.html.components"));
            stringBuilder.append("</h3>\n");
            ArrayList<String> arrayList = new ArrayList<String>(this.api.getImplementors().keySet());
            Collections.sort(arrayList);
            stringBuilder.append("<table>\n");
            for (String string5 : arrayList) {
                stringBuilder.append("<tr>");
                stringBuilder.append("<td>");
                stringBuilder.append("<a href=\"/");
                stringBuilder.append(API.Format.UI.name());
                stringBuilder.append('/');
                stringBuilder.append(string5);
                stringBuilder.append("/\">");
                stringBuilder.append(string5);
                stringBuilder.append("</a>");
                stringBuilder.append("</td>");
                stringBuilder.append("</tr>\n");
            }
            stringBuilder.append("</table>\n");
        }
        stringBuilder.append("</body>\n");
        return stringBuilder.toString();
    }

    public String handleRequest(URI uRI, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<head>\n");
        stringBuilder.append("<title>");
        stringBuilder.append(Constant.messages.getString("api.html.title"));
        stringBuilder.append("</title>\n");
        stringBuilder.append("</head>\n");
        stringBuilder.append("<body>\n");
        stringBuilder.append(Constant.messages.getString("api.home.topmsg"));
        stringBuilder.append(Constant.messages.getString("api.home.proxypac"));
        stringBuilder.append(Constant.messages.getString("api.home.links.header"));
        if (bl) {
            stringBuilder.append(Constant.messages.getString("api.home.links.api.enabled"));
        } else {
            stringBuilder.append(Constant.messages.getString("api.home.links.api.disabled"));
        }
        stringBuilder.append(Constant.messages.getString("api.home.links.online"));
        stringBuilder.append("</body>\n");
        return stringBuilder.toString();
    }

    private OptionsParamApi getOptionsParamApi() {
        return Model.getSingleton().getOptionsParam().getApiParam();
    }
}

