/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.win.WinChildWindow;
import com.sun.glass.ui.win.WinCommonDialogs;
import com.sun.glass.ui.win.WinCursor;
import com.sun.glass.ui.win.WinPixels;
import com.sun.glass.ui.win.WinRobot;
import com.sun.glass.ui.win.WinScreen;
import com.sun.glass.ui.win.WinTimer;
import com.sun.glass.ui.win.WinView;
import com.sun.glass.ui.win.WinWindow;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WinApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    private final InvokeLaterDispatcher invokeLaterDispatcher = new InvokeLaterDispatcher(this);

    private static native void initIDs();

    WinApplication() {
        this.invokeLaterDispatcher.start();
    }

    private native long _init();

    private native void _setClassLoader(ClassLoader var1);

    private native void _runLoop(String[] var1, Launchable var2);

    private native void _terminateLoop();

    @Override
    protected void runLoop(final String[] args, final Launchable launchable) {
        boolean isEventThread = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Boolean result = Boolean.getBoolean("javafx.embed.isEventThread");
                return result == null ? false : result;
            }
        });
        ClassLoader classLoader = WinApplication.class.getClassLoader();
        this._setClassLoader(classLoader);
        if (isEventThread) {
            this._init();
            this.setEventThread(Thread.currentThread());
            launchable.finishLaunching(args);
            return;
        }
        Thread toolkitThread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread th = new Thread(new Runnable(){

                    public void run() {
                        WinApplication.this._init();
                        WinApplication.this._runLoop(args, launchable);
                    }
                }, "WindowsNativeRunloopThread");
                return th;
            }
        });
        this.setEventThread(toolkitThread);
        toolkitThread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread toolkitThread = this.getEventThread();
        if (toolkitThread != null) {
            this._terminateLoop();
            this.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native Object _enterNestedEventLoopImpl();

    private native void _leaveNestedEventLoopImpl(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _enterNestedEventLoop() {
        this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        try {
            Object object = this._enterNestedEventLoopImpl();
            return object;
        }
        finally {
            this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        this._leaveNestedEventLoopImpl(retValue);
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new WinWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        return new WinChildWindow(parent);
    }

    @Override
    public View createView(Pen pen) {
        return new WinView(pen);
    }

    @Override
    public Cursor createCursor(int type) {
        return new WinCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new WinCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
        WinCursor.setVisible_impl(visible);
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return WinCursor.getBestSize_impl(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new WinPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new WinPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data, float scale) {
        return new WinPixels(width, height, data, scale);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return WinPixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        return new WinRobot();
    }

    @Override
    protected Screen staticScreen_getDeepestScreen() {
        return WinScreen.getDeepestScreen_impl();
    }

    @Override
    protected Screen staticScreen_getMainScreen() {
        return WinScreen.getMainScreen_impl();
    }

    @Override
    protected Screen staticScreen_getScreenForLocation(int x, int y) {
        return WinScreen.getScreenForLocation_impl(x, y);
    }

    @Override
    protected Screen staticScreen_getScreenForPtr(long screenPtr) {
        return WinScreen.getScreenForPtr_impl(screenPtr);
    }

    @Override
    protected List<Screen> staticScreen_getScreens() {
        return WinScreen.getScreens_impl();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new WinTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return WinTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return WinTimer.getMaxPeriod_impl();
    }

    @Override
    protected List<File> staticCommonDialogs_showFileChooser(Window owner, String folder, String filename, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters) {
        return WinCommonDialogs.showFileChooser_impl(owner, folder, filename, title, type, multipleMode, extensionFilters);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        return WinCommonDialogs.showFolderChooser_impl(owner, folder, title);
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return WinView.getMultiClickTime_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return WinView.getMultiClickMaxX_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return WinView.getMultiClickMaxY_impl();
    }

    @Override
    protected native void _invokeAndWait(Runnable var1);

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable r) {
        this._submitForLaterInvocation(r);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        this.invokeLaterDispatcher.invokeLater(runnable);
    }

    @Override
    protected native void _postOnEventQueue(Runnable var1);

    @Override
    public boolean supportsTransparentWindows() {
        return true;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Application.loadNativeLibrary();
                return null;
            }
        });
        WinApplication.initIDs();
    }
}

