/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.facet;

import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.Direction;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.relation.helper.LineDescriptionEnum;
import com.baselet.element.relation.helper.RelationPointHandler;

public class LineDescriptionUtils {
    static PointDouble calcPosOfLineDescriptionText(DrawHandler drawer, String text, int lineNr, int totalLines, RelationPointHandler relationPoints, LineDescriptionEnum enumVal) {
        double textWidth = LineDescriptionUtils.calcWidth(drawer, text);
        double totalBlock = (double)totalLines * drawer.textHeightMax();
        double previousLinesBlock = (double)lineNr * drawer.textHeightMax();
        Boolean printOnStart = enumVal.isStart();
        Line line = printOnStart != false ? relationPoints.getFirstLine() : relationPoints.getLastLine();
        PointDouble pointText = line.getPointOnLineWithDistanceFrom(printOnStart, 15.0);
        Direction lineDirection = line.getDirectionOfLine(printOnStart);
        if (lineDirection == Direction.RIGHT) {
            pointText = new PointDouble(pointText.getX() - textWidth - drawer.getDistanceBorderToText(), pointText.getY() + drawer.textHeightMax() + previousLinesBlock + 1.0);
        } else if (lineDirection == Direction.LEFT) {
            pointText = new PointDouble(pointText.getX() + 4.0, pointText.getY() + drawer.textHeightMax() + previousLinesBlock + 1.0);
        } else if (lineDirection == Direction.UP) {
            pointText = new PointDouble(pointText.getX() + 4.0, pointText.getY() + drawer.textHeightMax() + previousLinesBlock + 1.0);
        } else if (lineDirection == Direction.DOWN) {
            pointText = new PointDouble(pointText.getX() + 4.0, pointText.getY() + drawer.textHeightMax() - totalBlock + previousLinesBlock - 1.0);
        }
        if (enumVal.isRoleStartOrEnd()) {
            pointText = lineDirection == Direction.UP ? new PointDouble(pointText.getX(), pointText.getY() + drawer.textHeightMaxWithSpace()) : (lineDirection == Direction.DOWN ? new PointDouble(pointText.getX(), pointText.getY() - drawer.textHeightMaxWithSpace()) : new PointDouble(pointText.getX(), pointText.getY() - (double)totalLines * drawer.textHeightMax() - 5.0));
        }
        return pointText;
    }

    private static double calcWidth(DrawHandler drawer, String ... text) {
        double maxWidth = 0.0;
        String[] stringArray = text;
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            maxWidth = Math.max(maxWidth, drawer.textWidth(line));
            ++n2;
        }
        return maxWidth;
    }

    static String replaceArrowsWithUtf8Characters(String text) {
        if (text.startsWith("< ")) {
            text = "\u25c4" + text.substring(1);
        }
        if (text.endsWith(" >")) {
            text = String.valueOf(text.substring(0, text.length() - 1)) + "\u25ba";
        } else if (text.endsWith(" ^")) {
            text = String.valueOf(text.substring(0, text.length() - 1)) + "\u25b2";
        } else if (text.endsWith(" v")) {
            text = String.valueOf(text.substring(0, text.length() - 1)) + "\u25bc";
        }
        return text;
    }

    static PointDouble calcPosOfMiddleText(DrawHandler drawer, String text, Line line, int currentLineNr, double halfMiddleBlockHeight) {
        double textY;
        double textX;
        double textWidth = LineDescriptionUtils.calcWidth(drawer, text);
        boolean horizontalLine = line.getDirectionOfLine(true).isHorizontal();
        PointDouble center = line.getCenter();
        double previousLinesUsedSpace = (double)currentLineNr * drawer.textHeightMaxWithSpace();
        if (horizontalLine) {
            textX = center.getX() - textWidth / 2.0;
            textY = center.getY() + previousLinesUsedSpace - 4.0;
        } else {
            textX = center.getX() + 4.0;
            textY = center.getY() + previousLinesUsedSpace - halfMiddleBlockHeight + drawer.textHeightMaxWithSpace();
        }
        return new PointDouble(textX, textY);
    }
}

