/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;

public class DateTimeAxisUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.charts.Bundle");
    private static final String DAYS_FORMAT = messages.getString("DateTimeAxisUtils_DaysFormat");
    private static final String HOURS_FORMAT = messages.getString("DateTimeAxisUtils_HoursFormat");
    private static final String HOURS_EXT_FORMAT = messages.getString("DateTimeAxisUtils_HoursExtFormat");
    private static final String MINUTES_FORMAT = messages.getString("DateTimeAxisUtils_MinutesFormat");
    private static final String MINUTES_EXT_FORMAT = messages.getString("DateTimeAxisUtils_MinutesExtFormat");
    private static final String SECONDS_FORMAT = messages.getString("DateTimeAxisUtils_SecondsFormat");
    private static final String SECONDS_EXT_FORMAT = messages.getString("DateTimeAxisUtils_SecondsExtFormat");
    private static final String MILLIS_FORMAT = messages.getString("DateTimeAxisUtils_MillisFormat");
    private static final String MILLIS_EXT_FORMAT = messages.getString("DateTimeAxisUtils_MillisExtFormat");
    private static final String MILLIS_FULL_FORMAT = messages.getString("DateTimeAxisUtils_MillisFullFormat");
    private static final String MILLIS_ONLY_FORMAT = messages.getString("DateTimeAxisUtils_MillisOnlyFormat");
    public static final int MIN_TIMEMARK_STEP = 100;
    public static final Color BASE_TIMELINE_COLOR = new Color(0, 0, 0);
    public static final Color MAIN_TIMELINE_COLOR = new Color(150, 150, 150);
    public static final Color TICK_TIMELINE_COLOR = new Color(230, 230, 230);
    private static final int TIME_FORMAT_UNKNOWN = -1;
    private static final int TIME_FORMAT_MILLIS = 10;
    private static final int TIME_FORMAT_SECONDS = 20;
    private static final int TIME_FORMAT_MINUTES = 30;
    private static final int TIME_FORMAT_HOURS = 40;
    private static final int TIME_FORMAT_DAYS = 50;
    private static final SimpleDateFormat daysDateFormat = new SimpleDateFormat(DAYS_FORMAT);
    private static final SimpleDateFormat hoursDateFormat = new SimpleDateFormat(HOURS_FORMAT);
    private static final SimpleDateFormat hoursDateFormatD = new SimpleDateFormat(HOURS_EXT_FORMAT);
    private static final SimpleDateFormat minutesDateFormat = new SimpleDateFormat(MINUTES_FORMAT);
    private static final SimpleDateFormat minutesDateFormatD = new SimpleDateFormat(MINUTES_EXT_FORMAT);
    private static final SimpleDateFormat secondsDateFormat = new SimpleDateFormat(SECONDS_FORMAT);
    private static final SimpleDateFormat secondsDateFormatD = new SimpleDateFormat(SECONDS_EXT_FORMAT);
    private static final SimpleDateFormat millisDateFormat = new SimpleDateFormat(MILLIS_FORMAT);
    private static final SimpleDateFormat millisDateFormatD = new SimpleDateFormat(MILLIS_EXT_FORMAT);
    private static final SimpleDateFormat millisDateFormatF = new SimpleDateFormat(MILLIS_FULL_FORMAT);
    private static final SimpleDateFormat onlyMillisDateFormat = new SimpleDateFormat(MILLIS_ONLY_FORMAT);
    private static final long[] timeUnitsGrid = new long[]{10L, 20L, 50L, 100L, 250L, 500L, 1000L, 2000L, 5000L, 10000L, 15000L, 30000L, 60000L, 120000L, 300000L, 600000L, 900000L, 1800000L, 3600000L, 0x6DDD00L, 10800000L, 21600000L, 43200000L, 86400000L, 172800000L, 259200000L, 432000000L};
    private static final int[] timeUnitsFormat = new int[]{10, 10, 10, 10, 10, 10, 20, 20, 20, 20, 20, 20, 30, 30, 30, 30, 30, 30, 40, 40, 40, 40, 40, 50, 50, 50, 50};
    private static final HashMap timeUnitsToIndex = new HashMap();

    public static String getDaysValue(long l, boolean bl) {
        return daysDateFormat.format(new Date(l));
    }

    public static String getHoursValue(long l, boolean bl) {
        return bl ? hoursDateFormatD.format(new Date(l)) : hoursDateFormat.format(new Date(l));
    }

    public static double getMaximumScale(long l) {
        return 100.0 / (double)l;
    }

    public static String getMillisValue(long l, boolean bl) {
        return bl ? millisDateFormatD.format(new Date(l)) : millisDateFormat.format(new Date(l));
    }

    public static String getMillisValueFull(long l) {
        return millisDateFormatF.format(new Date(l));
    }

    public static String getMinutesValue(long l, boolean bl) {
        return bl ? minutesDateFormatD.format(new Date(l)) : minutesDateFormat.format(new Date(l));
    }

    public static long getOptimalUnits(double d) {
        for (int i = 0; i < timeUnitsGrid.length; ++i) {
            if (!((double)timeUnitsGrid[i] * d >= 100.0)) continue;
            return timeUnitsGrid[i];
        }
        return timeUnitsGrid[timeUnitsGrid.length - 1];
    }

    public static String getSecondsValue(long l, boolean bl) {
        return bl ? secondsDateFormatD.format(new Date(l)) : secondsDateFormat.format(new Date(l));
    }

    public static String getTimeMarkMillisString(long l, long l2) {
        int n = DateTimeAxisUtils.getTimeUnitsFormat(l2);
        if (n != 10) {
            return "";
        }
        return onlyMillisDateFormat.format(new Date(l));
    }

    public static String getTimeMarkNoMillisString(long l, long l2, boolean bl) {
        int n = DateTimeAxisUtils.getTimeUnitsFormat(l2);
        if (n == -1) {
            return "";
        }
        if (n == 10) {
            n = 20;
        }
        return DateTimeAxisUtils.getTimeMarkStringFromFormat(l, n, bl);
    }

    public static String getTimeMarkString(long l, long l2, boolean bl) {
        int n = DateTimeAxisUtils.getTimeUnitsFormat(l2);
        if (n == -1) {
            return "";
        }
        return DateTimeAxisUtils.getTimeMarkStringFromFormat(l, n, bl);
    }

    private static String getTimeMarkStringFromFormat(long l, int n, boolean bl) {
        switch (n) {
            case 10: {
                return DateTimeAxisUtils.getMillisValue(l, bl);
            }
            case 20: 
            case 30: 
            case 40: {
                return DateTimeAxisUtils.getSecondsValue(l, bl);
            }
            case 50: {
                return DateTimeAxisUtils.getDaysValue(l, bl);
            }
        }
        return "";
    }

    private static int getTimeUnitsFormat(long l) {
        int n = DateTimeAxisUtils.getUnitsIndex(l);
        if (n == -1) {
            return -1;
        }
        return timeUnitsFormat[n];
    }

    private static int getUnitsIndex(long l) {
        Object v = timeUnitsToIndex.get(new Long(l));
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    static {
        for (int i = 0; i < timeUnitsGrid.length; ++i) {
            timeUnitsToIndex.put(new Long(timeUnitsGrid[i]), i);
        }
    }
}

