/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.api.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.selector.api.nodes.Bundle;
import org.netbeans.modules.profiler.selector.api.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.api.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.openide.util.lookup.Lookups;

public class PackageNode
extends ContainerNode {
    private ClientUtils.SourceCodeSelection signature;
    private SourcePackageInfo pkg;
    public static final String DEFAULT_NAME = "<default>";
    public static final Comparator COMPARATOR = new Comparator<PackageNode>(){

        @Override
        public int compare(PackageNode packageNode, PackageNode packageNode2) {
            if (packageNode.getNodeName().equals(PackageNode.DEFAULT_NAME)) {
                return -1;
            }
            return packageNode.toString().compareTo(packageNode2.toString());
        }
    };
    protected static final Logger LOGGER = Logger.getLogger(PackageNode.class.getName());

    public PackageNode(SourcePackageInfo sourcePackageInfo, ContainerNode containerNode) {
        super(sourcePackageInfo != null ? sourcePackageInfo.getSimpleName() : Bundle.LBL_Unknown(), PackageNode.defaultizeName(sourcePackageInfo != null ? sourcePackageInfo.getBinaryName() : Bundle.LBL_Unknown()), Icons.getIcon((String)"LanguageIcons.Package"), containerNode, Lookups.singleton((Object)sourcePackageInfo));
        this.pkg = sourcePackageInfo = this.flatten(sourcePackageInfo);
        if (sourcePackageInfo != null) {
            String string = sourcePackageInfo.getBinaryName();
            string = string + (string.isEmpty() ? "" : ".**");
            this.signature = new ClientUtils.SourceCodeSelection(string, null, null);
        }
    }

    @Override
    protected final SelectorChildren getChildren() {
        return new PackageChildren(this);
    }

    @Override
    public final ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    public final SourcePackageInfo getPackageInfo() {
        return this.pkg;
    }

    private List<ClassNode> getContainedClasses() {
        ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        if (this.pkg == null) {
            return arrayList;
        }
        for (SourceClassInfo sourceClassInfo : this.pkg.getClasses()) {
            arrayList.add(new ClassNode(sourceClassInfo, this));
        }
        return arrayList;
    }

    private List<PackageNode> getContainedPackages() {
        ArrayList<PackageNode> arrayList = new ArrayList<PackageNode>();
        if (this.pkg == null) {
            return arrayList;
        }
        for (SourcePackageInfo sourcePackageInfo : this.pkg.getSubpackages()) {
            arrayList.add(new PackageNode(sourcePackageInfo, this));
        }
        return arrayList;
    }

    private static String defaultizeName(String string) {
        return string == null || string.length() == 0 ? DEFAULT_NAME : string;
    }

    private SourcePackageInfo flatten(SourcePackageInfo sourcePackageInfo) {
        boolean bl = false;
        Collection collection = sourcePackageInfo.getSubpackages();
        Collection collection2 = sourcePackageInfo.getClasses();
        while (collection.size() == 1 && collection2.isEmpty()) {
            sourcePackageInfo = (SourcePackageInfo)collection.iterator().next();
            collection = sourcePackageInfo.getSubpackages();
            collection2 = sourcePackageInfo.getClasses();
            bl = true;
        }
        if (bl) {
            this.updateDisplayName(PackageNode.defaultizeName(sourcePackageInfo != null ? sourcePackageInfo.getBinaryName() : Bundle.LBL_Unknown()));
        }
        return sourcePackageInfo;
    }

    private static class PackageChildren
    extends SelectorChildren<PackageNode> {
        public PackageChildren(PackageNode packageNode) {
            super(packageNode);
        }

        @Override
        protected List<SelectorNode> prepareChildren(PackageNode packageNode) {
            ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
            List<PackageNode> list = this.getSubpackages(packageNode);
            List<ClassNode> list2 = this.getClasses(packageNode);
            arrayList.addAll(list);
            arrayList.addAll(list2);
            return arrayList;
        }

        private List<ClassNode> getClasses(PackageNode packageNode) {
            List list = packageNode.getContainedClasses();
            Collections.sort(list, ClassNode.COMPARATOR);
            return list;
        }

        private List<PackageNode> getSubpackages(PackageNode packageNode) {
            List list = packageNode.getContainedPackages();
            Collections.sort(list, COMPARATOR);
            return list;
        }
    }
}

