/*! grafana - v3.1.0 - 2016-07-18
 * Copyright (c) 2016 Torkel Ödegaard; Licensed Apache-2.0 */

define(["jquery","lodash","moment"],function(a,b,c){"use strict";var d={};return d.valueFormats={},d.round_interval=function(a){switch(!0){case a<=15:return 10;case a<=35:return 20;case a<=75:return 50;case a<=150:return 100;case a<=350:return 200;case a<=750:return 500;case a<=1500:return 1e3;case a<=3500:return 2e3;case a<=7500:return 5e3;case a<=12500:return 1e4;case a<=17500:return 15e3;case a<=25e3:return 2e4;case a<=45e3:return 3e4;case a<=9e4:return 6e4;case a<=21e4:return 12e4;case a<=45e4:return 3e5;case a<=75e4:return 6e5;case a<=105e4:return 9e5;case a<=15e5:return 12e5;case a<=27e5:return 18e5;case a<=54e5:return 36e5;case a<=9e6:return 72e5;case a<=162e5:return 108e5;case a<=324e5:return 216e5;case a<=864e5:return 432e5;case a<=1728e5:return 864e5;case a<=6048e5:return 864e5;case a<=18144e5:return 6048e5;case a<36288e5:return 2592e6;default:return 31536e6}},d.secondsToHms=function(a){var b=Math.floor(a/31536e3);if(b)return b+"y";var c=Math.floor(a%31536e3/86400);if(c)return c+"d";var d=Math.floor(a%31536e3%86400/3600);if(d)return d+"h";var e=Math.floor(a%31536e3%86400%3600/60);if(e)return e+"m";var f=Math.floor(a%31536e3%86400%3600%60);if(f)return f+"s";var g=Math.floor(1e3*a);return g?g+"ms":"less then a millisecond"},d.to_percent=function(a,b){return Math.floor(a/b*1e4)/100+"%"},d.addslashes=function(a){return a=a.replace(/\\/g,"\\\\"),a=a.replace(/\'/g,"\\'"),a=a.replace(/\"/g,'\\"'),a=a.replace(/\0/g,"\\0")},d.interval_regex=/(\d+(?:\.\d+)?)(ms|[Mwdhmsy])/,d.intervals_in_seconds={y:31536e3,M:2592e3,w:604800,d:86400,h:3600,m:60,s:1,ms:.001},d.calculateInterval=function(a,b,c){var e,f,g=1;if(c){if(">"!==c[0])return c;f=c.slice(1),g=d.interval_to_ms(f)}return e=d.round_interval((a.to.valueOf()-a.from.valueOf())/b),g>e&&(e=g),d.secondsToHms(e/1e3)},d.describe_interval=function(a){var c=a.match(d.interval_regex);if(c&&b.has(d.intervals_in_seconds,c[2]))return{sec:d.intervals_in_seconds[c[2]],type:c[2],count:parseInt(c[1],10)};throw new Error('Invalid interval string, expecting a number followed by one of "Mwdhmsy"')},d.interval_to_ms=function(a){var b=d.describe_interval(a);return 1e3*b.sec*b.count},d.interval_to_seconds=function(a){var b=d.describe_interval(a);return b.sec*b.count},d.query_color_dot=function(a,b){return'<div class="icon-circle" style="'+["display:inline-block","color:"+a,"font-size:"+b+"px"].join(";")+'"></div>'},d.slugifyForUrl=function(a){return a.toLowerCase().replace(/[^\w ]+/g,"").replace(/ +/g,"-")},d.stringToJsRegex=function(a){if("/"!==a[0])return new RegExp("^"+a+"$");var b=a.match(new RegExp("^/(.*?)/(g?i?m?y?)$"));return new RegExp(b[1],b[2])},d.toFixed=function(a,b){if(null===a)return"";var c=b?Math.pow(10,Math.max(0,b)):1,d=String(Math.round(a*c)/c);if(d.indexOf("e")!==-1||0===a)return d;if(null!=b){var e=d.indexOf("."),f=e===-1?0:d.length-e-1;if(f<b)return(f?d:d+".")+String(c).substr(1,b-f)}return d},d.toFixedScaled=function(a,b,c,e,f){return null===c?d.toFixed(a,b)+f:d.toFixed(a,c+e)+f},d.roundValue=function(a,b){if(null===a)return null;var c=Math.pow(10,b);return Math.round((c*a).toFixed(b))/c},d.formatBuilders={},d.formatBuilders.fixedUnit=function(a){return function(b,c){return null===b?"":d.toFixed(b,c)+" "+a}},d.formatBuilders.scaledUnits=function(a,b){return function(c,e,f){if(null===c)return"";for(var g=0,h=b.length;Math.abs(c)>=a;)if(g++,c/=a,g>=h)return"NA";return g>0&&null!==f&&(e=f+3*g),d.toFixed(c,e)+b[g]}},d.formatBuilders.decimalSIPrefix=function(a,b){var c=["n","µ","m","","k","M","G","T","P","E","Z","Y"];c=c.slice(3+(b||0));var e=c.map(function(b){return" "+b+a});return d.formatBuilders.scaledUnits(1e3,e)},d.formatBuilders.binarySIPrefix=function(a,b){var c=["","Ki","Mi","Gi","Ti","Pi","Ei","Zi","Yi"].slice(b),e=c.map(function(b){return" "+b+a});return d.formatBuilders.scaledUnits(1024,e)},d.formatBuilders.currency=function(a){var b=["","K","M","B","T"],c=d.formatBuilders.scaledUnits(1e3,b);return function(b,d,e){if(null===b)return"";var f=c(b,d,e);return a+f}},d.formatBuilders.simpleCountUnit=function(a){var b=["","K","M","B","T"],c=d.formatBuilders.scaledUnits(1e3,b);return function(b,d,e){if(null===b)return"";var f=c(b,d,e);return f+" "+a}},d.valueFormats.none=d.toFixed,d.valueFormats["short"]=d.formatBuilders.scaledUnits(1e3,[""," K"," Mil"," Bil"," Tri"," Quadr"," Quint"," Sext"," Sept"]),d.valueFormats.dB=d.formatBuilders.fixedUnit("dB"),d.valueFormats.ppm=d.formatBuilders.fixedUnit("ppm"),d.valueFormats.percent=function(a,b){return null===a?"":d.toFixed(a,b)+"%"},d.valueFormats.percentunit=function(a,b){return null===a?"":d.toFixed(100*a,b)+"%"},d.valueFormats.currencyUSD=d.formatBuilders.currency("$"),d.valueFormats.currencyGBP=d.formatBuilders.currency("£"),d.valueFormats.currencyEUR=d.formatBuilders.currency("€"),d.valueFormats.currencyJPY=d.formatBuilders.currency("¥"),d.valueFormats.bits=d.formatBuilders.binarySIPrefix("b"),d.valueFormats.bytes=d.formatBuilders.binarySIPrefix("B"),d.valueFormats.kbytes=d.formatBuilders.binarySIPrefix("B",1),d.valueFormats.mbytes=d.formatBuilders.binarySIPrefix("B",2),d.valueFormats.gbytes=d.formatBuilders.binarySIPrefix("B",3),d.valueFormats.pps=d.formatBuilders.decimalSIPrefix("pps"),d.valueFormats.bps=d.formatBuilders.decimalSIPrefix("bps"),d.valueFormats.Bps=d.formatBuilders.decimalSIPrefix("Bps"),d.valueFormats.KBs=d.formatBuilders.decimalSIPrefix("Bs",1),d.valueFormats.Kbits=d.formatBuilders.decimalSIPrefix("bits",1),d.valueFormats.MBs=d.formatBuilders.decimalSIPrefix("Bs",2),d.valueFormats.Mbits=d.formatBuilders.decimalSIPrefix("bits",2),d.valueFormats.GBs=d.formatBuilders.decimalSIPrefix("Bs",3),d.valueFormats.Gbits=d.formatBuilders.decimalSIPrefix("bits",3),d.valueFormats.ops=d.formatBuilders.simpleCountUnit("ops"),d.valueFormats.rps=d.formatBuilders.simpleCountUnit("rps"),d.valueFormats.wps=d.formatBuilders.simpleCountUnit("wps"),d.valueFormats.iops=d.formatBuilders.simpleCountUnit("iops"),d.valueFormats.watt=d.formatBuilders.decimalSIPrefix("W"),d.valueFormats.kwatt=d.formatBuilders.decimalSIPrefix("W",1),d.valueFormats.voltamp=d.formatBuilders.decimalSIPrefix("VA"),d.valueFormats.kvoltamp=d.formatBuilders.decimalSIPrefix("VA",1),d.valueFormats.voltampreact=d.formatBuilders.decimalSIPrefix("var"),d.valueFormats.watth=d.formatBuilders.decimalSIPrefix("Wh"),d.valueFormats.kwatth=d.formatBuilders.decimalSIPrefix("Wh",1),d.valueFormats.joule=d.formatBuilders.decimalSIPrefix("J"),d.valueFormats.ev=d.formatBuilders.decimalSIPrefix("eV"),d.valueFormats.amp=d.formatBuilders.decimalSIPrefix("A"),d.valueFormats.volt=d.formatBuilders.decimalSIPrefix("V"),d.valueFormats.dBm=d.formatBuilders.decimalSIPrefix("dBm"),d.valueFormats.celsius=d.formatBuilders.fixedUnit("°C"),d.valueFormats.farenheit=d.formatBuilders.fixedUnit("°F"),d.valueFormats.kelvin=d.formatBuilders.fixedUnit("K"),d.valueFormats.humidity=d.formatBuilders.fixedUnit("%H"),d.valueFormats.pressurembar=d.formatBuilders.fixedUnit("mbar"),d.valueFormats.pressurehpa=d.formatBuilders.fixedUnit("hPa"),d.valueFormats.pressurehg=d.formatBuilders.fixedUnit('"Hg'),d.valueFormats.pressurepsi=d.formatBuilders.scaledUnits(1e3,[" psi"," ksi"," Mpsi"]),d.valueFormats.lengthm=d.formatBuilders.decimalSIPrefix("m"),d.valueFormats.lengthmm=d.formatBuilders.decimalSIPrefix("m",-1),d.valueFormats.lengthkm=d.formatBuilders.decimalSIPrefix("m",1),d.valueFormats.lengthmi=d.formatBuilders.fixedUnit("mi"),d.valueFormats.velocityms=d.formatBuilders.fixedUnit("m/s"),d.valueFormats.velocitykmh=d.formatBuilders.fixedUnit("km/h"),d.valueFormats.velocitymph=d.formatBuilders.fixedUnit("mph"),d.valueFormats.velocityknot=d.formatBuilders.fixedUnit("kn"),d.valueFormats.litre=d.formatBuilders.decimalSIPrefix("L"),d.valueFormats.mlitre=d.formatBuilders.decimalSIPrefix("L",-1),d.valueFormats.m3=d.formatBuilders.decimalSIPrefix("m3"),d.valueFormats.hertz=d.formatBuilders.decimalSIPrefix("Hz"),d.valueFormats.ms=function(a,b,c){return null===a?"":Math.abs(a)<1e3?d.toFixed(a,b)+" ms":Math.abs(a)<6e4?d.toFixedScaled(a/1e3,b,c,3," s"):Math.abs(a)<36e5?d.toFixedScaled(a/6e4,b,c,5," min"):Math.abs(a)<864e5?d.toFixedScaled(a/36e5,b,c,7," hour"):Math.abs(a)<31536e6?d.toFixedScaled(a/864e5,b,c,8," day"):d.toFixedScaled(a/31536e6,b,c,10," year")},d.valueFormats.s=function(a,b,c){return null===a?"":Math.abs(a)<60?d.toFixed(a,b)+" s":Math.abs(a)<3600?d.toFixedScaled(a/60,b,c,1," min"):Math.abs(a)<86400?d.toFixedScaled(a/3600,b,c,4," hour"):Math.abs(a)<604800?d.toFixedScaled(a/86400,b,c,5," day"):Math.abs(a)<31536e3?d.toFixedScaled(a/604800,b,c,6," week"):d.toFixedScaled(a/31556900,b,c,7," year")},d.valueFormats["µs"]=function(a,b,c){return null===a?"":Math.abs(a)<1e3?d.toFixed(a,b)+" µs":Math.abs(a)<1e6?d.toFixedScaled(a/1e3,b,c,3," ms"):d.toFixedScaled(a/1e6,b,c,6," s")},d.valueFormats.ns=function(a,b,c){return null===a?"":Math.abs(a)<1e3?d.toFixed(a,b)+" ns":Math.abs(a)<1e6?d.toFixedScaled(a/1e3,b,c,3," µs"):Math.abs(a)<1e9?d.toFixedScaled(a/1e6,b,c,6," ms"):Math.abs(a)<6e10?d.toFixedScaled(a/1e9,b,c,9," s"):d.toFixedScaled(a/6e10,b,c,12," min")},d.valueFormats.m=function(a,b,c){return null===a?"":Math.abs(a)<60?d.toFixed(a,b)+" min":Math.abs(a)<1440?d.toFixedScaled(a/60,b,c,2," hour"):Math.abs(a)<10080?d.toFixedScaled(a/1440,b,c,3," day"):Math.abs(a)<604800?d.toFixedScaled(a/10080,b,c,4," week"):d.toFixedScaled(a/525948,b,c,5," year")},d.valueFormats.h=function(a,b,c){return null===a?"":Math.abs(a)<24?d.toFixed(a,b)+" hour":Math.abs(a)<168?d.toFixedScaled(a/24,b,c,2," day"):Math.abs(a)<8760?d.toFixedScaled(a/168,b,c,3," week"):d.toFixedScaled(a/8760,b,c,4," year")},d.valueFormats.d=function(a,b,c){return null===a?"":Math.abs(a)<7?d.toFixed(a,b)+" day":Math.abs(a)<365?d.toFixedScaled(a/7,b,c,2," week"):d.toFixedScaled(a/365,b,c,3," year")},d.toDuration=function(a,b){return c.duration(a,b)},d.valueFormats.dtdurationms=function(a){return d.toDuration(a,"ms").humanize()},d.valueFormats.dtdurations=function(a){return d.toDuration(a,"s").humanize()},d.getUnitFormats=function(){return[{text:"none",submenu:[{text:"none",value:"none"},{text:"short",value:"short"},{text:"percent (0-100)",value:"percent"},{text:"percent (0.0-1.0)",value:"percentunit"},{text:"Humidity (%H)",value:"humidity"},{text:"ppm",value:"ppm"},{text:"decibel",value:"dB"}]},{text:"currency",submenu:[{text:"Dollars ($)",value:"currencyUSD"},{text:"Pounds (£)",value:"currencyGBP"},{text:"Euro (€)",value:"currencyEUR"},{text:"Yen (¥)",value:"currencyJPY"}]},{text:"time",submenu:[{text:"Hertz (1/s)",value:"hertz"},{text:"nanoseconds (ns)",value:"ns"},{text:"microseconds (µs)",value:"µs"},{text:"milliseconds (ms)",value:"ms"},{text:"seconds (s)",value:"s"},{text:"minutes (m)",value:"m"},{text:"hours (h)",value:"h"},{text:"days (d)",value:"d"},{text:"duration (ms)",value:"dtdurationms"},{text:"duration (s)",value:"dtdurations"}]},{text:"data",submenu:[{text:"bits",value:"bits"},{text:"bytes",value:"bytes"},{text:"kilobytes",value:"kbytes"},{text:"megabytes",value:"mbytes"},{text:"gigabytes",value:"gbytes"}]},{text:"data rate",submenu:[{text:"packets/sec",value:"pps"},{text:"bits/sec",value:"bps"},{text:"bytes/sec",value:"Bps"},{text:"kilobits/sec",value:"Kbits"},{text:"kilobytes/sec",value:"KBs"},{text:"megabits/sec",value:"Mbits"},{text:"megabytes/sec",value:"MBs"},{text:"gigabytes/sec",value:"GBs"},{text:"gigabits/sec",value:"Gbits"}]},{text:"throughput",submenu:[{text:"ops/sec (ops)",value:"ops"},{text:"reads/sec (rps)",value:"rps"},{text:"writes/sec (wps)",value:"wps"},{text:"I/O ops/sec (iops)",value:"iops"}]},{text:"length",submenu:[{text:"millimetre (mm)",value:"lengthmm"},{text:"meter (m)",value:"lengthm"},{text:"kilometer (km)",value:"lengthkm"},{text:"mile (mi)",value:"lengthmi"}]},{text:"velocity",submenu:[{text:"m/s",value:"velocityms"},{text:"km/h",value:"velocitykmh"},{text:"mph",value:"velocitymph"},{text:"knot (kn)",value:"velocityknot"}]},{text:"volume",submenu:[{text:"millilitre",value:"mlitre"},{text:"litre",value:"litre"},{text:"cubic metre",value:"m3"}]},{text:"energy",submenu:[{text:"watt (W)",value:"watt"},{text:"kilowatt (kW)",value:"kwatt"},{text:"volt-ampere (VA)",value:"voltamp"},{text:"kilovolt-ampere (kVA)",value:"kvoltamp"},{text:"volt-ampere reactive (var)",value:"voltampreact"},{text:"watt-hour (Wh)",value:"watth"},{text:"kilowatt-hour (kWh)",value:"kwatth"},{text:"joule (J)",value:"joule"},{text:"electron volt (eV)",value:"ev"},{text:"Ampere (A)",value:"amp"},{text:"Volt (V)",value:"volt"},{text:"Decibel-milliwatt (dBm)",value:"dBm"}]},{text:"temperature",submenu:[{text:"Celcius (°C)",value:"celsius"},{text:"Farenheit (°F)",value:"farenheit"},{text:"Kelvin (K)",value:"kelvin"}]},{text:"pressure",submenu:[{text:"Millibars",value:"pressurembar"},{text:"Hectopascals",value:"pressurehpa"},{text:"Inches of mercury",value:"pressurehg"},{text:"PSI",value:"pressurepsi"}]}]},d});