/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.RubyThread;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.InterruptMode;
import org.jruby.truffle.core.exception.ExceptionOperations;
import org.jruby.truffle.core.fiber.FiberManager;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SafepointAction;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.util.Memo;

@CoreClass(value="Thread")
public abstract class ThreadNodes {

    @Primitive(name="thread_get_fiber_locals", unsafe={UnsafeGroup.THREADS})
    public static abstract class ThreadGetFiberLocalsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyThread(thread)"})
        public DynamicObject getFiberLocals(DynamicObject thread) {
            DynamicObject fiber = Layouts.THREAD.getFiberManager(thread).getCurrentFiber();
            return Layouts.FIBER.getFiberLocals(fiber);
        }
    }

    @Primitive(name="thread_set_priority", unsafe={UnsafeGroup.THREADS})
    public static abstract class ThreadSetPriorityPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        public ThreadSetPriorityPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyThread(thread)"})
        public int getPriority(DynamicObject thread, int rubyPriority) {
            if (rubyPriority < -3) {
                rubyPriority = -3;
            } else if (rubyPriority > 3) {
                rubyPriority = 3;
            }
            int javaPriority = RubyThread.rubyPriorityToJavaPriority((int)rubyPriority);
            Thread javaThread = Layouts.THREAD.getThread(thread);
            if (javaThread != null) {
                javaThread.setPriority(javaPriority);
            }
            Layouts.THREAD.setPriority(thread, rubyPriority);
            return rubyPriority;
        }
    }

    @Primitive(name="thread_get_priority", unsafe={UnsafeGroup.THREADS})
    public static abstract class ThreadGetPriorityPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        public ThreadGetPriorityPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyThread(thread)"})
        public int getPriority(DynamicObject thread) {
            Thread javaThread = Layouts.THREAD.getThread(thread);
            if (javaThread != null) {
                int javaPriority = javaThread.getPriority();
                return RubyThread.javaPriorityToRubyPriority((int)javaPriority);
            }
            return Layouts.THREAD.getPriority(thread);
        }
    }

    @Primitive(name="thread_raise", unsafe={UnsafeGroup.THREADS})
    public static abstract class ThreadRaisePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyThread(thread)", "isRubyException(exception)"})
        public DynamicObject raise(DynamicObject thread, DynamicObject exception) {
            ThreadRaisePrimitiveNode.raiseInThread(this.getContext(), thread, exception, this);
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        public static void raiseInThread(final RubyContext context, DynamicObject rubyThread, final DynamicObject exception, Node currentNode) {
            Thread javaThread = Layouts.FIBER.getThread(Layouts.THREAD.getFiberManager(rubyThread).getCurrentFiber());
            context.getSafepointManager().pauseThreadAndExecuteLater(javaThread, currentNode, new SafepointAction(){

                @Override
                public void run(DynamicObject currentThread, Node currentNode) {
                    if (Layouts.EXCEPTION.getBacktrace(exception) == null) {
                        Backtrace backtrace = context.getCallStack().getBacktrace(currentNode);
                        Layouts.EXCEPTION.setBacktrace(exception, backtrace);
                    }
                    throw new RaiseException(exception);
                }
            });
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject list() {
            Object[] threads = this.getContext().getThreadManager().getThreadList();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), threads, threads.length);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true, unsafe={UnsafeGroup.THREADS})
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass, @Cached(value="create()") AllocateObjectNode allocateObjectNode, @Cached(value="createReadAbortOnExceptionNode()") ReadObjectFieldNode readAbortOnException) {
            DynamicObject object = allocateObjectNode.allocate(rubyClass, ThreadManager.createThreadLocals(this.getContext()), new AtomicReference<InterruptMode>(ThreadManager.DEFAULT_INTERRUPT_MODE), new AtomicReference<RubyThread.Status>(ThreadManager.DEFAULT_STATUS), new ArrayList(), null, new CountDownLatch(1), readAbortOnException.execute(this.getContext().getCoreLibrary().getThreadClass()), new AtomicReference<Object>(null), new AtomicReference<Object>(null), new AtomicReference<Object>(null), new AtomicBoolean(false), new AtomicInteger(0));
            Layouts.THREAD.setFiberManagerUnsafe(object, new FiberManager(this.getContext(), object));
            return object;
        }

        protected ReadObjectFieldNode createReadAbortOnExceptionNode() {
            return ReadObjectFieldNodeGen.create("@abort_on_exception", false);
        }
    }

    @CoreMethod(names={"abort_on_exception="}, required=1, unsafe={UnsafeGroup.THREADS})
    public static abstract class SetAbortOnExceptionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject setAbortOnException(DynamicObject self, boolean abortOnException) {
            Layouts.THREAD.setAbortOnException(self, abortOnException);
            return this.nil();
        }
    }

    @CoreMethod(names={"abort_on_exception"}, unsafe={UnsafeGroup.THREADS})
    public static abstract class AbortOnExceptionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean abortOnException(DynamicObject self) {
            return Layouts.THREAD.getAbortOnException(self);
        }
    }

    @CoreMethod(names={"wakeup", "run"}, unsafe={UnsafeGroup.THREADS})
    public static abstract class WakeupNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject wakeup(DynamicObject thread) {
            if (Layouts.THREAD.getStatus(thread) == RubyThread.Status.DEAD) {
                throw new RaiseException(this.coreExceptions().threadErrorKilledThread(this));
            }
            Layouts.THREAD.getWakeUp(thread).set(true);
            Thread toInterrupt = Layouts.THREAD.getThread(thread);
            if (toInterrupt != null) {
                toInterrupt.interrupt();
            }
            return thread;
        }
    }

    @CoreMethod(names={"value"}, unsafe={UnsafeGroup.THREADS})
    public static abstract class ValueNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object value(DynamicObject self) {
            JoinNode.doJoin(this, self);
            return Layouts.THREAD.getValue(self);
        }
    }

    @CoreMethod(names={"stop?"}, unsafe={UnsafeGroup.THREADS})
    public static abstract class StopNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean stop(DynamicObject self) {
            RubyThread.Status status = Layouts.THREAD.getStatus(self);
            return status == RubyThread.Status.DEAD || status == RubyThread.Status.SLEEP;
        }
    }

    @CoreMethod(names={"status"}, unsafe={UnsafeGroup.THREADS})
    public static abstract class StatusNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object status(DynamicObject self) {
            RubyThread.Status status = Layouts.THREAD.getStatus(self);
            if (status == RubyThread.Status.DEAD) {
                if (Layouts.THREAD.getException(self) != null) {
                    return this.nil();
                }
                return false;
            }
            return this.createString(status.bytes);
        }
    }

    @CoreMethod(names={"pass"}, onSingleton=true, unsafe={UnsafeGroup.THREADS})
    public static abstract class PassNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject pass() {
            Thread.yield();
            return this.nil();
        }
    }

    @CoreMethod(names={"main"}, onSingleton=true)
    public static abstract class MainNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject main() {
            return this.getContext().getThreadManager().getRootThread();
        }
    }

    @CoreMethod(names={"join"}, optional=1, unsafe={UnsafeGroup.THREADS})
    public static abstract class JoinNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject join(DynamicObject thread, NotProvided timeout) {
            JoinNode.doJoin(this, thread);
            return thread;
        }

        @Specialization(guards={"isNil(nil)"})
        public DynamicObject join(DynamicObject thread, Object nil) {
            return this.join(thread, NotProvided.INSTANCE);
        }

        @Specialization
        public Object join(DynamicObject thread, int timeout) {
            return this.joinMillis(thread, timeout * 1000);
        }

        @Specialization
        public Object join(DynamicObject thread, double timeout) {
            return this.joinMillis(thread, (int)(timeout * 1000.0));
        }

        private Object joinMillis(DynamicObject self, int timeoutInMillis) {
            if (this.doJoinMillis(self, timeoutInMillis)) {
                return self;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        public static void doJoin(RubyNode currentNode, final DynamicObject thread) {
            currentNode.getContext().getThreadManager().runUntilResult(currentNode, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    Layouts.THREAD.getFinishedLatch(thread).await();
                    return true;
                }
            });
            if (Layouts.THREAD.getException(thread) != null) {
                throw new RaiseException(Layouts.THREAD.getException(thread));
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean doJoinMillis(final DynamicObject thread, final int timeoutInMillis) {
            final long start = System.currentTimeMillis();
            boolean joined = this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    long now = System.currentTimeMillis();
                    long waited = now - start;
                    if (waited >= (long)timeoutInMillis) {
                        return Layouts.THREAD.getFinishedLatch(thread).getCount() == 0L;
                    }
                    return Layouts.THREAD.getFinishedLatch(thread).await((long)timeoutInMillis - waited, TimeUnit.MILLISECONDS);
                }
            });
            if (joined && Layouts.THREAD.getException(thread) != null) {
                throw new RaiseException(Layouts.THREAD.getException(thread));
            }
            return joined;
        }
    }

    @CoreMethod(names={"initialize"}, rest=true, needsBlock=true, unsafe={UnsafeGroup.THREADS})
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject initialize(DynamicObject thread, Object[] arguments, DynamicObject block) {
            ThreadManager.initialize(thread, this.getContext(), (Node)this, arguments, block);
            return this.nil();
        }
    }

    @CoreMethod(names={"handle_interrupt"}, required=2, needsBlock=true, visibility=Visibility.PRIVATE, unsafe={UnsafeGroup.THREADS})
    public static abstract class HandleInterruptNode
    extends YieldingCoreMethodNode {
        @CompilerDirectives.CompilationFinal
        private DynamicObject immediateSymbol;
        @CompilerDirectives.CompilationFinal
        private DynamicObject onBlockingSymbol;
        @CompilerDirectives.CompilationFinal
        private DynamicObject neverSymbol;
        private final BranchProfile errorProfile = BranchProfile.create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isRubyClass(exceptionClass)", "isRubySymbol(timing)"})
        public Object handle_interrupt(VirtualFrame frame, DynamicObject self, DynamicObject exceptionClass, DynamicObject timing, DynamicObject block) {
            InterruptMode newInterruptMode = this.symbolToInterruptMode(timing);
            InterruptMode oldInterruptMode = Layouts.THREAD.getInterruptMode(self);
            Layouts.THREAD.setInterruptMode(self, newInterruptMode);
            try {
                Object object = this.yield(frame, block, new Object[0]);
                return object;
            }
            finally {
                Layouts.THREAD.setInterruptMode(self, oldInterruptMode);
            }
        }

        private InterruptMode symbolToInterruptMode(DynamicObject symbol) {
            if (symbol == this.getImmediateSymbol()) {
                return InterruptMode.IMMEDIATE;
            }
            if (symbol == this.getOnBlockingSymbol()) {
                return InterruptMode.ON_BLOCKING;
            }
            if (symbol == this.getNeverSymbol()) {
                return InterruptMode.NEVER;
            }
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().argumentError("invalid timing symbol", this));
        }

        private DynamicObject getImmediateSymbol() {
            if (this.immediateSymbol == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.immediateSymbol = this.getSymbol("immediate");
            }
            return this.immediateSymbol;
        }

        private DynamicObject getOnBlockingSymbol() {
            if (this.onBlockingSymbol == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.onBlockingSymbol = this.getSymbol("on_blocking");
            }
            return this.onBlockingSymbol;
        }

        private DynamicObject getNeverSymbol() {
            if (this.neverSymbol == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.neverSymbol = this.getSymbol("never");
            }
            return this.neverSymbol;
        }
    }

    @CoreMethod(names={"kill", "exit", "terminate"}, unsafe={UnsafeGroup.THREADS})
    public static abstract class KillNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject kill(DynamicObject rubyThread) {
            Thread toKill = Layouts.THREAD.getThread(rubyThread);
            if (toKill == null) {
                return rubyThread;
            }
            this.getContext().getSafepointManager().pauseThreadAndExecuteLater(toKill, this, new SafepointAction(){

                @Override
                public void run(DynamicObject currentThread, Node currentNode) {
                    ThreadManager.shutdown(this.getContext(), currentThread, currentNode);
                }
            });
            return rubyThread;
        }
    }

    @CoreMethod(names={"current"}, onSingleton=true)
    public static abstract class CurrentNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject current() {
            return this.getContext().getThreadManager().getCurrentThread();
        }
    }

    @CoreMethod(names={"backtrace"}, unsafe={UnsafeGroup.THREADS})
    public static abstract class BacktraceNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject backtrace(DynamicObject rubyThread) {
            Thread thread = Layouts.FIBER.getThread(Layouts.THREAD.getFiberManager(rubyThread).getCurrentFiber());
            final Memo result = new Memo(null);
            this.getContext().getSafepointManager().pauseThreadAndExecute(thread, this, new SafepointAction(){

                @Override
                public void run(DynamicObject thread, Node currentNode) {
                    Backtrace backtrace = this.getContext().getCallStack().getBacktrace(currentNode);
                    result.set((Object)ExceptionOperations.backtraceAsRubyStringArray(this.getContext(), null, backtrace));
                }
            });
            if (result.get() != null) {
                return (DynamicObject)result.get();
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"alive?"}, unsafe={UnsafeGroup.THREADS})
    public static abstract class AliveNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean alive(DynamicObject thread) {
            RubyThread.Status status = Layouts.THREAD.getStatus(thread);
            return status != RubyThread.Status.ABORTING && status != RubyThread.Status.DEAD;
        }
    }
}

