#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import six
from tempest.lib import exceptions

from novaclient import api_versions
from novaclient.tests.functional.v2.legacy import test_readonly_nova


class SimpleReadOnlyNovaClientTest(
        test_readonly_nova.SimpleReadOnlyNovaClientTest):

    """Read only functional python-novaclient tests.

    This only exercises client commands that are read only.
    """

    COMPUTE_API_VERSION = "2.latest"

    def test_admin_image_list(self):
        # The nova images proxy API returns a 404 after 2.35.
        if self.client.api_version > api_versions.APIVersion('2.35'):
            ex = self.assertRaises(exceptions.CommandFailed,
                                   super(SimpleReadOnlyNovaClientTest, self).
                                   test_admin_image_list)
            self.assertIn('NotFound', six.text_type(ex))
        else:
            super(SimpleReadOnlyNovaClientTest, self).test_admin_image_list()
