/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro;

import dguitar.codecs.guitarPro.GPChordDiagram;
import dguitar.codecs.guitarPro.GPDuration;
import dguitar.codecs.guitarPro.GPEffectsOnBeat;
import dguitar.codecs.guitarPro.GPMixTableChange;
import java.util.ArrayList;
import java.util.List;

public class GPBeat {
    private boolean _emptyBeat = false;
    private boolean _restBeat = false;
    private GPDuration _duration = GPDuration.QUARTER;
    private List _notes = new ArrayList(0);
    private int _nTuplet = 0;
    private boolean[] _strings = new boolean[7];
    public GPChordDiagram chordDiagram = null;
    public boolean dottedNotes = false;
    public GPEffectsOnBeat effects = null;
    public GPMixTableChange mixTableChange = null;
    public String text = "";

    public boolean equals(Object o) {
        boolean resp = false;
        if (o != null && o.getClass().isInstance(this)) {
            GPBeat other = (GPBeat)o;
            resp = this._emptyBeat == other._emptyBeat;
            resp = resp && this._restBeat == other._restBeat;
            resp = resp && this.dottedNotes == other.dottedNotes;
            resp = resp && this._duration == other._duration;
            resp = resp && this._notes.equals(other._notes);
        }
        return resp;
    }

    public GPDuration getDuration() {
        return this._duration;
    }

    public List getNotes() {
        return this._notes;
    }

    public int getNTuplet() {
        return this._nTuplet;
    }

    public boolean isEmptyBeat() {
        return this._emptyBeat;
    }

    public boolean isNoteBeat() {
        return !this.isEmptyBeat() && !this.isRestBeat();
    }

    public boolean isRestBeat() {
        return this._restBeat;
    }

    public boolean isStringPlayed(int i) {
        return this._strings[i];
    }

    public void setDuration(GPDuration duration) {
        this._duration = duration;
    }

    public void setEmptyBeat(boolean emptyBeat) {
        this._emptyBeat = emptyBeat;
    }

    public void setNTuplet(int tuplet) {
        this._nTuplet = tuplet;
    }

    public void setRestBeat(boolean restBeat) {
        this._restBeat = restBeat;
    }

    public void setString(int i, boolean string) {
        this._strings[i] = string;
    }

    public String toString() {
        int i;
        String res = "\tBeat - BEGIN";
        if (this.chordDiagram != null) {
            res = String.valueOf(res) + "\n\t\t" + this.chordDiagram.toString();
        }
        res = String.valueOf(res) + "\n\t\tdotted notes: " + this.dottedNotes;
        res = String.valueOf(res) + "\n\t\tduration: " + this._duration.toString();
        if (this.effects != null) {
            res = String.valueOf(res) + "\n\t\t" + this.effects.toString();
        }
        res = String.valueOf(res) + "\n\t\tEmpty Beat:" + this._emptyBeat;
        if (this.mixTableChange != null) {
            res = String.valueOf(res) + "\n\t\tMixTableChange" + this.mixTableChange.toString();
        }
        if (this._notes != null) {
            res = String.valueOf(res) + "\n\t\tNotes: ";
            i = 0;
            while (i < this._notes.size()) {
                res = String.valueOf(res) + "\n\t\t\t" + this._notes.get(i).toString();
                ++i;
            }
        }
        res = String.valueOf(res) + "\n\t\tnTuplet: " + this._nTuplet;
        res = String.valueOf(res) + "\n\t\tRest Beat:" + this._restBeat;
        res = String.valueOf(res) + "\n\t\tStrings played: ";
        i = 6;
        while (i >= 0) {
            if (this._strings[i]) {
                res = String.valueOf(res) + i;
                if (i - 1 >= 0) {
                    res = String.valueOf(res) + ",";
                }
            }
            --i;
        }
        res = String.valueOf(res) + "\n\t\tText: " + this.text;
        res = String.valueOf(res) + "\n\tBeat - END";
        return res;
    }
}

