/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public final class IngestProxyActionFilter
implements ActionFilter {
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final AtomicInteger randomNodeGenerator = new AtomicInteger(Randomness.get().nextInt());

    @Inject
    public IngestProxyActionFilter(ClusterService clusterService, TransportService transportService) {
        this.clusterService = clusterService;
        this.transportService = transportService;
    }

    @Override
    public <Request extends ActionRequest<Request>, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        switch (action) {
            case "indices:data/write/index": {
                IndexAction ingestAction = IndexAction.INSTANCE;
                IndexRequest indexRequest = (IndexRequest)request;
                if (Strings.hasText(indexRequest.getPipeline())) {
                    this.forwardIngestRequest(ingestAction, request, listener);
                    break;
                }
                chain.proceed(task, action, request, listener);
                break;
            }
            case "indices:data/write/bulk": {
                BulkAction ingestAction = BulkAction.INSTANCE;
                BulkRequest bulkRequest = (BulkRequest)request;
                if (bulkRequest.hasIndexRequestsWithPipelines()) {
                    this.forwardIngestRequest(ingestAction, request, listener);
                    break;
                }
                chain.proceed(task, action, request, listener);
                break;
            }
            default: {
                chain.proceed(task, action, request, listener);
            }
        }
    }

    private void forwardIngestRequest(Action<?, ?, ?> action, ActionRequest request, ActionListener<?> listener) {
        this.transportService.sendRequest(this.randomIngestNode(), action.name(), request, new ActionListenerResponseHandler<Object>(listener, action::newResponse));
    }

    @Override
    public <Response extends ActionResponse> void apply(String action, Response response, ActionListener<Response> listener, ActionFilterChain<?, Response> chain) {
        chain.proceed(action, response, listener);
    }

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }

    private DiscoveryNode randomIngestNode() {
        assert (!this.clusterService.localNode().isIngestNode());
        DiscoveryNodes nodes = this.clusterService.state().getNodes();
        DiscoveryNode[] ingestNodes = (DiscoveryNode[])nodes.getIngestNodes().values().toArray(DiscoveryNode.class);
        if (ingestNodes.length == 0) {
            throw new IllegalStateException("There are no ingest nodes in this cluster, unable to forward request to an ingest node.");
        }
        int index = this.getNodeNumber();
        return ingestNodes[index % ingestNodes.length];
    }

    private int getNodeNumber() {
        int index = this.randomNodeGenerator.incrementAndGet();
        if (index < 0) {
            index = 0;
            this.randomNodeGenerator.set(0);
        }
        return index;
    }
}

