/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.TimeValue;

public class XContentMapValues {
    public static List<Object> extractRawValues(String path, Map<String, Object> map) {
        ArrayList<Object> values = new ArrayList<Object>();
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return values;
        }
        XContentMapValues.extractRawValues(values, map, pathElements, 0);
        return values;
    }

    private static void extractRawValues(List values, Map<String, Object> part, String[] pathElements, int index) {
        int nextIndex;
        if (index == pathElements.length) {
            return;
        }
        String key = pathElements[index];
        Object currentValue = part.get(key);
        for (nextIndex = index + 1; currentValue == null && nextIndex != pathElements.length; ++nextIndex) {
            key = key + "." + pathElements[nextIndex];
            currentValue = part.get(key);
        }
        if (currentValue == null) {
            return;
        }
        if (currentValue instanceof Map) {
            XContentMapValues.extractRawValues(values, (Map)currentValue, pathElements, nextIndex);
        } else if (currentValue instanceof List) {
            XContentMapValues.extractRawValues(values, (List)currentValue, pathElements, nextIndex);
        } else {
            values.add(currentValue);
        }
    }

    private static void extractRawValues(List values, List<Object> part, String[] pathElements, int index) {
        for (Object value : part) {
            if (value == null) continue;
            if (value instanceof Map) {
                XContentMapValues.extractRawValues(values, (Map)value, pathElements, index);
                continue;
            }
            if (value instanceof List) {
                XContentMapValues.extractRawValues(values, (List)value, pathElements, index);
                continue;
            }
            values.add(value);
        }
    }

    public static Object extractValue(String path, Map<String, Object> map) {
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return null;
        }
        return XContentMapValues.extractValue(pathElements, 0, map);
    }

    private static Object extractValue(String[] pathElements, int index, Object currentValue) {
        if (index == pathElements.length) {
            return currentValue;
        }
        if (currentValue == null) {
            return null;
        }
        if (currentValue instanceof Map) {
            int nextIndex;
            Map map = (Map)currentValue;
            String key = pathElements[index];
            Object mapValue = map.get(key);
            for (nextIndex = index + 1; mapValue == null && nextIndex != pathElements.length; ++nextIndex) {
                key = key + "." + pathElements[nextIndex];
                mapValue = map.get(key);
            }
            return XContentMapValues.extractValue(pathElements, nextIndex, mapValue);
        }
        if (currentValue instanceof List) {
            List valueList = (List)currentValue;
            ArrayList<Object> newList = new ArrayList<Object>(valueList.size());
            for (Object o : valueList) {
                Object listValue = XContentMapValues.extractValue(pathElements, index, o);
                if (listValue == null) continue;
                newList.add(listValue);
            }
            return newList;
        }
        return null;
    }

    public static Map<String, Object> filter(Map<String, Object> map, String[] includes, String[] excludes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        XContentMapValues.filter(map, result, includes == null ? Strings.EMPTY_ARRAY : includes, excludes == null ? Strings.EMPTY_ARRAY : excludes, new StringBuilder());
        return result;
    }

    private static void filter(Map<String, Object> map, Map<String, Object> into, String[] includes, String[] excludes, StringBuilder sb) {
        if (includes.length == 0 && excludes.length == 0) {
            into.putAll(map);
            return;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            int mark = sb.length();
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(key);
            String path = sb.toString();
            if (Regex.simpleMatch(excludes, path)) {
                sb.setLength(mark);
                continue;
            }
            boolean exactIncludeMatch = false;
            boolean pathIsPrefixOfAnInclude = false;
            if (includes.length == 0) {
                exactIncludeMatch = true;
            } else {
                for (String include : includes) {
                    if (include.charAt(0) == '*') {
                        if (Regex.simpleMatch(include, path)) {
                            exactIncludeMatch = true;
                            break;
                        }
                        pathIsPrefixOfAnInclude = true;
                        continue;
                    }
                    if (include.startsWith(path)) {
                        if (include.length() == path.length()) {
                            exactIncludeMatch = true;
                            break;
                        }
                        if (include.length() > path.length() && include.charAt(path.length()) == '.') {
                            pathIsPrefixOfAnInclude = true;
                            continue;
                        }
                    }
                    if (!Regex.simpleMatch(include, path)) continue;
                    exactIncludeMatch = true;
                    break;
                }
            }
            if (!pathIsPrefixOfAnInclude && !exactIncludeMatch) {
                sb.setLength(mark);
                continue;
            }
            if (entry.getValue() instanceof Map) {
                HashMap<String, Object> innerInto = new HashMap<String, Object>();
                XContentMapValues.filter((Map)entry.getValue(), innerInto, exactIncludeMatch ? Strings.EMPTY_ARRAY : includes, excludes, sb);
                if (exactIncludeMatch || !innerInto.isEmpty()) {
                    into.put(entry.getKey(), innerInto);
                }
            } else if (entry.getValue() instanceof List) {
                List list = (List)entry.getValue();
                ArrayList<Object> innerInto = new ArrayList<Object>(list.size());
                XContentMapValues.filter(list, innerInto, exactIncludeMatch ? Strings.EMPTY_ARRAY : includes, excludes, sb);
                into.put(entry.getKey(), innerInto);
            } else if (exactIncludeMatch) {
                into.put(entry.getKey(), entry.getValue());
            }
            sb.setLength(mark);
        }
    }

    private static void filter(List<Object> from, List<Object> to, String[] includes, String[] excludes, StringBuilder sb) {
        if (includes.length == 0 && excludes.length == 0) {
            to.addAll(from);
            return;
        }
        for (Object o : from) {
            Cloneable innerInto;
            if (o instanceof Map) {
                innerInto = new HashMap<String, Object>();
                XContentMapValues.filter((Map)o, innerInto, includes, excludes, sb);
                if (innerInto.isEmpty()) continue;
                to.add(innerInto);
                continue;
            }
            if (o instanceof List) {
                innerInto = new ArrayList();
                XContentMapValues.filter((List)o, (List<Object>)((Object)innerInto), includes, excludes, sb);
                if (innerInto.isEmpty()) continue;
                to.add(innerInto);
                continue;
            }
            to.add(o);
        }
    }

    public static boolean isObject(Object node) {
        return node instanceof Map;
    }

    public static boolean isArray(Object node) {
        return node instanceof List;
    }

    public static String nodeStringValue(Object node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.toString();
    }

    public static float nodeFloatValue(Object node, float defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeFloatValue(node);
    }

    public static float nodeFloatValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).floatValue();
        }
        return Float.parseFloat(node.toString());
    }

    public static double nodeDoubleValue(Object node, double defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeDoubleValue(node);
    }

    public static double nodeDoubleValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).doubleValue();
        }
        return Double.parseDouble(node.toString());
    }

    public static int nodeIntegerValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).intValue();
        }
        return Integer.parseInt(node.toString());
    }

    public static int nodeIntegerValue(Object node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        if (node instanceof Number) {
            return ((Number)node).intValue();
        }
        return Integer.parseInt(node.toString());
    }

    public static short nodeShortValue(Object node, short defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeShortValue(node);
    }

    public static short nodeShortValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).shortValue();
        }
        return Short.parseShort(node.toString());
    }

    public static byte nodeByteValue(Object node, byte defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeByteValue(node);
    }

    public static byte nodeByteValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).byteValue();
        }
        return Byte.parseByte(node.toString());
    }

    public static long nodeLongValue(Object node, long defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeLongValue(node);
    }

    public static long nodeLongValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).longValue();
        }
        return Long.parseLong(node.toString());
    }

    public static boolean lenientNodeBooleanValue(Object node, boolean defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.lenientNodeBooleanValue(node);
    }

    public static boolean lenientNodeBooleanValue(Object node) {
        if (node instanceof Boolean) {
            return (Boolean)node;
        }
        if (node instanceof Number) {
            return ((Number)node).intValue() != 0;
        }
        String value = node.toString();
        return !value.equals("false") && !value.equals("0") && !value.equals("off");
    }

    public static boolean nodeBooleanValue(Object node) {
        switch (node.toString()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("Can't parse boolean value [" + node + "], expected [true] or [false]");
    }

    public static TimeValue nodeTimeValue(Object node, TimeValue defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeTimeValue(node);
    }

    public static TimeValue nodeTimeValue(Object node) {
        if (node instanceof Number) {
            return TimeValue.timeValueMillis(((Number)node).longValue());
        }
        return TimeValue.parseTimeValue(node.toString(), null, XContentMapValues.class.getSimpleName() + ".nodeTimeValue");
    }

    public static Map<String, Object> nodeMapValue(Object node, String desc) {
        if (node instanceof Map) {
            return (Map)node;
        }
        throw new ElasticsearchParseException(desc + " should be a hash but was of type: " + node.getClass(), new Object[0]);
    }

    public static String[] nodeStringArrayValue(Object node) {
        if (XContentMapValues.isArray(node)) {
            List list = (List)node;
            String[] arr = new String[list.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = XContentMapValues.nodeStringValue(list.get(i), null);
            }
            return arr;
        }
        return Strings.splitStringByCommaToArray(node.toString());
    }
}

