/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ping.PingContextProvider;
import org.elasticsearch.gateway.GatewayService;

public interface ZenPing
extends LifecycleComponent {
    public void setPingContextProvider(PingContextProvider var1);

    public void ping(PingListener var1, TimeValue var2);

    public static class PingCollection {
        Map<DiscoveryNode, PingResponse> pings = new HashMap<DiscoveryNode, PingResponse>();

        public synchronized boolean addPing(PingResponse ping) {
            PingResponse existingResponse = this.pings.get(ping.node());
            if (existingResponse == null || existingResponse.id() <= ping.id()) {
                this.pings.put(ping.node(), ping);
                return true;
            }
            return false;
        }

        public synchronized void addPings(Iterable<PingResponse> pings) {
            for (PingResponse ping : pings) {
                this.addPing(ping);
            }
        }

        public synchronized List<PingResponse> toList() {
            return new ArrayList<PingResponse>(this.pings.values());
        }

        public synchronized int size() {
            return this.pings.size();
        }
    }

    public static class PingResponse
    implements Streamable {
        public static final PingResponse[] EMPTY = new PingResponse[0];
        private static final AtomicLong idGenerator = new AtomicLong();
        private long id;
        private ClusterName clusterName;
        private DiscoveryNode node;
        private DiscoveryNode master;
        private long clusterStateVersion;

        private PingResponse() {
        }

        public PingResponse(DiscoveryNode node, DiscoveryNode master, ClusterName clusterName, long clusterStateVersion) {
            this.id = idGenerator.incrementAndGet();
            this.node = node;
            this.master = master;
            this.clusterName = clusterName;
            this.clusterStateVersion = clusterStateVersion;
        }

        public PingResponse(DiscoveryNode node, DiscoveryNode master, ClusterState state) {
            this(node, master, state.getClusterName(), state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK) ? -1L : state.version());
        }

        public long id() {
            return this.id;
        }

        public ClusterName clusterName() {
            return this.clusterName;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public DiscoveryNode master() {
            return this.master;
        }

        public long getClusterStateVersion() {
            return this.clusterStateVersion;
        }

        public static PingResponse readPingResponse(StreamInput in) throws IOException {
            PingResponse response = new PingResponse();
            response.readFrom(in);
            return response;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.clusterName = new ClusterName(in);
            this.node = new DiscoveryNode(in);
            if (in.readBoolean()) {
                this.master = new DiscoveryNode(in);
            }
            this.clusterStateVersion = in.readLong();
            this.id = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.clusterName.writeTo(out);
            this.node.writeTo(out);
            if (this.master == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.master.writeTo(out);
            }
            out.writeLong(this.clusterStateVersion);
            out.writeLong(this.id);
        }

        public String toString() {
            return "ping_response{node [" + this.node + "], id[" + this.id + "], master [" + this.master + "], cluster_state_version [" + this.clusterStateVersion + "], cluster_name[" + this.clusterName.value() + "]}";
        }
    }

    public static interface PingListener {
        public void onPing(Collection<PingResponse> var1);
    }
}

