/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortOrder;

public class ScoreSortBuilder
extends SortBuilder<ScoreSortBuilder> {
    public static final String NAME = "_score";
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    private static final SortFieldAndFormat SORT_SCORE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE), DocValueFormat.RAW);
    private static final SortFieldAndFormat SORT_SCORE_REVERSE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE, true), DocValueFormat.RAW);

    public ScoreSortBuilder() {
        this.order(SortOrder.DESC);
    }

    public ScoreSortBuilder(StreamInput in) throws IOException {
        this.order(SortOrder.readFromStream(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.order.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ScoreSortBuilder fromXContent(QueryParseContext context, String fieldName) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        ParseFieldMatcher matcher = context.getParseFieldMatcher();
        String currentName = parser.currentName();
        ScoreSortBuilder result = new ScoreSortBuilder();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (matcher.match(currentName, ORDER_FIELD)) {
                    result.order(SortOrder.fromString(parser.text()));
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[_score] failed to parse field [" + currentName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[_score] unexpected token [" + (Object)((Object)token) + "]", new Object[0]);
        }
        return result;
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) {
        if (this.order == SortOrder.DESC) {
            return SORT_SCORE;
        }
        return SORT_SCORE_REVERSE;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScoreSortBuilder other = (ScoreSortBuilder)object;
        return Objects.equals(this.order, other.order);
    }

    public int hashCode() {
        return Objects.hash(this.order);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

