/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.hash.HashOperations;
import org.jruby.truffle.core.hash.KeyValue;
import org.jruby.truffle.language.PerformanceWarnings;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.CheckArityNode;
import org.jruby.truffle.language.arguments.ReadUserKeywordsHashNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.methods.Arity;

public class CheckKeywordArityNode
extends RubyNode {
    private final Arity arity;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;
    private final BranchProfile receivedKeywordsProfile = BranchProfile.create();
    private final BranchProfile basicArityCheckFailedProfile = BranchProfile.create();

    public CheckKeywordArityNode(RubyContext context, SourceSection sourceSection, Arity arity) {
        super(context, sourceSection);
        this.arity = arity;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode(arity.getRequired());
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        Object keywordArguments = this.readUserKeywordsHashNode.execute(frame);
        int given = RubyArguments.getArgumentsCount(frame);
        if (keywordArguments != null) {
            this.receivedKeywordsProfile.enter();
            --given;
        }
        if (!CheckArityNode.checkArity(this.arity, given)) {
            this.basicArityCheckFailedProfile.enter();
            throw new RaiseException(this.coreExceptions().argumentError(given, this.arity.getRequired(), this));
        }
        if (keywordArguments != null) {
            this.receivedKeywordsProfile.enter();
            this.checkArityKeywordArguments(keywordArguments, given);
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.executeVoid(frame);
        return this.nil();
    }

    @CompilerDirectives.TruffleBoundary
    private void checkArityKeywordArguments(Object keywordArguments, int given) {
        PerformanceWarnings.warn("Ruby keyword arguments are not yet optimized");
        DynamicObject keywordHash = (DynamicObject)keywordArguments;
        for (KeyValue keyValue : HashOperations.iterableKeyValues(keywordHash)) {
            if (this.arity.hasKeywordsRest()) {
                if (RubyGuards.isRubySymbol(keyValue.getKey())) {
                    continue;
                }
            } else if (RubyGuards.isRubySymbol(keyValue.getKey())) {
                if (this.keywordAllowed(keyValue.getKey().toString())) continue;
                throw new RaiseException(this.coreExceptions().argumentErrorUnknownKeyword(keyValue.getKey(), this));
            }
            if (++given <= this.arity.getRequired() || this.arity.hasRest() || this.arity.getOptional() != 0) continue;
            throw new RaiseException(this.coreExceptions().argumentError(given, this.arity.getRequired(), this));
        }
    }

    private boolean keywordAllowed(String keyword) {
        for (String allowedKeyword : this.arity.getKeywordArguments()) {
            if (!keyword.equals(allowedKeyword)) continue;
            return true;
        }
        return false;
    }
}

