/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer4latex;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyAccess;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.DispatchDescriptor;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStatusListener;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.task.XStatusIndicatorFactory;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.URL;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.openoffice.da.comp.w2lcommon.helper.MacroExpander;
import org.openoffice.da.comp.w2lcommon.helper.MessageBox;
import org.openoffice.da.comp.w2lcommon.helper.PropertyHelper;
import org.openoffice.da.comp.w2lcommon.helper.RegistryHelper;
import org.openoffice.da.comp.w2lcommon.helper.XPropertySetHelper;
import org.openoffice.da.comp.writer4latex.TeXify;
import writer2latex.util.CSVList;
import writer2latex.util.Misc;

public final class Writer4LaTeX
extends WeakBase
implements XServiceInfo,
XDispatchProvider,
XInitialization,
XDispatch {
    private static final String PROTOCOL = "org.openoffice.da.writer4latex:";
    private final XComponentContext m_xContext;
    private XFrame m_xFrame;
    private XModel xModel = null;
    private TeXify texify = null;
    private PropertyValue[] mediaProps = null;
    private String sBasePath = null;
    private String sBaseFileName = null;
    public static final String __implementationName = Writer4LaTeX.class.getName();
    public static final String __serviceName = "com.sun.star.frame.ProtocolHandler";
    private static final String[] m_serviceNames = new String[]{"com.sun.star.frame.ProtocolHandler"};

    public Writer4LaTeX(XComponentContext xContext) {
        this.m_xContext = xContext;
    }

    public void initialize(Object[] object) throws Exception {
        if (object.length > 0) {
            this.m_xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)object[0]);
            XController xController = this.m_xFrame.getController();
            if (xController != null) {
                this.xModel = xController.getModel();
            }
        }
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    public XDispatch queryDispatch(URL aURL, String sTargetFrameName, int iSearchFlags) {
        if (aURL.Protocol.compareTo(PROTOCOL) == 0) {
            if (aURL.Path.compareTo("ProcessDocument") == 0) {
                return this;
            }
            if (aURL.Path.compareTo("ProcessDirectly") == 0) {
                return this;
            }
            if (aURL.Path.compareTo("ViewLog") == 0) {
                return this;
            }
        }
        return null;
    }

    public XDispatch[] queryDispatches(DispatchDescriptor[] seqDescriptors) {
        int nCount = seqDescriptors.length;
        XDispatch[] seqDispatcher = new XDispatch[seqDescriptors.length];
        for (int i = 0; i < nCount; ++i) {
            seqDispatcher[i] = this.queryDispatch(seqDescriptors[i].FeatureURL, seqDescriptors[i].FrameName, seqDescriptors[i].SearchFlags);
        }
        return seqDispatcher;
    }

    public void dispatch(URL aURL, PropertyValue[] aArguments) {
        if (aURL.Protocol.compareTo(PROTOCOL) == 0) {
            if (aURL.Path.compareTo("ProcessDocument") == 0) {
                if (this.updateLocation() && this.updateMediaProperties()) {
                    this.process();
                }
                return;
            }
            if (aURL.Path.compareTo("ProcessDirectly") == 0) {
                if (this.updateLocation()) {
                    this.updateMediaPropertiesSilent();
                    this.process();
                }
                return;
            }
            if (aURL.Path.compareTo("ViewLog") == 0) {
                this.viewLog();
                return;
            }
        }
    }

    public void addStatusListener(XStatusListener xControl, URL aURL) {
    }

    public void removeStatusListener(XStatusListener xControl, URL aURL) {
    }

    private void process() {
        XStatusIndicatorFactory xFactory = (XStatusIndicatorFactory)UnoRuntime.queryInterface(XStatusIndicatorFactory.class, (Object)this.m_xFrame);
        XStatusIndicator xStatus = xFactory.createStatusIndicator();
        xStatus.start("Writer4LaTeX", 10);
        xStatus.setValue(1);
        String sBackend = "generic";
        String sBibinputs = null;
        PropertyHelper mediaHelper = new PropertyHelper(this.mediaProps);
        Object filterData = mediaHelper.get("FilterData");
        if (filterData instanceof PropertyValue[]) {
            PropertyHelper filterHelper = new PropertyHelper((PropertyValue[])filterData);
            Object backend = filterHelper.get("backend");
            if (backend instanceof String) {
                sBackend = (String)backend;
            }
            RegistryHelper registry = new RegistryHelper(this.m_xContext);
            try {
                Object view = registry.getRegistryView("/org.openoffice.da.Writer4LaTeX.Options/BibliographyOptions", false);
                XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
                String sBibTeXFiles = this.getFileList(XPropertySetHelper.getPropertyValueAsShort(xProps, "BibTeXLocation"), XPropertySetHelper.getPropertyValueAsString(xProps, "BibTeXDir"));
                if (XPropertySetHelper.getPropertyValueAsBoolean(xProps, "ConvertZoteroCitations")) {
                    filterHelper.put("zotero_bibtex_files", sBibTeXFiles);
                }
                if (XPropertySetHelper.getPropertyValueAsBoolean(xProps, "ConvertJabRefCitations")) {
                    filterHelper.put("jabref_bibtex_files", sBibTeXFiles);
                }
                if (XPropertySetHelper.getPropertyValueAsBoolean(xProps, "UseExternalBibTeXFiles")) {
                    filterHelper.put("external_bibtex_files", sBibTeXFiles);
                }
                filterHelper.put("include_original_citations", Boolean.toString(XPropertySetHelper.getPropertyValueAsBoolean(xProps, "IncludeOriginalCitations")));
                String sBibTeXDir = XPropertySetHelper.getPropertyValueAsString(xProps, "BibTeXDir");
                if (sBibTeXDir.length() > 0) {
                    sBibinputs = sBibTeXDir + File.pathSeparatorChar;
                }
                filterHelper.put("use_natbib", Boolean.toString(XPropertySetHelper.getPropertyValueAsBoolean(xProps, "UseNatbib")));
                filterHelper.put("natbib_options", XPropertySetHelper.getPropertyValueAsString(xProps, "NatbibOptions"));
                mediaHelper.put("FilterData", filterHelper.toArray());
                this.mediaProps = mediaHelper.toArray();
                registry.disposeRegistryView(view);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            String sTargetUrl = this.sBasePath + this.sBaseFileName + ".tex";
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)this.xModel);
            xStorable.storeToURL(sTargetUrl, this.mediaProps);
        }
        catch (com.sun.star.io.IOException e) {
            xStatus.end();
            MessageBox msgBox = new MessageBox(this.m_xContext, this.m_xFrame);
            msgBox.showMessage("Writer4LaTeX Error", "Failed to export document to LaTeX");
            return;
        }
        xStatus.setValue(6);
        if (this.texify == null) {
            this.texify = new TeXify(this.m_xContext);
        }
        File file = new File(this.urlToFile(this.sBasePath), this.sBaseFileName);
        boolean bResult = true;
        try {
            if (sBackend == "pdftex") {
                bResult = this.texify.process(file, sBibinputs, (short)3, true);
            } else if (sBackend == "dvips") {
                bResult = this.texify.process(file, sBibinputs, (short)2, true);
            } else if (sBackend == "xetex") {
                bResult = this.texify.process(file, sBibinputs, (short)4, true);
            } else if (sBackend == "generic") {
                bResult = this.texify.process(file, sBibinputs, (short)1, true);
            }
        }
        catch (IOException e) {
            MessageBox msgBox = new MessageBox(this.m_xContext, this.m_xFrame);
            msgBox.showMessage("Writer4LaTeX Error", e.getMessage());
        }
        xStatus.setValue(10);
        if (!bResult) {
            MessageBox msgBox = new MessageBox(this.m_xContext, this.m_xFrame);
            msgBox.showMessage("Writer4LaTeX Error", "Failed to execute LaTeX - see log for details");
        }
        xStatus.end();
    }

    private String getFileList(short nType, String sDirectory) {
        String sFileList;
        File dir;
        switch (nType) {
            case 0: {
                dir = new File(sDirectory);
                break;
            }
            case 1: {
                dir = new File(this.urlToFile(this.sBasePath), sDirectory);
                break;
            }
            default: {
                dir = this.urlToFile(this.sBasePath);
            }
        }
        CSVList filelist = new CSVList(",");
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".bib")) continue;
                filelist.addValue(Misc.removeExtension(file.getName()));
            }
        }
        return (sFileList = filelist.toString()).length() > 0 ? sFileList : "dummy";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void viewLog() {
        if (!this.updateLocation()) return;
        try {
            Object[] args = new Object[]{this.sBasePath + this.sBaseFileName};
            Object dialog = this.m_xContext.getServiceManager().createInstanceWithArgumentsAndContext("org.openoffice.da.writer4latex.LogViewerDialog", args, this.m_xContext);
            XExecutableDialog xDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)dialog);
            if (xDialog.execute() != 1) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void prepareMediaProperties() {
        this.mediaProps = new PropertyValue[2];
        this.mediaProps[0] = new PropertyValue();
        this.mediaProps[0].Name = "FilterName";
        this.mediaProps[0].Value = "org.openoffice.da.writer2latex";
        this.mediaProps[1] = new PropertyValue();
        this.mediaProps[1].Name = "Overwrite";
        this.mediaProps[1].Value = "true";
    }

    private boolean updateMediaProperties() {
        this.prepareMediaProperties();
        try {
            Object dialog = this.m_xContext.getServiceManager().createInstanceWithContext("org.openoffice.da.writer2latex.LaTeXOptionsDialog", this.m_xContext);
            if (dialog == null) {
                this.mediaProps = null;
                MessageBox msgBox = new MessageBox(this.m_xContext, this.m_xFrame);
                msgBox.showMessage("Writer4LaTeX Error", "Please install Writer2LaTeX version 1.0 or later");
                return false;
            }
            XPropertyAccess xPropertyAccess = (XPropertyAccess)UnoRuntime.queryInterface(XPropertyAccess.class, (Object)dialog);
            xPropertyAccess.setPropertyValues(this.mediaProps);
            XExecutableDialog xDialog = (XExecutableDialog)UnoRuntime.queryInterface(XExecutableDialog.class, (Object)dialog);
            if (xDialog.execute() == 1) {
                this.mediaProps = xPropertyAccess.getPropertyValues();
                return true;
            }
            this.mediaProps = null;
            return false;
        }
        catch (UnknownPropertyException e) {
            this.mediaProps = null;
            return false;
        }
        catch (Exception e) {
            this.mediaProps = null;
            return false;
        }
    }

    private String getOptionAsString(XPropertySet xProps, String sName) {
        Object value = XPropertySetHelper.getPropertyValue(xProps, sName);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Short) {
            return ((Short)value).toString();
        }
        return null;
    }

    private void loadOption(XPropertySet xProps, PropertyHelper filterData, String sRegName, String sOptionName) {
        String sValue = this.getOptionAsString(xProps, sRegName);
        if (sValue != null) {
            filterData.put(sOptionName, sValue);
        }
    }

    private void updateMediaPropertiesSilent() {
        this.prepareMediaProperties();
        RegistryHelper registry = new RegistryHelper(this.m_xContext);
        try {
            Object view = registry.getRegistryView("/org.openoffice.da.Writer2LaTeX.Options/LaTeXOptions", true);
            XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)view);
            PropertyHelper filterData = new PropertyHelper();
            short nConfig = XPropertySetHelper.getPropertyValueAsShort(xProps, "Config");
            switch (nConfig) {
                case 0: {
                    filterData.put("ConfigURL", "*ultraclean.xml");
                    break;
                }
                case 1: {
                    filterData.put("ConfigURL", "*clean.xml");
                    break;
                }
                case 2: {
                    filterData.put("ConfigURL", "*default.xml");
                    break;
                }
                case 3: {
                    filterData.put("ConfigURL", "*pdfprint.xml");
                    break;
                }
                case 4: {
                    filterData.put("ConfigURL", "*pdfscreen.xml");
                    break;
                }
                case 5: {
                    filterData.put("ConfigURL", "$(user)/writer2latex.xml");
                    filterData.put("AutoCreate", "true");
                    break;
                }
                default: {
                    String sConfigName = XPropertySetHelper.getPropertyValueAsString(xProps, "ConfigName");
                    Object configurations = XPropertySetHelper.getPropertyValue(xProps, "Configurations");
                    XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)configurations);
                    Object config = xNameAccess.getByName(sConfigName);
                    XPropertySet xCfgProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)config);
                    MacroExpander expander = new MacroExpander(this.m_xContext);
                    filterData.put("ConfigURL", expander.expandMacros(XPropertySetHelper.getPropertyValueAsString(xCfgProps, "ConfigURL")));
                }
            }
            short nBackend = XPropertySetHelper.getPropertyValueAsShort(xProps, "Backend");
            switch (nBackend) {
                case 0: {
                    filterData.put("backend", "generic");
                    break;
                }
                case 1: {
                    filterData.put("backend", "pdftex");
                    break;
                }
                case 2: {
                    filterData.put("backend", "dvips");
                    break;
                }
                case 3: {
                    filterData.put("backend", "xetex");
                    break;
                }
                case 4: {
                    filterData.put("backend", "unspecified");
                }
            }
            short nInputencoding = XPropertySetHelper.getPropertyValueAsShort(xProps, "Inputencoding");
            switch (nInputencoding) {
                case 0: {
                    filterData.put("inputencoding", "ascii");
                    break;
                }
                case 1: {
                    filterData.put("inputencoding", "latin1");
                    break;
                }
                case 2: {
                    filterData.put("inputencoding", "latin2");
                    break;
                }
                case 3: {
                    filterData.put("inputencoding", "iso-8859-7");
                    break;
                }
                case 4: {
                    filterData.put("inputencoding", "cp1250");
                    break;
                }
                case 5: {
                    filterData.put("inputencoding", "cp1251");
                    break;
                }
                case 6: {
                    filterData.put("inputencoding", "koi8-r");
                    break;
                }
                case 7: {
                    filterData.put("inputencoding", "utf8");
                }
            }
            this.loadOption(xProps, filterData, "Multilingual", "multilingual");
            this.loadOption(xProps, filterData, "GreekMath", "greek_math");
            this.loadOption(xProps, filterData, "AdditionalSymbols", "use_pifont");
            this.loadOption(xProps, filterData, "AdditionalSymbols", "use_ifsym");
            this.loadOption(xProps, filterData, "AdditionalSymbols", "use_wasysym");
            this.loadOption(xProps, filterData, "AdditionalSymbols", "use_eurosym");
            this.loadOption(xProps, filterData, "AdditionalSymbols", "use_tipa");
            this.loadOption(xProps, filterData, "UseBibtex", "use_bibtex");
            this.loadOption(xProps, filterData, "BibtexStyle", "bibtex_style");
            boolean bWrapLines = XPropertySetHelper.getPropertyValueAsBoolean(xProps, "WrapLines");
            if (bWrapLines) {
                this.loadOption(xProps, filterData, "WrapLinesAfter", "wrap_lines_after");
            } else {
                filterData.put("wrap_lines_after", "0");
            }
            this.loadOption(xProps, filterData, "SplitLinkedSections", "split_linked_sections");
            this.loadOption(xProps, filterData, "SplitToplevelSections", "split_toplevel_sections");
            this.loadOption(xProps, filterData, "SaveImagesInSubdir", "save_images_in_subdir");
            short nNotes = XPropertySetHelper.getPropertyValueAsShort(xProps, "Notes");
            switch (nNotes) {
                case 0: {
                    filterData.put("notes", "ignore");
                    break;
                }
                case 1: {
                    filterData.put("notes", "comment");
                    break;
                }
                case 2: {
                    filterData.put("notes", "pdfannotation");
                    break;
                }
                case 3: {
                    filterData.put("notes", "marginpar");
                }
            }
            this.loadOption(xProps, filterData, "Metadata", "metadata");
            this.loadOption(xProps, filterData, "OriginalImageSize", "original_image_size");
            boolean bOptimizeSimpleTables = XPropertySetHelper.getPropertyValueAsBoolean(xProps, "OptimizeSimpleTables");
            if (bOptimizeSimpleTables) {
                this.loadOption(xProps, filterData, "SimpleTableLimit", "simple_table_limit");
            } else {
                filterData.put("simple_table_limit", "0");
            }
            this.loadOption(xProps, filterData, "FloatTables", "float_tables");
            this.loadOption(xProps, filterData, "FloatFigures", "float_figures");
            this.loadOption(xProps, filterData, "FloatOptions", "float_options");
            short nFloatOptions = XPropertySetHelper.getPropertyValueAsShort(xProps, "FloatOptions");
            switch (nFloatOptions) {
                case 0: {
                    filterData.put("float_options", "");
                    break;
                }
                case 1: {
                    filterData.put("float_options", "tp");
                    break;
                }
                case 2: {
                    filterData.put("float_options", "bp");
                    break;
                }
                case 3: {
                    filterData.put("float_options", "htp");
                    break;
                }
                case 4: {
                    filterData.put("float_options", "hbp");
                }
            }
            this.loadOption(xProps, filterData, "IgnoreHardPageBreaks", "ignore_hard_page_breaks");
            this.loadOption(xProps, filterData, "IgnoreHardLineBreaks", "ignore_hard_line_breaks");
            this.loadOption(xProps, filterData, "IgnoreEmptyParagraphs", "ignore_empty_paragraphs");
            this.loadOption(xProps, filterData, "IgnoreDoubleSpaces", "ignore_empty_spaces");
            registry.disposeRegistryView(view);
            PropertyHelper helper = new PropertyHelper(this.mediaProps);
            helper.put("FilterData", filterData.toArray());
            this.mediaProps = helper.toArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean updateLocation() {
        String sDocumentUrl = this.xModel.getURL();
        if (sDocumentUrl.length() != 0) {
            if (sDocumentUrl.startsWith("file:")) {
                Pattern windowsPattern;
                if (System.getProperty("os.name").startsWith("Windows") && !(windowsPattern = Pattern.compile("^file:///[A-Za-z][|:].*")).matcher(sDocumentUrl).matches()) {
                    MessageBox msgBox = new MessageBox(this.m_xContext, this.m_xFrame);
                    msgBox.showMessage("Please save the document on a location with a drive name!", "LaTeX does not support UNC paths");
                    return false;
                }
                File f = this.urlToFile(sDocumentUrl);
                this.sBaseFileName = f.getName();
                int iDot = this.sBaseFileName.lastIndexOf(".");
                if (iDot > -1) {
                    this.sBaseFileName = this.sBaseFileName.substring(0, iDot);
                }
                this.sBaseFileName = this.makeTeXSafe(this.sBaseFileName);
                int iSlash = sDocumentUrl.lastIndexOf("/");
                this.sBasePath = iSlash > -1 ? sDocumentUrl.substring(0, iSlash + 1) : "";
                return true;
            }
            MessageBox msgBox = new MessageBox(this.m_xContext, this.m_xFrame);
            msgBox.showMessage("Please save the document locally!", "LaTeX does not support documents in remote storages");
            return false;
        }
        MessageBox msgBox = new MessageBox(this.m_xContext, this.m_xFrame);
        msgBox.showMessage("Document not saved!", "Please save the document before processing the file");
        return false;
    }

    private String makeTeXSafe(String sArgument) {
        String sResult = "";
        block66: for (int i = 0; i < sArgument.length(); ++i) {
            char c = sArgument.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sResult = sResult + Character.toString(c);
                continue;
            }
            switch (c) {
                case '.': {
                    sResult = sResult + ".";
                    continue block66;
                }
                case '-': {
                    sResult = sResult + "-";
                    continue block66;
                }
                case ' ': {
                    sResult = sResult + "-";
                    continue block66;
                }
                case '_': {
                    sResult = sResult + "-";
                    continue block66;
                }
                case '\u00c0': {
                    sResult = sResult + "A";
                    continue block66;
                }
                case '\u00c1': {
                    sResult = sResult + "A";
                    continue block66;
                }
                case '\u00c2': {
                    sResult = sResult + "A";
                    continue block66;
                }
                case '\u00c3': {
                    sResult = sResult + "A";
                    continue block66;
                }
                case '\u00c4': {
                    sResult = sResult + "AE";
                    continue block66;
                }
                case '\u00c5': {
                    sResult = sResult + "AA";
                    continue block66;
                }
                case '\u00c6': {
                    sResult = sResult + "AE";
                    continue block66;
                }
                case '\u00c7': {
                    sResult = sResult + "C";
                    continue block66;
                }
                case '\u00c8': {
                    sResult = sResult + "E";
                    continue block66;
                }
                case '\u00c9': {
                    sResult = sResult + "E";
                    continue block66;
                }
                case '\u00ca': {
                    sResult = sResult + "E";
                    continue block66;
                }
                case '\u00cb': {
                    sResult = sResult + "E";
                    continue block66;
                }
                case '\u00cc': {
                    sResult = sResult + "I";
                    continue block66;
                }
                case '\u00cd': {
                    sResult = sResult + "I";
                    continue block66;
                }
                case '\u00ce': {
                    sResult = sResult + "I";
                    continue block66;
                }
                case '\u00cf': {
                    sResult = sResult + "I";
                    continue block66;
                }
                case '\u00d0': {
                    sResult = sResult + "D";
                    continue block66;
                }
                case '\u00d1': {
                    sResult = sResult + "N";
                    continue block66;
                }
                case '\u00d2': {
                    sResult = sResult + "O";
                    continue block66;
                }
                case '\u00d3': {
                    sResult = sResult + "O";
                    continue block66;
                }
                case '\u00d4': {
                    sResult = sResult + "O";
                    continue block66;
                }
                case '\u00d5': {
                    sResult = sResult + "O";
                    continue block66;
                }
                case '\u00d6': {
                    sResult = sResult + "OE";
                    continue block66;
                }
                case '\u00d8': {
                    sResult = sResult + "OE";
                    continue block66;
                }
                case '\u00d9': {
                    sResult = sResult + "U";
                    continue block66;
                }
                case '\u00da': {
                    sResult = sResult + "U";
                    continue block66;
                }
                case '\u00db': {
                    sResult = sResult + "U";
                    continue block66;
                }
                case '\u00dc': {
                    sResult = sResult + "UE";
                    continue block66;
                }
                case '\u00dd': {
                    sResult = sResult + "Y";
                    continue block66;
                }
                case '\u00df': {
                    sResult = sResult + "sz";
                    continue block66;
                }
                case '\u00e0': {
                    sResult = sResult + "a";
                    continue block66;
                }
                case '\u00e1': {
                    sResult = sResult + "a";
                    continue block66;
                }
                case '\u00e2': {
                    sResult = sResult + "a";
                    continue block66;
                }
                case '\u00e3': {
                    sResult = sResult + "a";
                    continue block66;
                }
                case '\u00e4': {
                    sResult = sResult + "ae";
                    continue block66;
                }
                case '\u00e5': {
                    sResult = sResult + "aa";
                    continue block66;
                }
                case '\u00e6': {
                    sResult = sResult + "ae";
                    continue block66;
                }
                case '\u00e7': {
                    sResult = sResult + "c";
                    continue block66;
                }
                case '\u00e8': {
                    sResult = sResult + "e";
                    continue block66;
                }
                case '\u00e9': {
                    sResult = sResult + "e";
                    continue block66;
                }
                case '\u00ea': {
                    sResult = sResult + "e";
                    continue block66;
                }
                case '\u00eb': {
                    sResult = sResult + "e";
                    continue block66;
                }
                case '\u00ec': {
                    sResult = sResult + "i";
                    continue block66;
                }
                case '\u00ed': {
                    sResult = sResult + "i";
                    continue block66;
                }
                case '\u00ee': {
                    sResult = sResult + "i";
                    continue block66;
                }
                case '\u00ef': {
                    sResult = sResult + "i";
                    continue block66;
                }
                case '\u00f0': {
                    sResult = sResult + "d";
                    continue block66;
                }
                case '\u00f1': {
                    sResult = sResult + "n";
                    continue block66;
                }
                case '\u00f2': {
                    sResult = sResult + "o";
                    continue block66;
                }
                case '\u00f3': {
                    sResult = sResult + "o";
                    continue block66;
                }
                case '\u00f4': {
                    sResult = sResult + "o";
                    continue block66;
                }
                case '\u00f5': {
                    sResult = sResult + "o";
                    continue block66;
                }
                case '\u00f6': {
                    sResult = sResult + "oe";
                    continue block66;
                }
                case '\u00f8': {
                    sResult = sResult + "oe";
                    continue block66;
                }
                case '\u00f9': {
                    sResult = sResult + "u";
                    continue block66;
                }
                case '\u00fa': {
                    sResult = sResult + "u";
                    continue block66;
                }
                case '\u00fb': {
                    sResult = sResult + "u";
                    continue block66;
                }
                case '\u00fc': {
                    sResult = sResult + "ue";
                    continue block66;
                }
                case '\u00fd': {
                    sResult = sResult + "y";
                    continue block66;
                }
                case '\u00ff': {
                    sResult = sResult + "y";
                }
            }
        }
        if (sResult.length() == 0) {
            return "writer4latex";
        }
        return sResult;
    }

    private File urlToFile(String sUrl) {
        try {
            return new File(new URI(sUrl));
        }
        catch (URISyntaxException e) {
            return new File(".");
        }
    }
}

