/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox.utils;

import ch.interlis.iom.IomObject;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox.IoxReaderAlt;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;

public class IoxReaderAltAdapter
implements IoxReaderAlt {
    private IoxReader is = null;
    private int state = 0;

    public IoxReaderAltAdapter(IoxReader in) {
        this.is = in;
        this.state = 0;
    }

    public StartTransferEvent readHeader() throws IoxException {
        if (this.state == 0) {
            IoxEvent event = null;
            event = this.is.read();
            if (event == null) {
                return null;
            }
            if (event instanceof StartTransferEvent) {
                this.state = 20;
                return (StartTransferEvent)event;
            }
            throw new IoxException("unexpected event type " + event.getClass().getName());
        }
        throw new IllegalStateException();
    }

    public StartBasketEvent readBasket() throws IoxException {
        if (this.state == 20) {
            IoxEvent event = null;
            event = this.is.read();
            if (event instanceof EndTransferEvent) {
                this.state = 0;
                return null;
            }
            if (event instanceof StartBasketEvent) {
                this.state = 30;
                return (StartBasketEvent)event;
            }
            throw new IoxException("unexpected event type " + event.getClass().getName());
        }
        throw new IllegalStateException();
    }

    public IomObject readObject() throws IoxException {
        if (this.state == 30) {
            IoxEvent event = null;
            event = this.is.read();
            if (event instanceof ObjectEvent) {
                this.state = 30;
                return ((ObjectEvent)event).getIomObject();
            }
            if (event instanceof EndBasketEvent) {
                this.state = 20;
                return null;
            }
            throw new IoxException("unexpected event type " + event.getClass().getName());
        }
        throw new IllegalStateException();
    }

    public void close() throws IoxException {
        if (this.is != null) {
            this.is = null;
        }
        this.state = 0;
    }
}

