/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.db.BlindtextCreator;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.DBMetaData;

public class FieldColumn {
    protected int ColIndex;
    private Object DefaultValue;
    private String m_sFieldName;
    private String m_sDisplayFieldName;
    private String FieldTitle;
    private String m_sCommandName;
    private int m_nDBFormatKey;
    private int m_nFieldType;
    private XPropertySet m_xColPropertySet;
    private int FieldWidth;
    private boolean bIsNumberFormat;
    private static boolean bFormatKeysInitialized = false;
    private static int iDateFormatKey;
    private static int iDateTimeFormatKey;
    private static int iNumberFormatKey;
    private static int iTextFormatKey;
    private static int iTimeFormatKey;
    private static int iLogicalFormatKey;
    private CommandMetaData m_aCommandMetaData;

    public FieldColumn(CommandMetaData oCommandMetaData, String _DisplayFieldName) {
        this.m_sDisplayFieldName = _DisplayFieldName;
        this.m_sCommandName = oCommandMetaData.getCommandName();
        this.FieldTitle = this.m_sFieldName = this.getOnlyFieldName(this.m_sDisplayFieldName, this.m_sCommandName);
        DBMetaData.CommandObject oTable = oCommandMetaData.getTableByName(this.m_sCommandName);
        this.initializeFormatKeys(oCommandMetaData, oTable.getColumns());
    }

    public FieldColumn(CommandMetaData oCommandMetaData, String _FieldName, String _CommandName, boolean _bInstantiateByDisplayName) {
        this.m_sCommandName = _CommandName;
        if (_bInstantiateByDisplayName) {
            this.m_sDisplayFieldName = _FieldName;
            this.m_sFieldName = this.getOnlyFieldName(_FieldName, _CommandName);
        } else {
            this.m_sFieldName = _FieldName;
            this.m_sDisplayFieldName = FieldColumn.composeDisplayFieldName(_CommandName, this.m_sFieldName);
        }
        this.FieldTitle = this.m_sFieldName;
        this.m_aCommandMetaData = oCommandMetaData;
    }

    public FieldColumn(CommandMetaData oCommandMetaData, XNameAccess _xColumns, String _FieldName) {
        this.m_sDisplayFieldName = this.m_sFieldName = _FieldName;
        this.ColIndex = JavaTools.FieldInList(_xColumns.getElementNames(), this.m_sFieldName) + 1;
        this.initializeFormatKeys(oCommandMetaData, _xColumns);
        try {
            this.m_sCommandName = (String)this.m_xColPropertySet.getPropertyValue("TableName");
        }
        catch (UnknownPropertyException unknownPropertyException) {
        }
        catch (WrappedTargetException wrappedTargetException) {
            // empty catch block
        }
    }

    public int getFieldType() {
        if (this.m_nFieldType == 0) {
            DBMetaData.CommandObject oTable = this.m_aCommandMetaData.getTableByName(this.m_sCommandName);
            this.initializeFormatKeys(this.m_aCommandMetaData, oTable.getColumns());
        }
        return this.m_nFieldType;
    }

    public int getFieldWidth() {
        this.getFieldType();
        return this.FieldWidth;
    }

    public int getDBFormatKey() {
        this.getFieldType();
        return this.m_nDBFormatKey;
    }

    public boolean isNumberFormat() {
        this.getFieldType();
        return this.bIsNumberFormat;
    }

    private String getOnlyFieldName(String _DisplayFieldName, String _CommandName) {
        return _DisplayFieldName.substring(_CommandName.length() + 1, _DisplayFieldName.length());
    }

    public static String composeDisplayFieldName(String _sCommandName, String _sFieldName) {
        return _sCommandName + "." + _sFieldName;
    }

    private void initializeFormatKeys(CommandMetaData oCommandMetaData, XNameAccess _xColumns) {
        try {
            if (!bFormatKeysInitialized) {
                NumberFormatter aNumberFormatter = oCommandMetaData.getNumberFormatter();
                iDateFormatKey = aNumberFormatter.getDateFormatKey();
                iDateTimeFormatKey = aNumberFormatter.getDateTimeFormatKey();
                iNumberFormatKey = aNumberFormatter.getNumberFormatKey();
                iTextFormatKey = aNumberFormatter.getTextFormatKey();
                iTimeFormatKey = aNumberFormatter.getTimeFormatKey();
                iLogicalFormatKey = aNumberFormatter.getLogicalFormatKey();
                bFormatKeysInitialized = true;
            }
            this.m_xColPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)_xColumns.getByName(this.m_sFieldName));
            this.ColIndex = JavaTools.FieldInList(_xColumns.getElementNames(), this.m_sFieldName) + 1;
            this.m_nFieldType = AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Type"));
            this.getTyperelatedFieldData();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public XPropertySet getXColumnPropertySet() {
        this.getFieldType();
        return this.m_xColPropertySet;
    }

    public String getDisplayFieldName() {
        return this.m_sDisplayFieldName;
    }

    public String getCommandName() {
        return this.m_sCommandName;
    }

    public String getFieldName() {
        return this.m_sFieldName;
    }

    public String getFieldTitle() {
        return this.FieldTitle;
    }

    public void setFieldTitle(String _sTitle) {
        this.FieldTitle = _sTitle;
    }

    public boolean isBoolean() {
        boolean bIsBoolean = false;
        switch (this.getFieldType()) {
            case -7: 
            case 16: {
                bIsBoolean = true;
                break;
            }
            default: {
                bIsBoolean = false;
            }
        }
        return bIsBoolean;
    }

    private void getTyperelatedFieldData() {
        int StandardFormatKey = 0;
        try {
            switch (this.getFieldType()) {
                case -7: 
                case 16: {
                    StandardFormatKey = iLogicalFormatKey;
                    this.FieldWidth = 5;
                    this.bIsNumberFormat = true;
                    break;
                }
                case -6: 
                case 5: {
                    StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 5;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 4: {
                    StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 10;
                    this.bIsNumberFormat = true;
                    break;
                }
                case -5: {
                    StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 15;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 1: {
                    StandardFormatKey = iTextFormatKey;
                    this.getTextFieldWidth(10);
                    this.bIsNumberFormat = false;
                    break;
                }
                case 12: {
                    StandardFormatKey = iTextFormatKey;
                    this.getTextFieldWidth(30);
                    this.bIsNumberFormat = false;
                    break;
                }
                case -1: {
                    StandardFormatKey = iTextFormatKey;
                    this.getTextFieldWidth(60);
                    this.bIsNumberFormat = false;
                    break;
                }
                case 2: {
                    StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 20;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 10 + AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Scale")) + 1;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 91: {
                    StandardFormatKey = iDateFormatKey;
                    this.FieldWidth = 10;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 92: {
                    StandardFormatKey = iTimeFormatKey;
                    this.FieldWidth = 10;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 93: {
                    StandardFormatKey = iDateTimeFormatKey;
                    this.FieldWidth = 20;
                    this.bIsNumberFormat = true;
                }
            }
            Object oKey = this.m_xColPropertySet.getPropertyValue("FormatKey");
            this.m_nDBFormatKey = AnyConverter.isVoid((Object)oKey) ? StandardFormatKey : AnyConverter.toInt((Object)oKey);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.m_nDBFormatKey = StandardFormatKey;
        }
    }

    private void getTextFieldWidth(int iWidth) {
        try {
            this.FieldWidth = AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Precision"));
            if (this.FieldWidth > 0) {
                if (this.FieldWidth > 2 * iWidth) {
                    this.FieldWidth = 2 * iWidth;
                } else if (this.FieldWidth == 0) {
                    this.FieldWidth = iWidth;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void initDefaultValue() {
        switch (this.getFieldType()) {
            case -7: 
            case 16: {
                this.DefaultValue = Integer.valueOf("1");
                break;
            }
            case -6: {
                this.DefaultValue = Integer.valueOf("98");
                break;
            }
            case 5: {
                this.DefaultValue = Integer.valueOf("987");
                break;
            }
            case 4: {
                this.DefaultValue = Integer.valueOf("9876");
                break;
            }
            case -5: {
                this.DefaultValue = Integer.valueOf("98765");
                break;
            }
            case 1: {
                this.DefaultValue = String.valueOf('x');
                break;
            }
            case -1: 
            case 12: {
                this.DefaultValue = BlindtextCreator.getBlindTextString(this.FieldTitle, this.FieldWidth);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.DefaultValue = Double.valueOf("9876.54");
                break;
            }
            case 91: {
                this.DefaultValue = Double.valueOf("42510");
                break;
            }
            case 92: {
                this.DefaultValue = Double.valueOf("10");
                break;
            }
            case 93: {
                this.DefaultValue = Double.valueOf("5454110");
                break;
            }
        }
    }

    public Object getDefaultValue() {
        if (this.DefaultValue == null) {
            this.initDefaultValue();
        }
        return this.DefaultValue;
    }
}

