/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

class OverwriteWindow
extends FixedFrame
implements CbButtonCallback {
    FileManager filemgr;
    RemoteFile src;
    RemoteFile already;
    TextField newname;
    CbButton ok;
    CbButton cancel;
    int idx;
    boolean mode;

    OverwriteWindow(FileManager fileManager, RemoteFile remoteFile, RemoteFile remoteFile2, int n) {
        this.filemgr = fileManager;
        this.src = remoteFile2;
        this.already = remoteFile;
        this.idx = n;
        this.mode = this.filemgr.cut_mode;
        this.setLayout(new BorderLayout());
        this.setTitle(this.filemgr.text("over_title"));
        this.add("North", new MultiLabel(this.filemgr.text("over_msg", this.already.path), 30, 0));
        this.add("West", new Label(this.filemgr.text("over_new")));
        this.newname = new TextField(remoteFile.name, 30);
        this.add("East", this.newname);
        this.newname.setFont(this.filemgr.fixed);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.ok = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("over_ok"), 0, this);
        panel.add(this.ok);
        this.cancel = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("cancel"), 0, this);
        panel.add(this.cancel);
        this.add("South", panel);
        Util.recursiveBody(this);
        this.pack();
        this.show();
    }

    public void click(CbButton cbButton) {
        if (cbButton == this.cancel) {
            this.dispose();
        } else if (cbButton == this.ok && this.newname.getText().length() > 0) {
            RemoteFile remoteFile = this.already.directory;
            RemoteFile remoteFile2 = remoteFile.find(this.newname.getText());
            if (remoteFile2 == this.src) {
                new ErrorWindow(this.filemgr.text("paste_eself"));
                return;
            }
            if (remoteFile2 != null && (remoteFile2.type == 0 || remoteFile2.type == 5)) {
                new ErrorWindow(this.filemgr.text("paste_eover", remoteFile2.path));
                return;
            }
            String string = (remoteFile.path.equals("/") ? "/" : remoteFile.path + "/") + this.newname.getText();
            RemoteFile remoteFile3 = this.filemgr.paste_file(this.src, this.already.directory, string, remoteFile2, this.mode);
            if (this.filemgr.cut_mode && remoteFile3 != null) {
                this.filemgr.cut_buffer[this.idx] = remoteFile3;
            }
            this.dispose();
        }
    }
}

