/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonClient;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonProtocol;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonServer;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonWorker;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.MultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.Clock;

public class CompilerDaemonStarter {
    private static final Logger LOG = Logging.getLogger(CompilerDaemonStarter.class);
    private final WorkerProcessFactory workerFactory;
    private final StartParameter startParameter;

    public CompilerDaemonStarter(WorkerProcessFactory workerFactory, StartParameter startParameter) {
        this.workerFactory = workerFactory;
        this.startParameter = startParameter;
    }

    public CompilerDaemonClient startDaemon(File workingDir, DaemonForkOptions forkOptions) {
        LOG.debug("Starting Gradle compiler daemon with fork options {}.", (Object)forkOptions);
        Clock clock = new Clock();
        MultiRequestWorkerProcessBuilder builder = this.workerFactory.multiRequestWorker(CompilerDaemonWorker.class, CompilerDaemonProtocol.class, CompilerDaemonServer.class);
        builder.setBaseName("Gradle Compiler Daemon");
        builder.setLogLevel(this.startParameter.getLogLevel());
        builder.applicationClasspath(forkOptions.getClasspath());
        builder.sharedPackages(forkOptions.getSharedPackages());
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setMinHeapSize(forkOptions.getMinHeapSize());
        javaCommand.setMaxHeapSize(forkOptions.getMaxHeapSize());
        javaCommand.setJvmArgs(forkOptions.getJvmArgs());
        javaCommand.setWorkingDir((Object)workingDir);
        CompilerDaemonWorker worker = (CompilerDaemonWorker)builder.build();
        worker.start();
        CompilerDaemonClient client = new CompilerDaemonClient(forkOptions, worker);
        LOG.info("Started Gradle compiler daemon ({}) with fork options {}.", (Object)clock.getTime(), (Object)forkOptions);
        return client;
    }
}

