/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationListener;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;

public class DaemonHealthCheck {
    private final DaemonExpirationStrategy strategy;
    private final ListenerBroadcast<DaemonExpirationListener> listenerBroadcast;

    public DaemonHealthCheck(DaemonExpirationStrategy strategy, ListenerManager listenerManager) {
        this.strategy = strategy;
        this.listenerBroadcast = listenerManager.createAnonymousBroadcaster(DaemonExpirationListener.class);
    }

    public void executeHealthCheck() {
        DaemonExpirationResult result = this.strategy.checkExpiration();
        if (result.getStatus() != DaemonExpirationStatus.DO_NOT_EXPIRE) {
            ((DaemonExpirationListener)this.listenerBroadcast.getSource()).onExpirationEvent(result);
        }
    }
}

