/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.rubygrapefruit.platform.FileInfo;
import net.rubygrapefruit.platform.WindowsFileInfo;

public class WindowsFileStat
implements WindowsFileInfo {
    private static final long EPOCH_OFFSET = WindowsFileStat.offset();
    private final String path;
    private FileInfo.Type type;
    private long size;
    private long lastModified;

    private static long offset() {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(1601, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public WindowsFileStat(String path) {
        this.path = path;
    }

    public void details(int type, long size, long lastModifiedWinTime) {
        this.type = FileInfo.Type.values()[type];
        this.size = size;
        this.lastModified = this.type == FileInfo.Type.Missing ? 0L : this.toJavaTime(lastModifiedWinTime);
    }

    private long toJavaTime(long winFileTime) {
        return winFileTime / 10000L + EPOCH_OFFSET;
    }

    public String toString() {
        return this.path;
    }

    public FileInfo.Type getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModifiedTime() {
        return this.lastModified;
    }
}

