/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import org.simpleframework.transport.Negotiator;
import org.simpleframework.transport.Notifier;
import org.simpleframework.transport.Processor;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.reactor.ExecutorReactor;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.util.thread.PoolExecutor;

class SecureNegotiator
implements Negotiator {
    private final Processor transporter;
    private final PoolExecutor executor;
    private final Reactor reactor;

    public SecureNegotiator(Processor transporter, int count) throws IOException {
        this.executor = new PoolExecutor(Notifier.class, count);
        this.reactor = new ExecutorReactor(this.executor);
        this.transporter = transporter;
    }

    public void process(Operation task) throws IOException {
        this.reactor.process(task);
    }

    public void process(Operation task, int require) throws IOException {
        this.reactor.process(task, require);
    }

    public void process(Transport transport) throws IOException {
        this.transporter.process(transport);
    }

    public void stop() throws IOException {
        this.executor.stop();
        this.reactor.stop();
    }
}

