/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactResolveResult;

public class DefaultArtifactSet
implements ArtifactSet {
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleSource moduleSource;
    private final ModuleExclusion exclusions;
    private final ArtifactResolver artifactResolver;
    private final Map<ComponentArtifactIdentifier, ResolvedArtifact> allResolvedArtifacts;
    private final long id;
    private final Set<? extends ComponentArtifactMetadata> artifacts;

    public DefaultArtifactSet(ModuleVersionIdentifier ownerId, ModuleSource moduleSource, ModuleExclusion exclusions, Set<? extends ComponentArtifactMetadata> artifacts, ArtifactResolver artifactResolver, Map<ComponentArtifactIdentifier, ResolvedArtifact> allResolvedArtifacts, long id) {
        this.moduleVersionIdentifier = ownerId;
        this.moduleSource = moduleSource;
        this.exclusions = exclusions;
        this.artifacts = artifacts;
        this.artifactResolver = artifactResolver;
        this.allResolvedArtifacts = allResolvedArtifacts;
        this.id = id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Set<ResolvedArtifact> getArtifacts() {
        LinkedHashSet<ResolvedArtifact> resolvedArtifacts = new LinkedHashSet<ResolvedArtifact>(this.artifacts.size());
        for (ComponentArtifactMetadata componentArtifactMetadata : this.artifacts) {
            IvyArtifactName artifactName = componentArtifactMetadata.getName();
            if (this.exclusions.excludeArtifact(this.moduleVersionIdentifier.getModule(), artifactName)) continue;
            ResolvedArtifact resolvedArtifact = this.allResolvedArtifacts.get(componentArtifactMetadata.getId());
            if (resolvedArtifact == null) {
                LazyArtifactSource artifactSource = new LazyArtifactSource(componentArtifactMetadata, this.moduleSource, this.artifactResolver);
                resolvedArtifact = new DefaultResolvedArtifact(new DefaultResolvedModuleVersion(this.moduleVersionIdentifier), artifactName, componentArtifactMetadata.getId(), artifactSource);
                this.allResolvedArtifacts.put(componentArtifactMetadata.getId(), resolvedArtifact);
            }
            resolvedArtifacts.add(resolvedArtifact);
        }
        return resolvedArtifacts;
    }

    private static class LazyArtifactSource
    implements Factory<File> {
        private final ArtifactResolver artifactResolver;
        private final ModuleSource moduleSource;
        private final ComponentArtifactMetadata artifact;

        private LazyArtifactSource(ComponentArtifactMetadata artifact, ModuleSource moduleSource, ArtifactResolver artifactResolver) {
            this.artifact = artifact;
            this.artifactResolver = artifactResolver;
            this.moduleSource = moduleSource;
        }

        public File create() {
            DefaultBuildableArtifactResolveResult result = new DefaultBuildableArtifactResolveResult();
            this.artifactResolver.resolveArtifact(this.artifact, this.moduleSource, result);
            return (File)result.getResult();
        }
    }
}

