/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Arrays;
import java.util.Collection;
import org.gradle.api.Nullable;
import org.gradle.internal.component.external.model.AbstractModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.DefaultMutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ModuleSource;

public class DefaultMavenModuleResolveMetadata
extends AbstractModuleComponentResolveMetadata
implements MavenModuleResolveMetadata {
    public static final String POM_PACKAGING = "pom";
    public static final Collection<String> JAR_PACKAGINGS = Arrays.asList("jar", "ejb", "bundle", "maven-plugin", "eclipse-plugin");
    private final String packaging;
    private final boolean relocated;
    private final String snapshotTimestamp;

    DefaultMavenModuleResolveMetadata(MutableMavenModuleResolveMetadata metadata) {
        super(metadata);
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
    }

    private DefaultMavenModuleResolveMetadata(DefaultMavenModuleResolveMetadata metadata, ModuleSource source) {
        super(metadata, source);
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
    }

    @Override
    public DefaultMavenModuleResolveMetadata withSource(ModuleSource source) {
        return new DefaultMavenModuleResolveMetadata(this, source);
    }

    @Override
    public MutableMavenModuleResolveMetadata asMutable() {
        return new DefaultMutableMavenModuleResolveMetadata(this);
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return POM_PACKAGING.equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return JAR_PACKAGINGS.contains(this.packaging);
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }
}

