/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.coroutines;

import java.util.ArrayList;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.coroutines.ProcessUninitializedStoresKt;
import org.jetbrains.kotlin.codegen.coroutines.UninitializedNewValue;
import org.jetbrains.kotlin.codegen.coroutines.UninitializedNewValueMarkerInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.CustomFramesMethodAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\tH\u0002\u00a8\u0006\f"}, d2={"processUninitializedStores", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "getUninitializedValueForConstructorCall", "Lorg/jetbrains/kotlin/codegen/coroutines/UninitializedNewValue;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isConstructorCall", "", "kotlin-compiler"})
public final class ProcessUninitializedStoresKt {
    /*
     * WARNING - void declaration
     */
    public static final void processUninitializedStores(@NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull(methodNode, "methodNode");
        UninitializedNewValueMarkerInterpreter interpreter = new UninitializedNewValueMarkerInterpreter();
        Frame<V>[] frames2 = new CustomFramesMethodAnalyzer("fake", methodNode, interpreter, processUninitializedStores.frames.1.INSTANCE).analyze();
        for (IndexedValue<Object> indexedValue : ArraysKt.withIndex((Object[])methodNode.instructions.toArray())) {
            int n;
            void $receiver$iv;
            Set<AbstractInsnNode> copyUsages;
            UninitializedNewValue uninitializedValue;
            Frame<BasicValue> frame;
            int index2 = indexedValue.component1();
            AbstractInsnNode insn = (AbstractInsnNode)indexedValue.component2();
            if (frames2[index2] == null) {
                continue;
            }
            AbstractInsnNode abstractInsnNode = insn;
            Intrinsics.checkExpressionValueIsNotNull(abstractInsnNode, "insn");
            if (ProcessUninitializedStoresKt.getUninitializedValueForConstructorCall(frame, abstractInsnNode) == null) {
                continue;
            }
            if (interpreter.getUninitializedValuesToCopyUsages().get(uninitializedValue.getNewInsn()) == null) {
                Intrinsics.throwNpe();
            }
            boolean bl = copyUsages.size() > 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "At least DUP copy operation expected";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (copyUsages.size() == 1) continue;
            Iterable iterable = SetsKt.plus(copyUsages, uninitializedValue.getNewInsn());
            for (Object element$iv : $receiver$iv) {
                AbstractInsnNode it = (AbstractInsnNode)element$iv;
                methodNode.instructions.remove(it);
            }
            AbstractInsnNode abstractInsnNode2 = insn;
            if (abstractInsnNode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MethodInsnNode");
            }
            int indexOfConstructorArgumentFromTopOfStack = ((Object[])Type.getArgumentTypes(((MethodInsnNode)abstractInsnNode2).desc)).length;
            ArrayList<Type> storedTypes = CollectionsKt.arrayListOf(new Type[0]);
            int nextVarIndex = methodNode.maxLocals;
            IntRange intRange = RangesKt.until(0, indexOfConstructorArgumentFromTopOfStack);
            int it = intRange.getFirst();
            if (it <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    BasicValue value = frame.getStack(frame.getStackSize() - 1 - i);
                    Type type2 = value.getType();
                    methodNode.instructions.insertBefore(insn, new VarInsnNode(type2.getOpcode(54), nextVarIndex));
                    nextVarIndex += type2.getSize();
                    storedTypes.add(type2);
                    if (i == n) break;
                    ++i;
                }
            }
            methodNode.maxLocals = Math.max(methodNode.maxLocals, nextVarIndex);
            methodNode.instructions.insertBefore(insn, UtilKt.insnListOf(new TypeInsnNode(187, uninitializedValue.getNewInsn().desc), new InsnNode(89)));
            for (Type type3 : CollectionsKt.reversed((Iterable)storedTypes)) {
                methodNode.instructions.insertBefore(insn, new VarInsnNode(type3.getOpcode(21), nextVarIndex -= type3.getSize()));
            }
        }
    }

    private static final UninitializedNewValue getUninitializedValueForConstructorCall(@NotNull Frame<BasicValue> $receiver, AbstractInsnNode insn) {
        if (!ProcessUninitializedStoresKt.isConstructorCall(insn)) {
            return null;
        }
        boolean bl = insn.getOpcode() == 183;
        if (_Assertions.ENABLED && !bl) {
            String string = "Expected opcode Opcodes.INVOKESPECIAL for <init>, but " + insn.getOpcode() + " found";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        AbstractInsnNode abstractInsnNode = insn;
        if (abstractInsnNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.MethodInsnNode");
        }
        int paramsCountIncludingReceiver = ((Object[])Type.getArgumentTypes(((MethodInsnNode)abstractInsnNode).desc)).length + 1;
        BasicValue basicValue = $receiver.getStack($receiver.getStackSize() - (paramsCountIncludingReceiver + 1));
        if (!(basicValue instanceof UninitializedNewValue)) {
            basicValue = null;
        }
        UninitializedNewValue uninitializedNewValue = (UninitializedNewValue)basicValue;
        if (uninitializedNewValue == null) {
            String string = "Expected value generated with NEW";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        UninitializedNewValue newValue = uninitializedNewValue;
        boolean bl2 = $receiver.getStack($receiver.getStackSize() - paramsCountIncludingReceiver) instanceof UninitializedNewValue;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Next value after NEW should be one generated by DUP";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return newValue;
    }

    private static final boolean isConstructorCall(@NotNull AbstractInsnNode $receiver) {
        return $receiver instanceof MethodInsnNode && Intrinsics.areEqual(((MethodInsnNode)$receiver).name, "<init>");
    }

    @Nullable
    public static final /* synthetic */ UninitializedNewValue access$getUninitializedValueForConstructorCall(@NotNull Frame $receiver, @NotNull AbstractInsnNode insn) {
        return ProcessUninitializedStoresKt.getUninitializedValueForConstructorCall($receiver, insn);
    }
}

