/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.AnonymousObjectTransformationInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCallSiteInfo;
import org.jetbrains.kotlin.codegen.inline.LambdaInfo;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.RegeneratedClassContext;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.RootInliningContext;
import org.jetbrains.kotlin.codegen.inline.TypeRemapper;
import org.jetbrains.kotlin.codegen.state.GenerationState;

public class InliningContext {
    @Nullable
    private final InliningContext parent;
    private final Map<Integer, LambdaInfo> expressionMap;
    public final GenerationState state;
    public final NameGenerator nameGenerator;
    public final TypeRemapper typeRemapper;
    public final ReifiedTypeInliner reifiedTypeInliner;
    public final boolean isInliningLambda;
    public final boolean classRegeneration;
    public final Map<String, AnonymousObjectTransformationInfo> internalNameToAnonymousObjectTransformationInfo;
    private boolean isContinuation;

    public InliningContext(@Nullable InliningContext parent2, @NotNull Map<Integer, LambdaInfo> expressionMap, @NotNull GenerationState state2, @NotNull NameGenerator nameGenerator2, @NotNull TypeRemapper typeRemapper, @NotNull ReifiedTypeInliner reifiedTypeInliner, boolean isInliningLambda, boolean classRegeneration) {
        if (expressionMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionMap", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        if (nameGenerator2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameGenerator", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        if (typeRemapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeRemapper", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        if (reifiedTypeInliner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reifiedTypeInliner", "org/jetbrains/kotlin/codegen/inline/InliningContext", "<init>"));
        }
        this.internalNameToAnonymousObjectTransformationInfo = new HashMap<String, AnonymousObjectTransformationInfo>();
        this.parent = parent2;
        this.expressionMap = expressionMap;
        this.state = state2;
        this.nameGenerator = nameGenerator2;
        this.typeRemapper = typeRemapper;
        this.reifiedTypeInliner = reifiedTypeInliner;
        this.isInliningLambda = isInliningLambda;
        this.classRegeneration = classRegeneration;
    }

    @NotNull
    public InliningContext subInline(@NotNull NameGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInline"));
        }
        InliningContext inliningContext = this.subInline(generator, Collections.<String, String>emptyMap(), this.isInliningLambda);
        if (inliningContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInline"));
        }
        return inliningContext;
    }

    @NotNull
    public InliningContext subInlineLambda(@NotNull LambdaInfo lambdaInfo) {
        if (lambdaInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaInfo", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineLambda"));
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put(lambdaInfo.getLambdaClassType().getInternalName(), null);
        InliningContext inliningContext = this.subInline(this.nameGenerator.subGenerator("lambda"), map2, true);
        if (inliningContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineLambda"));
        }
        return inliningContext;
    }

    @NotNull
    public InliningContext subInlineWithClassRegeneration(@NotNull NameGenerator generator, @NotNull Map<String, String> newTypeMappings, @NotNull InlineCallSiteInfo callSiteInfo) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineWithClassRegeneration"));
        }
        if (newTypeMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTypeMappings", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineWithClassRegeneration"));
        }
        if (callSiteInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSiteInfo", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineWithClassRegeneration"));
        }
        RegeneratedClassContext regeneratedClassContext = new RegeneratedClassContext(this, this.expressionMap, this.state, generator, TypeRemapper.createFrom(this.typeRemapper, newTypeMappings), this.reifiedTypeInliner, this.isInliningLambda, callSiteInfo);
        if (regeneratedClassContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInlineWithClassRegeneration"));
        }
        return regeneratedClassContext;
    }

    @NotNull
    private InliningContext subInline(@NotNull NameGenerator generator, @NotNull Map<String, String> additionalTypeMappings, boolean isInliningLambda) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInline"));
        }
        if (additionalTypeMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalTypeMappings", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInline"));
        }
        InliningContext inliningContext = new InliningContext(this, this.expressionMap, this.state, generator, TypeRemapper.createFrom(this.typeRemapper, additionalTypeMappings, isInliningLambda && !this.isInliningLambda), this.reifiedTypeInliner, isInliningLambda, this.classRegeneration);
        if (inliningContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InliningContext", "subInline"));
        }
        return inliningContext;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @NotNull
    public RootInliningContext getRoot() {
        RootInliningContext rootInliningContext = this.isRoot() ? (RootInliningContext)this : this.parent.getRoot();
        if (rootInliningContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InliningContext", "getRoot"));
        }
        return rootInliningContext;
    }

    @Nullable
    public InliningContext getParent() {
        return this.parent;
    }

    @NotNull
    public InlineCallSiteInfo getCallSiteInfo() {
        assert (this.parent != null) : "At least root context should return proper value";
        InlineCallSiteInfo inlineCallSiteInfo = this.parent.getCallSiteInfo();
        if (inlineCallSiteInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/InliningContext", "getCallSiteInfo"));
        }
        return inlineCallSiteInfo;
    }

    @Nullable
    public AnonymousObjectTransformationInfo findAnonymousObjectTransformationInfo(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/codegen/inline/InliningContext", "findAnonymousObjectTransformationInfo"));
        }
        if (this.getRoot().internalNameToAnonymousObjectTransformationInfo.containsKey(internalName)) {
            return (AnonymousObjectTransformationInfo)this.getRoot().internalNameToAnonymousObjectTransformationInfo.get(internalName);
        }
        return null;
    }

    public boolean isContinuation() {
        return this.isContinuation;
    }

    public void setContinuation(boolean continuation) {
        this.isContinuation = continuation;
    }
}

