/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class ClsReferenceExpressionImpl
extends ClsElementImpl
implements PsiReferenceExpression {
    private final ClsElementImpl myParent;
    private final PsiReferenceExpression myPatternExpression;
    private final PsiReferenceExpression myQualifier;
    private final String myName;
    private final PsiIdentifier myNameElement;

    public ClsReferenceExpressionImpl(ClsElementImpl parent2, PsiReferenceExpression patternExpression) {
        this.myParent = parent2;
        this.myPatternExpression = patternExpression;
        PsiReferenceExpression patternQualifier = (PsiReferenceExpression)this.myPatternExpression.getQualifierExpression();
        this.myQualifier = patternQualifier != null ? new ClsReferenceExpressionImpl(this, patternQualifier) : null;
        this.myName = this.myPatternExpression.getReferenceName();
        this.myNameElement = new ClsIdentifierImpl(this, this.myName);
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public PsiExpression getQualifierExpression() {
        return this.myQualifier;
    }

    @Override
    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass aClass2) throws IncorrectOperationException {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "bindToElementViaStaticImport"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        throw new IncorrectOperationException("This method should not be called for compiled elements");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return this.myNameElement;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (this.myQualifier != null) {
            PsiElement[] psiElementArray = new PsiElement[]{this.myQualifier, this.myNameElement};
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "getChildren"));
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = new PsiElement[]{this.myNameElement};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "getChildren"));
        }
        return psiElementArray;
    }

    @Override
    public String getText() {
        return this.myQualifier != null ? this.myQualifier.getText() + "." + this.myName : this.myName;
    }

    @Override
    public boolean isQualified() {
        return this.myQualifier != null;
    }

    @Override
    public PsiType getType() {
        return this.myPatternExpression.getType();
    }

    @Override
    public PsiElement resolve() {
        return this.myPatternExpression.resolve();
    }

    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult = this.myPatternExpression.advancedResolve(incompleteCode);
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "advancedResolve"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        JavaResolveResult result2 = this.advancedResolve(incompleteCode);
        if (result2 != JavaResolveResult.EMPTY) {
            JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
            javaResolveResultArray = javaResolveResultArray2;
            javaResolveResultArray2[0] = result2;
        } else {
            javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
        }
        if (javaResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "multiResolve"));
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myPatternExpression.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public String getReferenceName() {
        return this.myPatternExpression.getReferenceName();
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "bindToElement"));
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.myPatternExpression.isReferenceTo(element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = this.myPatternExpression.getVariants();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "getVariants"));
        }
        return objectArray;
    }

    @Override
    public void processVariants(@NotNull PsiScopeProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "processVariants"));
        }
        this.myPatternExpression.processVariants(processor);
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "appendMirrorText"));
        }
        buffer.append(this.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.REFERENCE_EXPRESSION);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsReferenceExpressionImpl", "getTypeParameters"));
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }

    @Override
    public String toString() {
        return "PsiReferenceExpression:" + this.getText();
    }
}

