/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.picocontainer.defaults;

import java.util.Arrays;
import org.jetbrains.kotlin.org.picocontainer.PicoIntrospectionException;

public class AmbiguousComponentResolutionException
extends PicoIntrospectionException {
    private Class component;
    private Class ambiguousDependency;
    private final Object[] ambiguousComponentKeys;

    public AmbiguousComponentResolutionException(Class ambiguousDependency, Object[] componentKeys) {
        super("");
        this.ambiguousDependency = ambiguousDependency;
        this.ambiguousComponentKeys = new Class[componentKeys.length];
        for (int i = 0; i < componentKeys.length; ++i) {
            this.ambiguousComponentKeys[i] = componentKeys[i];
        }
    }

    @Override
    public String getMessage() {
        StringBuffer msg2 = new StringBuffer();
        msg2.append(this.component);
        msg2.append(" has ambiguous dependency on ");
        msg2.append(this.ambiguousDependency);
        msg2.append(", ");
        msg2.append("resolves to multiple classes: ");
        msg2.append(Arrays.asList(this.getAmbiguousComponentKeys()));
        return msg2.toString();
    }

    public Object[] getAmbiguousComponentKeys() {
        return this.ambiguousComponentKeys;
    }

    public void setComponent(Class component) {
        this.component = component;
    }
}

