/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.util.concurrent.Executor;
import org.gradle.api.Action;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.execution.taskgraph.AbstractTaskPlanExecutor;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParallelTaskPlanExecutor
extends AbstractTaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(ParallelTaskPlanExecutor.class);
    private final int executorCount;
    private final ExecutorFactory executorFactory;
    private final BuildOperationWorkerRegistry buildOperationWorkerRegistry;

    public ParallelTaskPlanExecutor(int numberOfParallelExecutors, ExecutorFactory executorFactory, BuildOperationWorkerRegistry buildOperationWorkerRegistry) {
        this.executorFactory = executorFactory;
        this.buildOperationWorkerRegistry = buildOperationWorkerRegistry;
        if (numberOfParallelExecutors < 2) {
            throw new IllegalArgumentException("Not a valid number of parallel executors: " + numberOfParallelExecutors);
        }
        this.executorCount = numberOfParallelExecutors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker) {
        StoppableExecutor executor = this.executorFactory.create("Task worker");
        try {
            this.startAdditionalWorkers(taskExecutionPlan, taskWorker, (Executor)executor);
            this.taskWorker(taskExecutionPlan, taskWorker, this.buildOperationWorkerRegistry).run();
            taskExecutionPlan.awaitCompletion();
        }
        finally {
            executor.stop();
        }
    }

    private void startAdditionalWorkers(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker, Executor executor) {
        LOGGER.info("Using {} parallel executor threads", (Object)this.executorCount);
        for (int i = 1; i < this.executorCount; ++i) {
            Runnable worker = this.taskWorker(taskExecutionPlan, taskWorker, this.buildOperationWorkerRegistry);
            executor.execute(worker);
        }
    }
}

